<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/vod/vod.php';
require_once 'lib/abstract_preloaded_regular_screen.php';

class VodSeasonListScreen extends AbstractPreloadedRegularScreen
    implements UserInputHandler
{
    const ID = 'vod_season';

    public static function get_media_url_str($movie_id, $season_url=null, $name=null, $info=null)
    {
		$arr['screen_id'] = self::ID;
        $arr['movie_id'] = $movie_id;
		if ($season_url == true)
			$arr['season_url'] = $season_url;
		if ($name == true)
			$arr['name'] = $name;
		if ($info == true)
			$arr['info'] = $info;
		return MediaURL::encode($arr);
    }

	public function get_handler_id()
    { return self::ID; }
    ///////////////////////////////////////////////////////////////////////

    private $vod;
	private $select_url = array();
	private $counter = 0;
    public function __construct(Vod $vod)
    {
        $this->vod = $vod;
        parent::__construct(self::ID, $this->get_folder_views());
        UserInputHandlerRegistry::get_instance()->
            register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
		$actions = array();
		$actions[GUI_EVENT_KEY_SETUP]		= ActionFactory::open_folder(SmartSetupScreen::get_media_url_str(),"Настройки");
		$actions[GUI_EVENT_KEY_ENTER]		= UserInputHandlerRegistry::create_action($this, 'add_actions');
		$actions[GUI_EVENT_KEY_PLAY]		= UserInputHandlerRegistry::create_action($this, 'add_actions');
		$actions[GUI_EVENT_KEY_POPUP_MENU]	= UserInputHandlerRegistry::create_action($this, 'popup_menu');
		$actions[GUI_EVENT_KEY_INFO]		= UserInputHandlerRegistry::create_action($this, 'aria_inf');
		$actions[GUI_EVENT_KEY_SELECT]		= UserInputHandlerRegistry::create_action($this, 'select');
		$add_action 						= UserInputHandlerRegistry::create_action($this, 'viewed');
        $add_action['caption']				= 'Просмотрено/Не просмотрено';
		$actions[GUI_EVENT_KEY_B_GREEN]		= $add_action;
		return $actions;
    }
	
	public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        $attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
		if ($user_input->control_id === 'cleer_folder')
		{
			if (!isset($user_input->parent_media_url))
				return null;
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$sel_ndx = $user_input->sel_ndx;
				if ($sel_ndx < 0)
					$sel_ndx = 0;
			$range = $this->get_folder_range($parent_media_url, 0, $plugin_cookies);
			return ActionFactory::update_regular_folder($range, true, $sel_ndx);
		}
		
		if ($user_input->control_id === 'cleer_folder_plus')
		{
			if (!isset($user_input->parent_media_url))
				return null;
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$sel_ndx = $user_input->sel_ndx+1;
				if ($sel_ndx < 0)
					$sel_ndx = 0;
			$range = $this->get_folder_range($parent_media_url, 0, $plugin_cookies);
			return ActionFactory::update_regular_folder($range, true, $sel_ndx);
		}
				
		if ($user_input->control_id == 'select')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			if (isset($media_url->series_id)){
				$links = $this->select_url;
				$_links = array_flip ($links);
				if (isset($links[$media_url->series_id]))
					unset ($links[$media_url->series_id]);
				else if (isset($_links[$media_url->series_name])){
					unset ($_links[$media_url->series_name]);
					$links = array_flip($_links);
				}else
					$links[$media_url->series_id] = $media_url->series_name;
				$this->select_url = $links;
				$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder_plus');
				return ActionFactory::invalidate_folders(array('vod_series'), $perform_new_action);
			}
		}
		
		if ($user_input->control_id == 'aria_download')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$file= false;
			$preferred_width = 1000;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$dload_dir_path = smbtree::get_folder_info ('dload_dir_path');
			$video_quality = (HD::get_item('video_quality') !='') ? HD::get_item('video_quality') : 1;
			if (!file_exists($dload_dir_path))
				return  ActionFactory::show_title_dialog('Папка для закачки не найдена!!!',null,"Папка не выбрана или удалена! Перейдите в настроки плагина (кнопка SETUP пульта) и выберите папку для закачки.",800,1);
			$dload_url = $media_url->series_id;
			$dload_name = str_replace("'", '', $media_url->series_name);
			if (preg_match('|moonwalk|', $dload_url)){
				$dload_url = mUrl::get_link($dload_url .'&rerferer='.$dload_url, $video_quality);
				$dload_list = HD::get_items('dload_list');
				$dload_list[$dload_url] = array ('dload_dir_path' => $dload_dir_path, 'folder_movie' => $this->vod->folder_movie, 'rd_url' => $media_url->series_id, 'dload_name' => $dload_name .'.ts');
				if (HD::get_lock_items()=='unlock')
					HD::save_items('dload_list',$dload_list);
				if (file_exists('/codecpack/script/mw_download'))
					shell_exec('/codecpack/script/mw_download start' .' "' . $dload_name .'" "' . $dload_dir_path .'" "' . $dload_url .'" '. '> /dev/null &');
				foreach (glob("$dload_dir_path/*.ts.part") as $file)
					clearstatcache();
				if (($file==true)&&(file_exists("$dload_dir_path/$file.ts.part")))
					return ActionFactory::show_title_dialog_glass("Подождите окончания загрузки");
				else{
					$do_aria_inf = UserInputHandlerRegistry::create_action($this, 'aria_inf');
					ControlFactory::add_label($defs, "", "Старт..."); 
					$attrs['timer'] = ActionFactory::timer(3000);
					$attrs['actions'] = array(GUI_EVENT_TIMER => ActionFactory::close_dialog_and_run($do_aria_inf));
					return  ActionFactory::show_dialog('Старт закачки',$defs,true, $preferred_width,$attrs);
				}
					
			}else{
				$dload_list = HD::get_items('dload_list');
				$dload_list[$dload_url] = array ('dload_dir_path' => $dload_dir_path, 'folder_movie' => $this->vod->folder_movie, 'rd_url' => $media_url->series_id);
				if (HD::get_lock_items()=='unlock')
					HD::save_items('dload_list',$dload_list);
				$dload_app = HD::get_dload_app();
				$dload_url = str_replace('http://mp4://','http://', $dload_url);
				exec("$dload_app -x2 --file-allocation=none --continue=true --log-level=info \"$dload_url\" --dir=\"$dload_dir_path\" > ".DuneSystem::$properties['tmp_dir_path']. "/aria.log &");
			}
			return UserInputHandlerRegistry::create_action($this, 'aria_inf');
		}
		
		if ($user_input->control_id == 'play_link')
        {
            $video_quality = (HD::get_item('video_quality') !='') ? HD::get_item('video_quality') : 1;
			if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$play_link = $media_url->series_id;
			if(preg_match('|moonwalk|', $play_link))
				$play_link = mUrl::get_link($play_link .'&rerferer='.$play_link, $video_quality);
			return ActionFactory::launch_media_url($play_link);
		}
		if ($user_input->control_id == 'aria_stop')
        {
            $dload_dir_path = smbtree::get_folder_info ('dload_dir_path');
			foreach (glob("$dload_dir_path/*.ts.part") as $file)
					clearstatcache();
			if (($file==true)&&(file_exists($file))){
				$name = substr(str_replace("$dload_dir_path/",'',$file),0,-8);
				if (file_exists('/codecpack/script/mw_download'))
					shell_exec('/codecpack/script/mw_download stop "' . $name .'" "' .$dload_dir_path .'" > /dev/null &');
				return ActionFactory::show_title_dialog_gl('Загрузка остановлена!');
			}else{
				$q = shell_exec("$dload_app-stop");
				unlink(DuneSystem::$properties['tmp_dir_path']. "/aria.log");
				if (file_exists(DuneSystem::$properties['tmp_dir_path']. "/aria"))
					unlink(DuneSystem::$properties['tmp_dir_path']. "/aria");
				return ActionFactory::show_title_dialog_gl($q);
			}
		}
		
		if ($user_input->control_id == 'open_folder')
		{
			$media_url = unserialize(file_get_contents(DuneSystem::$properties['data_dir_path'] .'/dload_dir_path'));
			$path = smbtree::get_folder_info ('dload_dir_path');
			if (preg_match('|^/tmp/mnt/storage/|', $path))
				$path = preg_replace('|^/tmp/mnt/storage/|', 'storage_name://', $path);
			else if ((isset($media_url['ip_path']))&&(preg_match('|^/tmp/mnt/smb/|', $path))&&($media_url['user']==true)&&($media_url['password']==true))
				$path = 'smb://'. $media_url['user'] .':'. $media_url['password'] .'@'. preg_replace("|^\/tmp\/mnt\/smb\/\d|", str_replace('//', '',$media_url['ip_path']), $path);
			else if ((isset($media_url['ip_path']))&&(preg_match('|^/tmp/mnt/smb/|', $path)))
				$path = 'smb:' . preg_replace("|^\/tmp\/mnt\/smb\/\d|", $media_url['ip_path'], $path);
			else if ((isset($media_url['ip_path']))&&(preg_match('|^/tmp/mnt/network/|', $path))&&($media_url['nfs_protocol']==true)){
				if ($media_url['nfs_protocol']=='tcp')
					$path = 'nfs-tcp://' . preg_replace("|^\/tmp\/mnt\/network\/\d|", $media_url['ip_path'].':/', $path);
				else
					$path = 'nfs-udp://' . preg_replace("|^\/tmp\/mnt\/network\/\d|", $media_url['ip_path'].':/', $path);
			}
			$url = 'embedded_app://{name=file_browser}{url='.$path.'}{caption=File Browser}';
			return ActionFactory::launch_media_url($url);
		};
				
		if ($user_input->control_id == 'aria_inf')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			if ($this->counter < 5)
				$this->counter = $this->counter+1;
			else
				$this->counter = 0;
			$preferred_width = 1000;
			$dload_dir_path = smbtree::get_folder_info ('dload_dir_path');
			$do_aria_inf = UserInputHandlerRegistry::create_action($this, 'aria_inf');
			$file=false;
			foreach (glob("$dload_dir_path/*.ts.part") as $file)
					clearstatcache();
			if (($file==true)&&(file_exists($file))){
				if (file_exists(DuneSystem::$properties['tmp_dir_path']. '/aria.log'))
					unlink(DuneSystem::$properties['tmp_dir_path']. "/aria.log");
				$name = substr(str_replace("$dload_dir_path/",'',$file),0,-5);
			    $size = shell_exec("du -m '" . $file ."' | awk '{print($1)}'");
			    $total=`cat /tmp/mw_total`;
			    $prozent = shell_exec('let procent=`grep -c "segment" /tmp/mw`*100/"' . $total . '" ; echo $procent"%"');
			    $p = str_replace('%', '', $prozent);
			    $defs = array(); 						
			    ControlFactory::add_label($defs, "", "Файл      : ".$name); 						
			    ControlFactory::add_label($defs, "", "Загружено : ".$size . ' Мб');
			    ControlFactory::add_label($defs, "", "Статус    : ".$prozent); 
				$attrs['timer'] = ActionFactory::timer(3000);
					$attrs['actions'] = array(GUI_EVENT_TIMER => ActionFactory::close_dialog_and_run($do_aria_inf));
					ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'aria_stop',	'Остановить закачку',500, UserInputHandlerRegistry::create_action($this, 'aria_stop'));
					ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'dload_list', 'Загрузки',500, ActionFactory::open_folder('dload_list', 'Загрузки'));
					return  ActionFactory::show_dialog(str_repeat(" ", $this->counter).'Состояние закачки'. str_repeat(".", $this->counter),$defs,true, $preferred_width,$attrs);
			}else{
				$q = array();
				$preferred_width = 1400;
				$nmr = $size = $speed = $downloaded = $prsnt = $eta =
				$dfile = $qq = $d_complete = $status = false;
				if (file_exists(DuneSystem::$properties['tmp_dir_path']. '/aria.log')){
					$log = file_get_contents (DuneSystem::$properties['tmp_dir_path']. '/aria.log');
					if (preg_match('|================================================================================|', $log)){
						$tmp = explode ("================================================================================", $log);
						$log = array_pop($tmp);
						$fp = fopen(DuneSystem::$properties['tmp_dir_path']. '/aria.log', 'w');
						fwrite($fp, $log);
						fclose($fp);
					}
					$q = file(DuneSystem::$properties['tmp_dir_path']. '/aria.log', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
					if (isset($q[0])){
						foreach ($q as $v){
							if (preg_match("|#(.*?)\s|", $v, $matches)){
								$nmr = $matches[1];
								if (preg_match("|SIZE:(.*?)\/(.*?)\((.*?)\)\s|", $v, $matches)){
									$downloaded = $matches[1];
									$size = $matches[2];
									$prsnt = $matches[3];
								}
								if (preg_match("|\s(.*?)\/(.*?)\((.*?)\)\s|", $v, $matches)){
									$downloaded = $matches[1];
									$size = $matches[2];
									$prsnt = $matches[3];
								}
								if (preg_match("|ETA:(.*?)\]|", $v, $matches))
									$eta = $matches[1];
								if (preg_match("|SPD:(.*?)\s|", $v, $matches))
									$speed = $matches[1];
								if (preg_match("|DL:(.*?)\s|", $v, $matches))
									$speed = $matches[1];
							}else if (preg_match("|Download complete: (.*)|", $v, $matches))
								$d_complete = basename($matches[1])."\n" . $d_complete;
							else if (preg_match("|FILE: (.*)|", $v, $matches))
								$dfile = basename($matches[1]);
							else if (preg_match("#(\d*?)\|(.*?)\|(.*?)\|(.*)#", $v, $matches)){
								$nmr = $matches[1];
								$status = trim($matches[2]);
								if ($status== 'stat')
									continue;
								$speed = trim($matches[3]);
								$name = basename($matches[4]);
								$qq .= "[$nmr][$status] $name => [$speed]\n";
							}else if (preg_match("|download completed|", $v))
								$qq2 = "Закачки завершены";
						}
					}
					else{
						$qq2 = str_repeat(" ", $this->counter)."Закачка запущена". str_repeat(".", $this->counter);
						$qq = str_repeat(" ", $this->counter)."Старт". str_repeat(".", $this->counter);
						$status = 2;
						$preferred_width = 1000;
					}
				}else{
					$qq2 = "Закачки остановленны";
					$qq = "Активных закачек нет";
					$status = true;
					$preferred_width = 1000;
				}
				if ($status == false){
					ControlFactory::add_label($defs, '', str_repeat(".", round($prsnt/2)));
					ControlFactory::add_multiline_label($defs, 'Качаем:#'.$nmr, "[$size] $dfile",2);
					ControlFactory::add_label($defs, 'Скачано:', "[$downloaded][$prsnt] Скорость:$speed Осталось: $eta");
					if ($d_complete == true)
						ControlFactory::add_multiline_label($defs, 'Завершено:', $d_complete, 10);
					$attrs['timer'] = ActionFactory::timer(3000);
					$attrs['actions'] = array(GUI_EVENT_TIMER => ActionFactory::close_dialog_and_run($do_aria_inf));
					ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'aria_stop',	'Остановить закачку',500, UserInputHandlerRegistry::create_action($this, 'aria_stop'));
					ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'dload_list', 'Загрузки',500, ActionFactory::open_folder('dload_list', 'Загрузки'));
					return  ActionFactory::show_dialog(str_repeat(" ", $this->counter).'Состояние закачки'. str_repeat(".", $this->counter),$defs,true, $preferred_width,$attrs);
				}else{
					ControlFactory::add_multiline_label($defs, '', $qq, 10);
					if ($status != 2)
						ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'open_folder','Открыть папку',300, UserInputHandlerRegistry::create_action($this, 'open_folder'));
					$attrs['timer'] = ActionFactory::timer(3000);
					$attrs['actions'] = array(GUI_EVENT_TIMER => ActionFactory::close_dialog_and_run($do_aria_inf));
					return  ActionFactory::show_dialog($qq2,$defs,true, $preferred_width,$attrs);
				}
			}
			
		}
		
		if ($user_input->control_id == 'popup_menu')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			if (isset($media_url->series_id)){
				$menu_items[] = array(
					GuiMenuItemDef::caption => 'Проиграть файл напрямую',
					GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'play_link'),
					GuiMenuItemDef::icon_url => 'gui_skin://small_icons/radiotime.aai'
					);
					
				if (HD::get_dload_app()==true) {
					$menu_items [] =  array(GuiMenuItemDef::is_separator => true);
					$menu_items[] = array(
					GuiMenuItemDef::caption => 'Скачать',
					GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'aria_download'),
					GuiMenuItemDef::icon_url => "plugin_file://icons/dload.png"
					);
					// $menu_items[] = array(
					// GuiMenuItemDef::caption => 'Скачать все или выделенные (SELECT)',
					// GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'aria_download_all'),
					// GuiMenuItemDef::icon_url => "plugin_file://icons/dload.png"
					// );
					$menu_items[] = array(
					GuiMenuItemDef::caption => 'Состояние закачки (INFO)',
					GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'aria_inf'),
					GuiMenuItemDef::icon_url => 'gui_skin://small_icons/info.aai'
					);
					$menu_items [] =  array(GuiMenuItemDef::is_separator => true);
				}
			}
			$menu_items[] = array(
            GuiMenuItemDef::caption => 'Задать бекграунд',
            GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'add_vod_list_bg'),
			GuiMenuItemDef::icon_url => 'gui_skin://small_icons/photo_viewer.aai'
			);
			
			$plugin_ico = HD::get_items('plugin_ico');
			if (isset($plugin_ico['vod_list_bg'])){
				$menu_items[] = array(
				GuiMenuItemDef::caption => 'Удалить бекграунд',
				GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'del_vod_list_bg'),
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
				);
			}
            return ActionFactory::show_popup_menu($menu_items);
        }
		if ($user_input->control_id == 'viewed')
		{
			if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$m_url = MediaURL::decode($user_input->parent_media_url);
			$save_folder = HD::get_items('save_folder');
			if (isset($save_folder[$media_url->movie_id][$m_url->season_id])&&
			(($save_folder[$media_url->movie_id][key($save_folder[$m_url->season_id])]) != 'not_check')){
				$save_folder[$media_url->movie_id][$m_url->season_id][] = $series->season_url;
				HD::save_items('save_folder', $save_folder);
			}			
			$viewed_items = HD::get_items('viewed_items');
			$is_viewed = (array_key_exists($media_url->series_name, $viewed_items)) ? 1 : 0;
			if ($is_viewed == 1)
				unset ($viewed_items[$media_url->series_name]);
			else
				$viewed_items[$media_url->series_name] = 'viewed';
			HD::save_items('viewed_items', $viewed_items);
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array($user_input->selected_media_url), $perform_new_action);
		}
		if ($user_input->control_id === 'cleer_folder')
		{
			if (!isset($user_input->parent_media_url))
				return null;
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$sel_ndx = $user_input->sel_ndx;
				if ($sel_ndx < 0)
					$sel_ndx = 0;
			$range = $this->get_folder_range($parent_media_url, 0, $plugin_cookies);
			return ActionFactory::update_regular_folder($range, true, $sel_ndx);
		}
		if ($user_input->control_id == 'add_actions')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			if (isset($media_url->series_id))
				return ActionFactory::vod_play();
			else
				return ActionFactory::open_folder();
        }
        return null;
    }
    ///////////////////////////////////////////////////////////////////////

    public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies)
    {
        $this->vod->folder_entered($media_url, $plugin_cookies);
        $movie = $this->vod->get_loaded_movie($media_url->movie_id, $media_url->kp_id, $media_url->name, $plugin_cookies);
		$movie->series_list = null;
        if ($movie === null)
            return array();
        $items = array();
		$viewed_items = HD::get_items('viewed_items');
		$new_items = HD::get_items('new_items');
		$season_img = $movie->poster_url;
		if (isset ($media_url->season_url)){
			$season_list = SmartConfig::parse_season_page($media_url->movie_id, $media_url->season_id, $movie, $plugin_cookies);
			foreach ($season_list as $k => $v){
				$tt = $new = ''; $color = 15;
				$img = 'gui_skin://small_icons/folder.aai';
				if (isset($v['file_link'])){
					if (isset($viewed_items[$k])){
						if ($viewed_items[$k] =='viewed')
							$tt = '[ПРОСМ] ';
						else
							$tt = '[ПРОСМ ' . HD::sec_format_duration($viewed_items[$k][0]) . '/' . HD::sec_format_duration($viewed_items[$k][1]) . '] ';
							$color = 3;
					}
					$mUrl = MediaURL::encode(
								array
								(
									'screen_id'		=> self::ID,
									'movie_id'		=> $movie->id,
									'series_id'		=> $v['file_link'],
									'series_name'	=> $k,
								));
					$img = 'gui_skin://small_icons/movie.aai';
					$movie->add_series_data(
						$movie->id,
						$k,
						$img,
						$v['file_link'],
						false,
						false,
						$v['file_size']);
				}else if ($v['folder_filelist']== true)
					$mUrl = VodSeriesListScreen::get_media_url_str($movie->id, $v['folder'], $v['folder']);
				else
					$mUrl = self::get_media_url_str($movie->id, $v['folder']);
				$items[] = array
				(
					PluginRegularFolderItem::media_url => $mUrl,
					PluginRegularFolderItem::caption => $new . $tt . $k,
					PluginRegularFolderItem::view_item_params => array
					(
						ViewItemParams::icon_path => $img,
						ViewItemParams::item_detailed_icon_path => $season_img,
						ViewItemParams::item_caption_color => $color,
						ViewParams::background_path=> SmartConfig::get_plugin_ico('season_list_bg'),
					),
				);
			}
			return $items;
		}	
        foreach ($movie->season_list as $series)
        {
			$tt = false; $new = ''; $color = 15;
			if (isset($viewed_items[$series->name])){
				if ($viewed_items[$series->name] =='viewed')
					$tt = '';
				else
					$tt = '[' . HD::sec_format_duration($viewed_items[$series->name][0]) . '/' . HD::sec_format_duration($viewed_items[$series->name][1]) . '] ';
					$color = 3;
			}
			
			$mUrl = MediaURL::encode(
                        array
                        (
							'screen_id'		=> self::ID,
							'movie_id'		=> $movie->id,
							'series_id'		=> $series->season_url,
							'series_name'	=> $series->name,
                        ));
						
			if ($series->type == 'folder'){
				$img = 'gui_skin://small_icons/folder.aai';
				if ((preg_match("/serials\//i",$movie->id))||(preg_match("/tvshow\//i",$movie->id)))
					$mUrl = self::get_media_url_str($movie->id, $series->season_url);
				else
					$mUrl = VodSeriesListScreen::get_media_url_str($movie->id, $series->season_url);
			}
			else if ($series->type == 'screenshot'){
				$img = 'gui_skin://small_icons/photo_viewer.aai';
				$season_img = $series->season_url;
				$movie->add_series_data(
					$movie->id,
					$series->name,
					$img,
					$series->season_url,
					false);
			}
			else{
				$img = 'gui_skin://small_icons/movie.aai';
				if (isset($viewed_items[$series->name]))
					$img = 'gui_skin://small_icons/playback.aai';
				$movie->add_series_data(
					$movie->id,
					$series->name,
					$img,
					$series->season_url,
					false);
			}
			$_links = array_flip ($this->select_url);
				if (isset($this->select_url[$series->season_url]))
					$color = 18;
				else if (isset($_links[$series->name]))
					$color = 18;
			$items[] = array
            (
                PluginRegularFolderItem::media_url => $mUrl,
                PluginRegularFolderItem::caption => $new . $tt . $series->name,
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $img,
					ViewItemParams::item_detailed_icon_path => $season_img,
					ViewItemParams::item_caption_color => $color,
					ViewParams::background_path=> SmartConfig::get_plugin_ico('season_list_bg'),
                ),
            );
        }

        return $items;
    }

    ///////////////////////////////////////////////////////////////////////

    private function get_folder_views()
    {
        return array(
            array
            (
				PluginRegularFolderView::async_icon_loading => false,
                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 1,
                    ViewParams::num_rows => 12,
					ViewParams::paint_details => true,
					ViewParams::paint_item_info_in_details => true,
					ViewParams::item_detailed_info_auto_line_break => true,
					ViewParams::item_detailed_info_title_color => 10,
					ViewParams::item_detailed_info_text_color => 15,
					ViewParams::background_path=> SmartConfig::get_plugin_ico('season_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_layout => HALIGN_LEFT,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::icon_dx => 10,
                    ViewItemParams::icon_dy => -5,
                    ViewItemParams::item_caption_dx => 60,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			array
            (
				PluginRegularFolderView::async_icon_loading => false,
                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 1,
                    ViewParams::num_rows => 12,
					ViewParams::paint_details => false,
					ViewParams::background_path=> SmartConfig::get_plugin_ico('season_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_layout => HALIGN_LEFT,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::icon_dx => 10,
                    ViewItemParams::icon_dy => -5,
                    ViewItemParams::item_caption_dx => 60,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
        );
    }

    public function get_archive(MediaURL $media_url)
    {
        return $this->vod->get_archive($media_url);
    }
}

///////////////////////////////////////////////////////////////////////////
?>
