<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/screen.php';
require_once 'lib/vod/vod.php';
require_once 'lib/vod/vod_series_list_screen.php';

class VodMovieScreen implements Screen, UserInputHandler
{
    const ID = 'vod_movie';

    public static function get_media_url_str($movie_id, $name=false, $poster_url=false, $info=false, $kp_id=false)
    {
		$arr['screen_id'] = self::ID;
        $arr['movie_id'] = $movie_id;
		if ($name == true)
			$arr['name'] = $name;
		if ($poster_url == true)
			$arr['poster_url'] = $poster_url;
		if ($info == true)
			$arr['info'] = $info;
		if ($kp_id == true)
			$arr['kp_id'] = $kp_id;
        return MediaURL::encode($arr);		
    }

    ///////////////////////////////////////////////////////////////////////

    private $vod;

    public function __construct(Vod $vod)
    {
        $this->vod = $vod;

        UserInputHandlerRegistry::get_instance()->
            register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_id()
    { return self::ID; }

    public function get_handler_id()
    { return self::ID; }

    ///////////////////////////////////////////////////////////////////////

    public function get_folder_view(MediaURL $media_url, &$plugin_cookies)
    {
		$backgr_view = isset($plugin_cookies->backgr_view) ? $plugin_cookies->backgr_view : 'yes';
		$this->vod->folder_entered($media_url, $plugin_cookies);
		$this->vod->folder_movie = $media_url->get_raw_string();
        $movie = $this->vod->get_loaded_movie($media_url->movie_id, $media_url->kp_id, $media_url->name, $plugin_cookies);
        if ($movie === null)
			return null;
		$save_folder = HD::get_items('save_folder');
		if (isset($save_folder[$movie->id]))
			$mUrl = VodSeriesListScreen::get_media_url_str($movie->id, key($save_folder[$movie->id]));
		else if (!preg_match("/serial/i",$movie->id))
			$mUrl = VodSeriesListScreen::get_media_url_str($movie->id);
		else
			$mUrl = VodSeasonListScreen::get_media_url_str($movie->id);
		if (($backgr_view =='yes')&&($movie->images==true))
			$background_url = $movie->images[array_rand($movie->images)];
		else
			$background_url = 'gui_skin://images/bg.jpg';
        $movie_folder_view = array
        (
            PluginMovieFolderView::movie => $movie->get_movie_array(),
            PluginMovieFolderView::has_right_button => true,
            PluginMovieFolderView::right_button_caption => "Действия",
            PluginMovieFolderView::right_button_action => 
			UserInputHandlerRegistry::create_action($this, 'button_actions'),
            PluginMovieFolderView::has_multiple_series => true,
            PluginMovieFolderView::series_media_url => $mUrl,
			PluginMovieFolderView::params => array
            (			               
				PluginFolderViewParams::paint_path_box =>false,
                PluginFolderViewParams::paint_content_box_background => true,
               	PluginFolderViewParams::background_url => $background_url
				
            )
        );

        return array
        (
            PluginFolderView::multiple_views_supported  => false,
            PluginFolderView::archive                   => null,
            PluginFolderView::view_kind                 => PLUGIN_FOLDER_VIEW_MOVIE,
            PluginFolderView::data                      => $movie_folder_view,
        );
    }

    ///////////////////////////////////////////////////////////////////////

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {		
		$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
		if ($user_input->control_id == 'button_actions')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$this->vod->ensure_favorites_loaded($plugin_cookies);
            $is_favorite = $this->vod->is_favorite_movie_id($user_input->parent_media_url);
			if ($is_favorite)
				$caption = 'Удалить из Избранного';
			else
				$caption = 'Добавить в Избранное';
			$add_favorite_action = UserInputHandlerRegistry::create_action($this, 'add_favorite');
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$movie = $this->vod->get_loaded_movie($media_url->movie_id, $media_url->kp_id, null, $plugin_cookies);
			$poxog = $movie->poxog;
			$relap = $movie->relap;
			$defs = array();
			
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_works', $caption, 600, $add_favorite_action);
			if (preg_match("|serial\/|",$media_url->movie_id)){
				$add_action = UserInputHandlerRegistry::create_action($this, 'episodes_info');
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_works', 'Сезоны и эпизоды', 600, $add_action);
			}
			$add_action = UserInputHandlerRegistry::create_action($this, 'search');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_works', 'Поиск', 600, $add_action);
			// if ($movie->other_link != ''){
				// $add_action = UserInputHandlerRegistry::create_action($this, 'go_other_link');
				// ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_link', 'Другие работы актеров', 600, $add_action);
			// }
			if (isset($poxog->items)){
				$add_action = UserInputHandlerRegistry::create_action($this, 'go_poxog');
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_poxog', 'Похожие', 600, $add_action);
			}
			// $add_action = UserInputHandlerRegistry::create_action($this, 'go_other_works');
			// ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_works', 'Жанр, год и страна', 600, $add_action);
			return ActionFactory::show_dialog('Действия', $defs, true, 0,$attrs);
		}
		if ($user_input->control_id == 'episodes_info')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$movie = $this->vod->get_loaded_movie($media_url->movie_id, $media_url->kp_id, null, $plugin_cookies);			
			$jsd = json_decode(HD::http_get_document('http://api.kinopoisk.cf/tvshow/calendar?kinopoiskID='.$movie->kp_id));
			if (gettype($jsd)=='object'){
				$jsd = array_reverse((array)$jsd,true);
				$info = '';
				foreach ($jsd as $season => $vel){
					$info .= "Сезон - $season\n";
					$vel = array_reverse((array)$vel,true);
					foreach ($vel as $k => $v){
						if ($v->name_ru != '')
							$name = $v->name_ru . ' ('. $v->name . ')';
						else
							$name = $v->name;
						if (preg_match("|(\d*?)-(\d*?)-(\d*)|", $v->date,$matches))
							$date = $matches[3].'.'.$matches[2].'.'.$matches[1];
						else
							$date = $v->date;
						if ($v->published == 1)
							$info .= 's'.$season."e$k [Вышла :$date] - $name\n";
						else
							$info .= 's'.$season."e$k [$date] - $name\n";
					}
				}
			}else{
				$doc = iconv('windows-1251', 'UTF-8', HD::http_get_document("http://www.kinopoisk.ru/film/".$movie->kp_id."/episodes/"));
				if (preg_match('|<b>Сезоны:</b>(.*?)</tr>|ms', $doc, $matches))
					ControlFactory::add_label($defs, "", 'Сезоны:'.HD::str_remove_tag($matches[1]));
				if (preg_match('|<b>Годы:</b>(.*?)</tr>|ms', $doc, $matches))
					ControlFactory::add_label($defs, "", 'Годы:'.HD::str_remove_tag($matches[1]));
				if (preg_match('|<b>Время:</b>(.*?)</tr>|ms', $doc, $matches))
					ControlFactory::add_multiline_label($defs, '', 'Время:'.HD::str_remove_tag($matches[1]), 2);
				if (preg_match_all("|<tr>(.*?)</tr>|ms", $doc, $matches)){
					$info = '';
					foreach ($matches[1] as $k => $v){
						if (preg_match("/moviename-big/",$v))
							$info .= HD::str_remove_tag(str_replace(array ("<br>",'</h1>' )," ", $v)) . "\n";
					}
					
				}	
			}
			ControlFactory::add_multiline_label($defs, '', $info, 10);
			return ActionFactory::show_dialog('Сезоны', $defs, true, 1200,$attrs);
		}
				
		if ($user_input->control_id == 'go_other_works')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$movie = $this->vod->get_loaded_movie($media_url->movie_id, $media_url->kp_id, null, $plugin_cookies);
			foreach ($movie->entity_link as $k => $v){
				$add_action = ActionFactory::open_folder(SmartVodListScreen::get_media_url_str($v[1]), $v[2]);
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_works', $v[2], 600, $add_action);
			}
			return ActionFactory::show_dialog('Жанр, год и страна', $defs, true, 0,$attrs);
		}
		
		if ($user_input->control_id == 'search')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$use_osk = (HD::get_item('use_osk') !='') ? HD::get_item('use_osk') : 1;
			$defs = array();
			ControlFactory::add_text_field($defs,
			$this, $add_params=null,
			'do_new_search', '',
			$media_url->name, 0, 0, $use_osk, 1, 1300,0,1);
			if ($use_osk == 1)
				ControlFactory::add_vgap($defs, 500);
			return ActionFactory::show_dialog('Поиск', $defs, true, 0,$attrs);
		}
		
		if ($user_input->control_id == 'do_new_search')
        {
			$do_search = UserInputHandlerRegistry::create_action($this, 'do_search');
			return ActionFactory::close_dialog_and_run($do_search);
		}
		
		if ($user_input->control_id == 'do_search')
        {
			$media_url = MediaURL::decode($user_input->selected_media_url);
			HD::save_item('search_item', $user_input->do_new_search);
			$search_items = HD::get_items('search_items');
			$k = array_search($user_input->do_new_search, $search_items);
			if ($k !== false)
				unset ($search_items [$k]);
			array_unshift($search_items, $user_input->do_new_search); 
			HD::save_items('search_items', $search_items);
			$action = ActionFactory::open_folder(SmartVodListScreen::get_media_url_str('search', $user_input->do_new_search), "Поиск: ".$user_input->do_new_search);
			return ActionFactory::invalidate_folders(array('search_screen'),$action);
		}
		
		if ($user_input->control_id == 'go_poxog')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$movie = $this->vod->get_loaded_movie($media_url->movie_id, $media_url->kp_id, null, $plugin_cookies);
			return ActionFactory::open_folder(VodOthetScreen::get_media_url_str('another', $movie->poxog), 'Похожие');
		}
		
		if ($user_input->control_id == 'go_other_link')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$movie = $this->vod->get_loaded_movie($media_url->movie_id, $media_url->kp_id, null, $plugin_cookies);
			return ActionFactory::open_folder(VodActorScreen::get_media_url_str('other_link', $movie->other_link), 'Другие работы');
		}
		
		if ($user_input->control_id == 'add_favorite')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$this->vod->ensure_favorites_loaded($plugin_cookies);
			$is_favorite = $this->vod->is_favorite_movie_id($user_input->selected_media_url);
			$ufav_itms = HD::get_items('ufav_itms');
			if (!empty($ufav_itms)){
				if ($is_favorite)
					$caption = 'Удалить из Избранного';
				else
					$caption = 'Добавить в Избранное';
				$add_favorite_action = UserInputHandlerRegistry::create_action($this, 'add_fav');
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_works', $caption, 600, $add_favorite_action);
				foreach ($ufav_itms as $k => $v){
					$caption = "Добавить в: $v";
					$params['ufav_itms_name'] = $k;
					$add_favorite_action = UserInputHandlerRegistry::create_action($this, 'add_fav_itm',$params);
					ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_works', $caption, 600, $add_favorite_action);
				}
				return ActionFactory::show_dialog('Избранное', $defs, true, 0,$attrs);
			}else{
				if ($is_favorite){
					$media_url = MediaURL::decode($user_input->selected_media_url);
					$save_folder = HD::get_items('save_folder');
					if (isset($save_folder[$media_url->movie_id])){
						unset ($save_folder[$media_url->movie_id]);
						$movie->series_list = null;
						HD::save_items('save_folder', $save_folder);
					}
					$this->vod->remove_favorite_movie($user_input->selected_media_url, $plugin_cookies);
					return ActionFactory::show_title_dialog_gl('Удалено из Избранного');
				}
				else{
					$this->vod->add_favorite_movie($user_input->selected_media_url, $plugin_cookies);
					return ActionFactory::show_title_dialog_gl('Добавленно в Избранное');
				}
			}
			
        }
		if ($user_input->control_id == 'add_fav_itm')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$fav_movies = HD::get_items($user_input->ufav_itms_name);
			$flipped = array_flip($fav_movies);
			if (isset($flipped[$user_input->selected_media_url])){
				unset ($flipped[$user_input->selected_media_url]);
				$fav_movies = array_flip($flipped);
				$fav_movies = array_values($fav_movies);
				HD::save_items($user_input->ufav_itms_name, $fav_movies);
				$media_url = MediaURL::decode($user_input->selected_media_url);
				$save_folder = HD::get_items('save_folder');
				if (isset($save_folder[$media_url->movie_id])){
					unset ($save_folder[$media_url->movie_id]);
					$movie->series_list = null;
					HD::save_items('save_folder', $save_folder);
				}
				return ActionFactory::show_title_dialog_gl('Удалено из Избранного');
			}else
				array_unshift($fav_movies,$user_input->selected_media_url);
			HD::save_items($user_input->ufav_itms_name, $fav_movies);
			return ActionFactory::show_title_dialog_gl('Добавленно в Избранное');
        }
		if ($user_input->control_id == 'add_fav')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$this->vod->ensure_favorites_loaded($plugin_cookies);
            $is_favorite = $this->vod->is_favorite_movie_id($user_input->selected_media_url);
            if ($is_favorite){
				$media_url = MediaURL::decode($user_input->selected_media_url);
				$save_folder = HD::get_items('save_folder');
				if (isset($save_folder[$media_url->movie_id])){
					unset ($save_folder[$media_url->movie_id]);
					$movie->series_list = null;
					HD::save_items('save_folder', $save_folder);
				}
				$this->vod->remove_favorite_movie($user_input->selected_media_url, $plugin_cookies);
                return ActionFactory::show_title_dialog_gl('Удалено из Избранного');
			}
            else{
                $this->vod->add_favorite_movie($user_input->selected_media_url, $plugin_cookies);
                return ActionFactory::show_title_dialog_gl('Добавленно в Избранное');
            }
        }

        return null;
    }
}

///////////////////////////////////////////////////////////////////////////
?>
