<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/abstract_regular_screen.php';

abstract class VodListScreen extends AbstractRegularScreen
    implements UserInputHandler
{
    const ID = 'vod_list';

    ///////////////////////////////////////////////////////////////////////

    protected $vod;

    protected function __construct(Vod $vod)
    {
        parent::__construct(self::ID, $vod->get_vod_list_folder_views());

        $this->vod = $vod;

        UserInputHandlerRegistry::get_instance()->
            register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
		$actions = array();
		$actions[GUI_EVENT_KEY_SETUP]	= ActionFactory::open_folder(SmartSetupScreen::get_media_url_str(),"Настройки");
		$actions[GUI_EVENT_KEY_ENTER] = UserInputHandlerRegistry::create_action($this, 'add_actions');
		$actions[GUI_EVENT_KEY_PLAY] = UserInputHandlerRegistry::create_action($this, 'add_actions');
		$add_action = UserInputHandlerRegistry::create_action($this, 'add_favorite');
        $add_action['caption'] = 'В Избранное';
        $actions[GUI_EVENT_KEY_D_BLUE] = $add_action;
		$add_action = UserInputHandlerRegistry::create_action($this, 'search');
        $add_action['caption'] = 'Поиск';
        $actions[GUI_EVENT_KEY_B_GREEN] = $add_action;
		// $add_action = UserInputHandlerRegistry::create_action($this, 'sort_category');
        // $add_action['caption'] = 'Сортировки';
		// $actions[GUI_EVENT_KEY_C_YELLOW] = $add_action;
        $actions[GUI_EVENT_KEY_POPUP_MENU] = UserInputHandlerRegistry::create_action($this, 'popup_menu');

        return $actions;
    }

    public function get_handler_id()
    { return self::ID; }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {		
		$pin = isset($plugin_cookies->pin) ? $plugin_cookies->pin : '0000';
		$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
		if ($user_input->control_id == 'sort_category')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->parent_media_url);
			$defs = array();
			$sort_page_settings = HD::get_items('sort_page_settings');	
			$video_sorting = isset($sort_page_settings[$media_url->genre_id][$media_url->category_id]['vsorting']) ? $sort_page_settings[$media_url->genre_id][$media_url->category_id]['vsorting'] : '?sort=new';
			$vsorting = array();
			$vsorting['?sort=new'] = 'по дате обновления';
			$vsorting['?sort=rating'] = 'по рейтингу';
			$vsorting['?sort=year'] = 'по году выпуска';
			$vsorting['?sort=popularity'] = 'по популярности';
			$vsorting['?sort=trend'] = 'в тренде';
			ControlFactory::add_combobox($defs, $this, null,
			'video_sorting', 'Cортировать:',
			$video_sorting, $vsorting, 0, $need_confirm = false, $need_apply = false);
			
			$do_save_sort_page = UserInputHandlerRegistry::create_action($this, 'save_sort_page');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,	'_do_save_sort_page', 'Применить', 300, $do_save_sort_page);
			$do_save_sort_page = UserInputHandlerRegistry::create_action($this, 'clear_sort_page');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,	'_do_clear_sort_page', 'Очистить все', 300, $do_save_sort_page);	
            return ActionFactory::show_dialog("Сортировка", $defs,	true, 0,$attrs);
		}
		
		if ($user_input->control_id == 'clear_sort_page')
        {
			$media_url = MediaURL::decode($user_input->parent_media_url);
			HD::save_items('sort_page_settings', array());
			$this->vod->clear_movie_cache();
			$this->vod->m_feed = 0;
			return ActionFactory::update_regular_folder($this->get_folder_range($media_url, 0, $plugin_cookies), false, 0);
		}
		
		if ($user_input->control_id == 'save_sort_page')
        {
            $media_url = MediaURL::decode($user_input->parent_media_url);
			$sort_page_settings = HD::get_items('sort_page_settings');
			if (isset($user_input->video_sorting)){
				$sort_page_settings[$media_url->genre_id][$media_url->category_id]['vsorting'] = $user_input->video_sorting;
				HD::save_items('sort_page_settings', $sort_page_settings);
				$this->vod->clear_movie_cache();
				$this->vod->m_feed = 0;
				return ActionFactory::update_regular_folder(
                                    $this->get_folder_range($media_url, 0, $plugin_cookies), false, 0);
			}
		}
		
		if ($user_input->control_id == 'search')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$use_osk = (HD::get_item('use_osk') !='') ? HD::get_item('use_osk') : 1;
			$defs = array();
			ControlFactory::add_text_field($defs,
			$this, $add_params=null,
			'do_new_search', '',
			$media_url->name, 0, 0, $use_osk, 1, 1300,0,1);
			if ($use_osk == 1)
				ControlFactory::add_vgap($defs, 500);
			return ActionFactory::show_dialog('Поиск', $defs, true, 0,$attrs);
		}
		
		if ($user_input->control_id == 'do_new_search')
        {
			$do_search = UserInputHandlerRegistry::create_action($this, 'do_search');
			return ActionFactory::close_dialog_and_run($do_search);
		}
		
		if ($user_input->control_id == 'do_search')
        {
			$media_url = MediaURL::decode($user_input->selected_media_url);
			HD::save_item('search_item', $user_input->do_new_search);
			$search_items = HD::get_items('search_items');
			$k = array_search($user_input->do_new_search, $search_items);
			if ($k !== false)
				unset ($search_items [$k]);
			array_unshift($search_items, $user_input->do_new_search); 
			HD::save_items('search_items', $search_items);
			$action = ActionFactory::open_folder(SmartVodListScreen::get_media_url_str('search', $user_input->do_new_search), "Поиск: ".$user_input->do_new_search);
			return ActionFactory::invalidate_folders(array('search_screen'),$action);
		}
		if ($user_input->control_id == 'del_parent_apply')
		{
			if ($user_input->pin !== $pin)
				return ActionFactory::show_title_dialog_gl("Код не правильный!!!");
			if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
            if (isset($media_url->subcategory_id))
				$id = $media_url->subcategory_id;
			else if (isset($media_url->category_id))
				$id = $media_url->category_id;
			else if (isset($media_url->movie_id))
				$id = $media_url->movie_id;
			$title = $media_url->name;
			$parental_defs = HD::get_items('parental_item');
			unset ($parental_defs [$id]);
			HD::save_items('parental_item', $parental_defs);
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('vod_category_list'), $perform_new_action);
		}
		
		if ($user_input->control_id == 'del_parental')
		{
			if (!isset($user_input->selected_media_url))
				return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			if (isset($media_url->subcategory_id))
				$id = $media_url->subcategory_id;
			else if (isset($media_url->category_id))
				$id = $media_url->category_id;
			else if (isset($media_url->movie_id))
				$id = $media_url->movie_id;
			$title = $media_url->name;
			$parental_defs = HD::get_items('parental_item');
			$is_protected = (array_key_exists($id, $parental_defs)) ? 1 : 0;
			if ($is_protected == 0)
				return ActionFactory::show_title_dialog_gl("Итем $title не защищен!!!");
			$defs = array();
			ControlFactory::add_text_field($defs,0,0,
				'pin', 'Код родительского контроля:',
				'', 1, 1, 0, 1, 500, 0, false);
			$do_kill_parent_apply = UserInputHandlerRegistry::create_action($this, 'del_parent_apply');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs, '_kill_parent_apply', 'ОК', 250, $do_kill_parent_apply);
			ControlFactory::add_close_dialog_button($defs, 'Отмена', 250);
			return  ActionFactory::show_dialog(	"Открыть итем (Parental) - $title",$defs,true, 0,$attrs);
		}
		
		if ($user_input->control_id == 'add_parental_apply')
		{
			if (!isset($user_input->selected_media_url))
				return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			if (isset($media_url->subcategory_id))
				$id = $media_url->subcategory_id;
			else if (isset($media_url->category_id))
				$id = $media_url->category_id;
			else if (isset($media_url->movie_id))
				$id = $media_url->movie_id;
			$title = $media_url->name;
			$parental_defs = HD::get_items('parental_item');
			$is_protected = (array_key_exists($id, $parental_defs)) ? 1 : 0;
			if ($is_protected == 1)
				return ActionFactory::show_title_dialog_gl("Итем $title уже защищен!!!");
			$parental_defs [$id] = 1;	
			HD::save_items('parental_item', $parental_defs);
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('vod_category_list'), $perform_new_action);
		}
		
		if ($user_input->control_id == 'add_parental')
		{
			if (!isset($user_input->selected_media_url))
				return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$title = $media_url->name;
			$defs = array();
			ControlFactory::add_label($defs, "", "Вы уверены что хотите закрыть итем");
			ControlFactory::add_label($defs, "", "$title Родительским контролем ?");
			ControlFactory::add_label($defs, "", "Внимание: открыть итем можно через");
			ControlFactory::add_label($defs, "", "Открыть итем (Parental)");
			$do_add_parental_apply = UserInputHandlerRegistry::create_action($this, 'add_parental_apply');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs, '_add_parental_apply', 'Да', 250, $do_add_parental_apply);
			ControlFactory::add_close_dialog_button($defs, 'Нет', 250);
			return  ActionFactory::show_dialog ("Закрыть итем (Parental Control): $title ?", $defs, true, 0,$attrs);
		}
		
		if ($user_input->control_id === 'pin_control'){
				if ($user_input->pin_control == $pin){
					$params['unlock'] = true;
					$do_actions = UserInputHandlerRegistry::create_action($this, 'add_actions', $params);
					return ActionFactory::close_dialog_and_run($do_actions);
				}
				else
					return  ActionFactory::show_title_dialog_gl('Код не верный!');
		}
		
		if ($user_input->control_id == 'add_actions')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			if (($pin != '1111')&&(!isset($user_input->unlock))){
				$parental_defs = HD::get_items('parental_item');
				if (isset($media_url->subcategory_id))
					$id = $media_url->subcategory_id;
				else if (isset($media_url->category_id))
					$id = $media_url->category_id;
				else if (isset($media_url->movie_id))
					$id = $media_url->movie_id;
				$is_protected = (array_key_exists($id, $parental_defs)) ? 1 : 0;
				if ($is_protected == 1){
					$defs = array();
					ControlFactory::add_text_field($defs, $this, $add_params=null,
						'pin_control', '',
						'', 1, 1, 0, 1, 500, 0, true);
					HD::get_lock_items('lock');
					return  ActionFactory::show_dialog('Введите код:',$defs,true, 0,$attrs);
				}else
					HD::get_lock_items('unlock');
			}
			return ActionFactory::open_folder();
        }
        if ($user_input->control_id == 'popup_menu')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$this->vod->ensure_favorites_loaded($plugin_cookies);
            $is_favorite = $this->vod->is_favorite_movie_id($user_input->selected_media_url);
			if ($is_favorite)
				$caption = 'Удалить из Избранного';
			else
				$caption = 'Добавить в Избранное';
			$add_favorite_action = UserInputHandlerRegistry::create_action($this, 'add_favorite');
            $menu_items[] = array(
                GuiMenuItemDef::caption => $caption,
                GuiMenuItemDef::action => $add_favorite_action,
				GuiMenuItemDef::icon_url => 'gui_skin://small_icons/favorites.aai');
				
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
			$parental_defs = HD::get_items('parental_item');
			
			$is_protected = (array_key_exists($id, $parental_defs)) ? 1 : 0;
			if ($is_protected == 1){
				$caption = 'Открыть итем';
				$action = UserInputHandlerRegistry::create_action($this, 'del_parental');
			}else{
				$caption = 'Закрыть итем';
				$action = UserInputHandlerRegistry::create_action($this, 'add_parental');
			}
            $menu_items[] = array(
                GuiMenuItemDef::caption => $caption,
                GuiMenuItemDef::action => $action,
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/kartina_tv_lock.png'
				);
				
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
				
			$menu_items[] = array(
            GuiMenuItemDef::caption => 'Задать бекграунд',
            GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'add_vod_list_bg'),
			GuiMenuItemDef::icon_url => 'gui_skin://small_icons/photo_viewer.aai'
			);
			
			$plugin_ico = HD::get_items('plugin_ico');
			if (isset($plugin_ico['vod_list_bg'])){
				$menu_items[] = array(
				GuiMenuItemDef::caption => 'Удалить бекграунд',
				GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'del_vod_list_bg'),
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
				);
			}
            return ActionFactory::show_popup_menu($menu_items);
        }
		
		if ($user_input->control_id == 'add_vod_list_bg')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$msg = "Для применения изменений выйдите из плагина, нажмите кнопку POPUP и выберите 'Обновить'.";
			$media_url = MediaURL::encode (
                    array
                    (
                        'screen_id'     => 'file_list',
						'save_file'		=> array(	
						'parent' 		=> self::ID,
						'action' 		=> 'plugin_ico',
						'arg' 			=> 'vod_list_bg',
						'msg' 			=> $msg,
						'extension' 	=> 'jpg'
						),
                    )
			);
			return ActionFactory::open_folder($media_url,'Folders');
		}
		
		if ($user_input->control_id == 'del_vod_list_bg')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$plugin_ico = HD::get_items('plugin_ico');
			unlink($plugin_ico['vod_list_bg']);
			unset ($plugin_ico['vod_list_bg']);
			HD::save_items('plugin_ico', $plugin_ico);
			return ActionFactory::invalidate_folders(array('vod_category_list'), 
			ActionFactory::show_title_dialog('Бекграунд удален',null,"Для применения изменений выйдите из плагина, нажмите кнопку POPUP и выберите 'Обновить'.",800,1));
		}
		
        if ($user_input->control_id == 'add_favorite')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$this->vod->ensure_favorites_loaded($plugin_cookies);
			$is_favorite = $this->vod->is_favorite_movie_id($user_input->selected_media_url);
			$ufav_itms = HD::get_items('ufav_itms');
			if (!empty($ufav_itms)){
				if ($is_favorite)
					$caption = 'Удалить из Избранного';
				else
					$caption = 'Добавить в Избранное';
				$add_favorite_action = UserInputHandlerRegistry::create_action($this, 'add_fav');
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_works', $caption, 600, $add_favorite_action);
				foreach ($ufav_itms as $k => $v){
					$caption = "Добавить в: $v";
					$params['ufav_itms_name'] = $k;
					$add_favorite_action = UserInputHandlerRegistry::create_action($this, 'add_fav_itm',$params);
					ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_works', $caption, 600, $add_favorite_action);
				}
				return ActionFactory::show_dialog('Избранное', $defs, true, 0,$attrs);
			}else{
				if ($is_favorite){
					$media_url = MediaURL::decode($user_input->selected_media_url);
					$save_folder = HD::get_items('save_folder');
					if (isset($save_folder[$media_url->movie_id])){
						unset ($save_folder[$media_url->movie_id]);
						$movie->series_list = null;
						HD::save_items('save_folder', $save_folder);
					}
					$this->vod->remove_favorite_movie($user_input->selected_media_url, $plugin_cookies);
					return ActionFactory::show_title_dialog_gl('Удалено из Избранного');
				}
				else{
					$this->vod->add_favorite_movie($user_input->selected_media_url, $plugin_cookies);
					return ActionFactory::show_title_dialog_gl('Добавленно в Избранное');
				}
			}
			
        }
		if ($user_input->control_id == 'add_fav_itm')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$fav_movies = HD::get_items($user_input->ufav_itms_name);
			$flipped = array_flip($fav_movies);
			if (isset($flipped[$user_input->selected_media_url])){
				unset ($flipped[$user_input->selected_media_url]);
				$fav_movies = array_flip($flipped);
				$fav_movies = array_values($fav_movies);
				HD::save_items($user_input->ufav_itms_name, $fav_movies);
				$media_url = MediaURL::decode($user_input->selected_media_url);
				$save_folder = HD::get_items('save_folder');
				if (isset($save_folder[$media_url->movie_id])){
					unset ($save_folder[$media_url->movie_id]);
					$movie->series_list = null;
					HD::save_items('save_folder', $save_folder);
				}
				return ActionFactory::show_title_dialog_gl('Удалено из Избранного');
			}else
				array_unshift($fav_movies,$user_input->selected_media_url);
			HD::save_items($user_input->ufav_itms_name, $fav_movies);
			return ActionFactory::show_title_dialog_gl('Добавленно в Избранное');
        }
		if ($user_input->control_id == 'add_fav')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$this->vod->ensure_favorites_loaded($plugin_cookies);
            $is_favorite = $this->vod->is_favorite_movie_id($user_input->selected_media_url);
            if ($is_favorite){
				$media_url = MediaURL::decode($user_input->selected_media_url);
				$save_folder = HD::get_items('save_folder');
				if (isset($save_folder[$media_url->movie_id])){
					unset ($save_folder[$media_url->movie_id]);
					$movie->series_list = null;
					HD::save_items('save_folder', $save_folder);
				}
				$this->vod->remove_favorite_movie($user_input->selected_media_url, $plugin_cookies);
                return ActionFactory::show_title_dialog_gl('Удалено из Избранного');
			}
            else{
                $this->vod->add_favorite_movie($user_input->selected_media_url, $plugin_cookies);
                return ActionFactory::show_title_dialog_gl('Добавленно в Избранное');
            }
        }

        return null;
    }

    ///////////////////////////////////////////////////////////////////////

    // Returns ShortMovieRange.
    protected abstract function get_short_movie_range(
        MediaURL $media_url, $from_ndx, &$plugin_cookies);

    public function get_folder_range(MediaURL $media_url, $from_ndx, &$plugin_cookies)
    {
        $movie_range = $this->get_short_movie_range(
            $media_url, $from_ndx, $plugin_cookies);

        $total = intval($movie_range->total);
        if ($total <= 0)
            return HD::create_regular_folder_range(array());

        $items = array();
        foreach ($movie_range->short_movies as $movie)
        {
            $items[] = array
            (
                PluginRegularFolderItem::media_url => VodMovieScreen::get_media_url_str($movie->id),
                PluginRegularFolderItem::caption => $movie->name,
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $movie->poster_url,
                )
            );

            $this->vod->set_cached_short_movie(
                new ShortMovie($movie->id, $movie->name, $movie->poster_url, $movie->kp_id));
        }

        return HD::create_regular_folder_range(
            $items, $movie_range->from_ndx, $total);
    }

    public function get_archive(MediaURL $media_url)
    {
        return $this->vod->get_archive($media_url);
    }

    public function get_folder_view(MediaURL $media_url, &$plugin_cookies)
    {
        $this->vod->folder_entered($media_url, $plugin_cookies);

        return parent::get_folder_view($media_url, $plugin_cookies);
    }
}

///////////////////////////////////////////////////////////////////////////
?>
