<?php

require_once 'lib/vod/vod.php';
require_once 'lib/abstract_preloaded_regular_screen.php';

class VodFavoritesScreen extends AbstractPreloadedRegularScreen
    implements UserInputHandler
{
    const ID = 'vod_favorites';

    public static function get_media_url_str($first_arg=null)
    {
		$arr['screen_id'] = self::ID;
		if ($first_arg == true)
			$arr['first_arg'] = $first_arg;
		return MediaURL::encode($arr);
    }

    ///////////////////////////////////////////////////////////////////////

    private $vod;

    public function __construct(Vod $vod)
    {
        $this->vod = $vod;

        parent::__construct(self::ID,
            $vod->get_vod_list_folder_views());

        UserInputHandlerRegistry::get_instance()->register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
        $actions = array();
		$actions[GUI_EVENT_KEY_SETUP] = ActionFactory::open_folder(SmartSetupScreen::get_media_url_str(),"Настройки");
        $actions[GUI_EVENT_KEY_ENTER] = ActionFactory::open_folder();
        $actions[GUI_EVENT_KEY_PLAY] = ActionFactory::open_folder();
        $add_action = UserInputHandlerRegistry::create_action($this, 'up_item');
		$add_action['caption'] = 'Поднять';
		$actions[GUI_EVENT_KEY_B_GREEN] = $add_action;
		$add_action = UserInputHandlerRegistry::create_action($this, 'down_item');
		$add_action['caption'] = 'Опустить';
		$actions[GUI_EVENT_KEY_C_YELLOW] = $add_action;
		$remove_favorite_action = UserInputHandlerRegistry::create_action($this, 'remove_favorite');
        $remove_favorite_action['caption'] = 'Удалить из Избранного';
		$actions[GUI_EVENT_KEY_D_BLUE] = $remove_favorite_action;
        $actions[GUI_EVENT_KEY_POPUP_MENU] = UserInputHandlerRegistry::create_action($this, 'popup_menu');
        return $actions;
    }

    public function get_handler_id()
    { return self::ID; }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        $attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
		if ($user_input->control_id == 'remove_favorite')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$save_folder = HD::get_items('save_folder');
			if (isset($save_folder[$media_url->movie_id])){
				unset ($save_folder[$media_url->movie_id]);
				$movie->series_list = null;
				HD::save_items('save_folder', $save_folder);
			}
			$media_url = MediaURL::decode($user_input->parent_media_url);
			if (isset($media_url->first_arg)){
				$fav_movies = HD::get_items($media_url->first_arg);
				$flipped = array_flip($fav_movies);
				if (isset($flipped[$user_input->selected_media_url])){
					unset ($flipped[$user_input->selected_media_url]);
					$fav_movies = array_flip($flipped);
					$fav_movies = array_values($fav_movies);
					HD::save_items($media_url->first_arg, $fav_movies);
					return ActionFactory::invalidate_folders(array($user_input->parent_media_url));
				}
			}
			else{
				$this->vod->remove_favorite_movie($user_input->selected_media_url, $plugin_cookies);
				return ActionFactory::invalidate_folders(array(self::get_media_url_str()));
			}
        }
		
		if ($user_input->control_id == 'add_arc_serials')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->parent_media_url);
			if (isset($media_url->first_arg)){
				$fav_movies = HD::get_items($media_url->first_arg);
				$flipped = array_flip($fav_movies);
				if (isset($flipped[$user_input->selected_media_url])){
					unset ($flipped[$user_input->selected_media_url]);
					$fav_movies = array_flip($flipped);
					$fav_movies = array_values($fav_movies);
					HD::save_items($media_url->first_arg, $fav_movies);
				}
			}else{
				$media_url = MediaURL::decode($user_input->selected_media_url);
				$save_folder = HD::get_items('save_folder');
				if (isset($save_folder[$media_url->movie_id])){
					unset ($save_folder[$media_url->movie_id]);
					$movie->series_list = null;
					HD::save_items('save_folder', $save_folder);
				}
				$this->vod->remove_favorite_movie($user_input->selected_media_url, $plugin_cookies);
			}
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$seasons = SmartConfig::getSeasonList($media_url->movie_id);
			if ($seasons == true){
				$arc_serials = HD::get_items('arc_serials');
				$arc_serials[$user_input->selected_media_url] = $seasons;
				HD::save_items('arc_serials', $arc_serials);
			}else
				return ActionFactory::show_title_dialog('Список сезонов не найден!',null,"Возможно видео заблокированно!'.",800,1);
            return ActionFactory::invalidate_folders(array($user_input->parent_media_url,'main_menu'));
        }
		
		if ($user_input->control_id == 'add_vod_list_bg')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$msg = "Для применения изменений выйдите из плагина, нажмите кнопку POPUP и выберите 'Обновить'.";
			$media_url = MediaURL::encode (
                    array
                    (
                        'screen_id'     => 'file_list',
						'save_file'		=> array(	
						'parent' 		=> self::ID,
						'action' 		=> 'plugin_ico',
						'arg' 			=> 'vod_list_bg',
						'msg' 			=> $msg,
						'extension' 	=> 'jpg'
						),
                    )
			);
			return ActionFactory::open_folder($media_url,'Folders');
		}
		
		if ($user_input->control_id == 'del_vod_list_bg')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$plugin_ico = HD::get_items('plugin_ico');
			unlink($plugin_ico['vod_list_bg']);
			unset ($plugin_ico['vod_list_bg']);
			HD::save_items('plugin_ico', $plugin_ico);
			return ActionFactory::invalidate_folders(array('vod_category_list'), 
			ActionFactory::show_title_dialog('Бекграунд удален',null,"Для применения изменений выйдите из плагина, нажмите кнопку POPUP и выберите 'Обновить'.",800,1));
		}
		
		if ($user_input->control_id == 'up_item')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$video_id = $user_input->selected_media_url;
			$media_url = MediaURL::decode($user_input->parent_media_url);
			if (isset($media_url->first_arg))
				$fav_items = HD::get_items($media_url->first_arg);
			else
				$fav_items = HD::get_items('favorite_movies');
			$k = array_search($video_id, $fav_items);
			if ($k !== false && $k !== 0){
				$t = $fav_items[$k - 1];
				$fav_items[$k - 1] = $fav_items[$k];
				$fav_items[$k] = $t;
			}
			if (isset($media_url->first_arg))
				HD::save_items($media_url->first_arg, $fav_items);
			else
				HD::save_items('favorite_movies', $fav_items);
			$this->vod->clear_movie_cache();
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$range = HD::create_regular_folder_range(
				$this->get_all_folder_items(
					$parent_media_url, $plugin_cookies));
			return ActionFactory::update_regular_folder(
				$range, false, $k - 1);
        }
		
		if ($user_input->control_id == 'down_item')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$video_id = $user_input->selected_media_url;
			$media_url = MediaURL::decode($user_input->parent_media_url);
			if (isset($media_url->first_arg))
				$fav_items = HD::get_items($media_url->first_arg);
			else
				$fav_items = HD::get_items('favorite_movies');
			$k = array_search($video_id, $fav_items);
			if ($k !== false && $k !== count($fav_items) - 1){
				$t = $fav_items[$k + 1];
				$fav_items[$k + 1] = $fav_items[$k];
				$fav_items[$k] = $t;
			}
			if (isset($media_url->first_arg))
				HD::save_items($media_url->first_arg, $fav_items);
			else
				HD::save_items('favorite_movies', $fav_items);
			$this->vod->clear_movie_cache();
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$range = HD::create_regular_folder_range(
				$this->get_all_folder_items(
					$parent_media_url, $plugin_cookies));
			return ActionFactory::update_regular_folder(
				$range, false, $k + 1);
        }
		if ($user_input->control_id == 'add_ufav')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$defs = array();
			ControlFactory::add_text_field($defs, $this, $add_params=null,
                    'new_ufav',
                    '',
                    '', 0, 0, 1, 1, 1300,0,1);
			ControlFactory::add_vgap($defs, 500);
			return ActionFactory::show_dialog("Введите название Избранного", $defs, true,0,$attrs);
        }
		if ($user_input->control_id == 'new_ufav')
        {
			$do = UserInputHandlerRegistry::create_action($this, 'run_new_ufav');
			return ActionFactory::close_dialog_and_run($do);
		}
		if ($user_input->control_id == 'run_new_ufav')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$ufav_itms = HD::get_items('ufav_itms');
			$ufav_itms[sprintf("%u", crc32($user_input->new_ufav)). '_ufav'] = $user_input->new_ufav;
			HD::save_items('ufav_itms', $ufav_itms);
			$action = ActionFactory::show_title_dialog_gl('Добавленно!');
			return ActionFactory::invalidate_folders(array('main_menu'),$action);
        }
		
		if ($user_input->control_id == 'popup_menu')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			
			$remove_favorite_action = UserInputHandlerRegistry::create_action($this, 'remove_favorite');
			$remove_favorite_action['caption'] = 'Удалить из Избранного';
			$menu_items[] = array(
            GuiMenuItemDef::caption => $remove_favorite_action['caption'],
            GuiMenuItemDef::action => $remove_favorite_action,
			GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
			);
			if (preg_match("/serial\//i",$media_url->movie_id)){
				$menu_items [] =  array(GuiMenuItemDef::is_separator => true);
				$menu_items[] = array(
					GuiMenuItemDef::caption => 'Перенести в архив сериалов',
					GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'add_arc_serials'),
					GuiMenuItemDef::icon_url => 'gui_skin://small_icons/bookmarks_settings.aai'
				);
			}
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
					
			$menu_items[] = array(
				GuiMenuItemDef::caption => 'Добавить Новое Избранное',
				GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'add_ufav'),
				GuiMenuItemDef::icon_url => 'gui_skin://small_icons/apps.aai'
			);
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
					
			$menu_items[] = array(
				GuiMenuItemDef::caption => 'Задать бекграунд',
				GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'add_vod_list_bg'),
				GuiMenuItemDef::icon_url => 'gui_skin://small_icons/photo_viewer.aai'
			);
			$plugin_ico = HD::get_items('plugin_ico');
			if (isset($plugin_ico['vod_list_bg'])){
				$menu_items[] = array(
					GuiMenuItemDef::caption => 'Удалить бекграунд',
					GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'del_vod_list_bg'),
					GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
				);
			}
            return ActionFactory::show_popup_menu($menu_items);
        }
		
        return null;
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies)
    {
        $this->vod->folder_entered($media_url, $plugin_cookies);
        $this->vod->ensure_favorites_loaded($plugin_cookies);
		if (isset($media_url->first_arg))
			$fav_movies = HD::get_items($media_url->first_arg);
		else
			$fav_movies = $this->vod->get_favorite_movie_ids();

        $items = array();
		$save_folder = HD::get_items('save_folder');
		$i=0;
        foreach ($fav_movies as $fav_movie)
        {
            $new = $ninfo = ''; $starred = false;
			$mUrl = MediaURL::decode($fav_movie);
			if (isset($mUrl->second_arg)){
				$caption = $mUrl->second_arg;
				$poster_url = $mUrl->third_arg;
				$info = $mUrl->second_arg . '|';
			}else{
				$caption = $mUrl->name;
				$info = $mUrl->info;
				if (isset($mUrl->poster_url))
					$poster_url = $mUrl->poster_url;
				else if ((isset($mUrl->genre_id))&&($mUrl->genre_id == 'actor'))
					$poster_url = "plugin_file://icons/user.png";
				else if ($mUrl->info == 'plugin_file://icons/no_poster.png'){
					$poster_url = 'plugin_file://icons/no_poster.png';
					$info = $caption . '|';
				}else if (isset($mUrl->screen_id)){
					$poster_url = SmartConfig::get_plugin_ico($mUrl->screen_id);
					$caption = SmartConfig::get_categories_name($mUrl->category_id) . ': ' . $caption;
				}
			}
			$n = $i+1000; $color = 15;
			if ((isset ($save_folder[$mUrl->movie_id]))&&
			(($save_folder[$mUrl->movie_id][key($save_folder[$mUrl->movie_id])]) != 'not_check')){
				$season_items = SmartConfig::parse_season_items($mUrl->movie_id, key($save_folder[$mUrl->movie_id]));
				$save_items =  array_flip($save_folder[$mUrl->movie_id][key($save_folder[$mUrl->movie_id])]);
				foreach ($season_items as $k => $v){
					if (!isset($save_items[$v])){
						$ninfo .= $k;
						$new = '[NEW] ';$starred = true;
						$color = 18;
					}
				}
			}
			if ($ninfo != '')
				$info = "||NEW:".$ninfo.'||'.$info;
            $items[$n] = array
            (
                PluginRegularFolderItem::media_url => $fav_movie,
                PluginRegularFolderItem::caption => $new  . $caption,
				PluginRegularFolderItem::starred => $starred,
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $poster_url,
					ViewItemParams::item_detailed_info => $info,
					ViewItemParams::item_caption_color => $color,
                )
            );
			$i++;
        }
		ksort($items);
		$items = array_values($items);
        return $items;
    }

    public function get_archive(MediaURL $media_url)
    {
        return $this->vod->get_archive($media_url);
    }
}

?>
