<?php

require_once 'lib/vod/vod.php';
require_once 'lib/abstract_preloaded_regular_screen.php';

class VodAserialsScreen extends AbstractPreloadedRegularScreen
    implements UserInputHandler
{
    const ID = 'vod_aserials';

    public static function get_media_url_str()
    {
        return MediaURL::encode(array('screen_id' => self::ID));
    }

    ///////////////////////////////////////////////////////////////////////

    private $vod;

    public function __construct(Vod $vod)
    {
        $this->vod = $vod;

        parent::__construct(self::ID,
            $vod->get_vod_list_folder_views());

        UserInputHandlerRegistry::get_instance()->register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
        $actions = array();
		$actions[GUI_EVENT_KEY_SETUP] = ActionFactory::open_folder(SmartSetupScreen::get_media_url_str(),"Настройки");
        $actions[GUI_EVENT_KEY_ENTER]	= ActionFactory::open_folder();
        $actions[GUI_EVENT_KEY_PLAY] 	= ActionFactory::vod_play();
		$add_action = UserInputHandlerRegistry::create_action($this, 'add_favorite');
        $add_action['caption'] = 'В Избранное';
        $actions[GUI_EVENT_KEY_D_BLUE] = $add_action;
		$add_action = UserInputHandlerRegistry::create_action($this, 'search');
        $add_action['caption'] = 'Поиск';
        $actions[GUI_EVENT_KEY_B_GREEN] = $add_action;
		$add_action = UserInputHandlerRegistry::create_action($this, 'del_item');
        $add_action['caption'] = 'Удалить';
		$actions[GUI_EVENT_KEY_C_YELLOW] = $add_action;
        $actions[GUI_EVENT_KEY_POPUP_MENU] = UserInputHandlerRegistry::create_action($this, 'popup_menu');
        return $actions;
    }

    public function get_handler_id()
    { return self::ID; }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        $attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
		if ($user_input->control_id == 'remove_favorite')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$save_folder = HD::get_items('save_folder');
			if (isset($save_folder[$media_url->movie_id])){
				unset ($save_folder[$media_url->movie_id]);
				$movie->series_list = null;
				HD::save_items('save_folder', $save_folder);
			}
            $this->vod->remove_favorite_movie($user_input->selected_media_url, $plugin_cookies);
            return ActionFactory::invalidate_folders(array(self::get_media_url_str($user_input->selected_media_url)));
        }
		
		if ($user_input->control_id == 'add_vod_list_bg')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$msg = "Для применения изменений выйдите из плагина, нажмите кнопку POPUP и выберите 'Обновить'.";
			$media_url = MediaURL::encode (
                    array
                    (
                        'screen_id'     => 'file_list',
						'save_file'		=> array(	
						'parent' 		=> self::ID,
						'action' 		=> 'plugin_ico',
						'arg' 			=> 'vod_list_bg',
						'msg' 			=> $msg,
						'extension' 	=> 'jpg'
						),
                    )
			);
			return ActionFactory::open_folder($media_url,'Folders');
		}
		
		if ($user_input->control_id == 'del_vod_list_bg')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$plugin_ico = HD::get_items('plugin_ico');
			unlink($plugin_ico['vod_list_bg']);
			unset ($plugin_ico['vod_list_bg']);
			HD::save_items('plugin_ico', $plugin_ico);
			return ActionFactory::invalidate_folders(array('main_menu'), 
			ActionFactory::show_title_dialog('Бекграунд удален',null,"Для применения изменений выйдите из плагина, нажмите кнопку POPUP и выберите 'Обновить'.",800,1));
		}
		
		if ($user_input->control_id == 'del_item')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$arc_serials = HD::get_items('arc_serials');
			unset ($arc_serials[$user_input->selected_media_url]);
			HD::save_items('arc_serials', $arc_serials);
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$sel_ndx = $user_input->sel_ndx+1;
				if ($sel_ndx < 0)
					$sel_ndx = 0;
			$range = $this->get_folder_range($parent_media_url, 0, $plugin_cookies);
			return ActionFactory::update_regular_folder($range, true, $sel_ndx);
		}		
		
		if ($user_input->control_id == 'search')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$use_osk = (HD::get_item('use_osk') !='') ? HD::get_item('use_osk') : 1;
			$defs = array();
			ControlFactory::add_text_field($defs,
			$this, $add_params=null,
			'do_new_search', '',
			$media_url->name, 0, 0, $use_osk, 1, 1300,0,1);
			if ($use_osk == 1)
				ControlFactory::add_vgap($defs, 500);
			return ActionFactory::show_dialog('Поиск', $defs, true, 0,$attrs);
		}
		
		if ($user_input->control_id == 'do_new_search')
        {
			$do_search = UserInputHandlerRegistry::create_action($this, 'do_search');
			return ActionFactory::close_dialog_and_run($do_search);
		}
		
		if ($user_input->control_id == 'do_search')
        {
			$media_url = MediaURL::decode($user_input->selected_media_url);
			HD::save_item('search_item', $user_input->do_new_search);
			$search_items = HD::get_items('search_items');
			$k = array_search($user_input->do_new_search, $search_items);
			if ($k !== false)
				unset ($search_items [$k]);
			array_unshift($search_items, $user_input->do_new_search); 
			HD::save_items('search_items', $search_items);
			$action = ActionFactory::open_folder(SmartVodListScreen::get_media_url_str('search', $user_input->do_new_search), "Поиск: ".$user_input->do_new_search);
			return ActionFactory::invalidate_folders(array('search_screen'),$action);
		}
		
		if ($user_input->control_id == 'add_favorite')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$this->vod->ensure_favorites_loaded($plugin_cookies);
			$is_favorite = $this->vod->is_favorite_movie_id($user_input->selected_media_url);
			$ufav_itms = HD::get_items('ufav_itms');
			if (!empty($ufav_itms)){
				if ($is_favorite)
					$caption = 'Удалить из Избранного';
				else
					$caption = 'Добавить в Избранное';
				$add_favorite_action = UserInputHandlerRegistry::create_action($this, 'add_fav');
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_works', $caption, 600, $add_favorite_action);
				foreach ($ufav_itms as $k => $v){
					$caption = "Добавить в: $v";
					$params['ufav_itms_name'] = $k;
					$add_favorite_action = UserInputHandlerRegistry::create_action($this, 'add_fav_itm',$params);
					ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_works', $caption, 600, $add_favorite_action);
				}
				return ActionFactory::show_dialog('Избранное', $defs, true, 0,$attrs);
			}else{
				if ($is_favorite){
					$media_url = MediaURL::decode($user_input->selected_media_url);
					$save_folder = HD::get_items('save_folder');
					if (isset($save_folder[$media_url->movie_id])){
						unset ($save_folder[$media_url->movie_id]);
						$movie->series_list = null;
						HD::save_items('save_folder', $save_folder);
					}
					$this->vod->remove_favorite_movie($user_input->selected_media_url, $plugin_cookies);
					return ActionFactory::show_title_dialog_gl('Удалено из Избранного');
				}
				else{
					$this->vod->add_favorite_movie($user_input->selected_media_url, $plugin_cookies);
					$arc_serials = HD::get_items('arc_serials');
					unset ($arc_serials[$user_input->selected_media_url]);
					HD::save_items('arc_serials', $arc_serials);
					$action = ActionFactory::show_title_dialog_gl('Добавленно в Избранное');
					return ActionFactory::invalidate_folders(array($user_input->parent_media_url),$action);
				}
			}
			
        }
		if ($user_input->control_id == 'add_fav_itm')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$fav_movies = HD::get_items($user_input->ufav_itms_name);
			$flipped = array_flip($fav_movies);
			if (isset($flipped[$user_input->selected_media_url])){
				unset ($flipped[$user_input->selected_media_url]);
				$fav_movies = array_flip($flipped);
				$fav_movies = array_values($fav_movies);
				HD::save_items($user_input->ufav_itms_name, $fav_movies);
				$media_url = MediaURL::decode($user_input->selected_media_url);
				$save_folder = HD::get_items('save_folder');
				if (isset($save_folder[$media_url->movie_id])){
					unset ($save_folder[$media_url->movie_id]);
					$movie->series_list = null;
					HD::save_items('save_folder', $save_folder);
				}
				return ActionFactory::show_title_dialog_gl('Удалено из Избранного');
			}else{
				array_unshift($fav_movies,$user_input->selected_media_url);
				HD::save_items($user_input->ufav_itms_name, $fav_movies);
				$arc_serials = HD::get_items('arc_serials');
				unset ($arc_serials[$user_input->selected_media_url]);
				HD::save_items('arc_serials', $arc_serials);
				$action = ActionFactory::show_title_dialog_gl('Добавленно в Избранное');
				return ActionFactory::invalidate_folders(array($user_input->parent_media_url),$action);
			}
        }
		if ($user_input->control_id == 'add_fav')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$this->vod->ensure_favorites_loaded($plugin_cookies);
            $is_favorite = $this->vod->is_favorite_movie_id($user_input->selected_media_url);
            if ($is_favorite){
				$media_url = MediaURL::decode($user_input->selected_media_url);
				$save_folder = HD::get_items('save_folder');
				if (isset($save_folder[$media_url->movie_id])){
					unset ($save_folder[$media_url->movie_id]);
					$movie->series_list = null;
					HD::save_items('save_folder', $save_folder);
				}
				$this->vod->remove_favorite_movie($user_input->selected_media_url, $plugin_cookies);
                return ActionFactory::show_title_dialog_gl('Удалено из Избранного');
			}
            else{
                $this->vod->add_favorite_movie($user_input->selected_media_url, $plugin_cookies);
                $arc_serials = HD::get_items('arc_serials');
				unset ($arc_serials[$user_input->selected_media_url]);
				HD::save_items('arc_serials', $arc_serials);
				$action = ActionFactory::show_title_dialog_gl('Добавленно в Избранное');
				return ActionFactory::invalidate_folders(array($user_input->parent_media_url),$action);
            }
        }
		if ($user_input->control_id == 'popup_menu')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$this->vod->ensure_favorites_loaded($plugin_cookies);
            $is_favorite = $this->vod->is_favorite_movie_id($user_input->selected_media_url);
			if ($is_favorite)
				$caption = 'Удалить из Избранного';
			else
				$caption = 'Добавить в Избранное';
			$add_favorite_action = UserInputHandlerRegistry::create_action($this, 'add_favorite');
            $menu_items[] = array(
                GuiMenuItemDef::caption => $caption,
                GuiMenuItemDef::action => $add_favorite_action,
				GuiMenuItemDef::icon_url => 'gui_skin://small_icons/favorites.aai');
				
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
					
			$menu_items[] = array(
				GuiMenuItemDef::caption => 'Задать бекграунд',
				GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'add_vod_list_bg'),
				GuiMenuItemDef::icon_url => 'gui_skin://small_icons/photo_viewer.aai'
			);
			$plugin_ico = HD::get_items('plugin_ico');
			if (isset($plugin_ico['vod_list_bg'])){
				$menu_items[] = array(
					GuiMenuItemDef::caption => 'Удалить бекграунд',
					GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'del_vod_list_bg'),
					GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
				);
			}
            return ActionFactory::show_popup_menu($menu_items);
        }
		
        return null;
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies)
    {
        $this->vod->folder_entered($media_url, $plugin_cookies);
        $items = array();
		$arc_serials = HD::get_items('arc_serials');
		$i=0;
        foreach ($arc_serials as $k => $v)
        {
            $mUrl = MediaURL::decode($k);
			$new = $ninfo = ''; $color = 15;$starred = false;
            $caption = $mUrl->name;
			$poster_url = $mUrl->poster_url;
			$info = $mUrl->info;
			$n = $i+1000; 
			$season_items = SmartConfig::getSeasonList($mUrl->movie_id);
			$new_items = array_diff_key($season_items,$v);
			if (!empty($new_items))
				foreach ($new_items as $v){
					$ninfo .= '|Сезон '. $v;
					$new = '[NEW] ';
					$n = $i; $color = 18;
					$starred = true;
				}
			if ($ninfo != '')
				$info = "||NEW:".$ninfo.'||'.$info;
            $items[$n] = array
            (
                PluginRegularFolderItem::media_url => $k,
                PluginRegularFolderItem::caption => $new  . $caption,
				PluginRegularFolderItem::starred => $starred,
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $poster_url,
					ViewItemParams::item_detailed_info => $info,
					ViewItemParams::item_caption_color => $color,
                )
            );
			$i++;
        }
        ksort($items);
		$items = array_values($items);
        return $items;
    }

    public function get_archive(MediaURL $media_url)
    {
        return $this->vod->get_archive($media_url);
    }
}

?>
