<?php

class ShortMovie
{
    public $id;
    public $name;
    public $poster_url;
	public $kp_id;
    public function __construct($id, $name, $poster_url, $kp_id)
    {
        if (is_null($id))
            hd_print("ShortMovie::id is null");

        $this->id = strval($id);
        $this->name = strval($name);
        $this->poster_url = strval($poster_url);
		$this->kp_id = strval($kp_id);
    }
}

class ShortMovieRange
{
    public $from_ndx;
    public $total;
    public $short_movies;

    public function __construct($from_ndx, $total, $short_movies = null)
    {
        $this->from_ndx = intval($from_ndx);
        $this->total = intval($total);
        $this->short_movies = $short_movies === null ?
            array() : $short_movies;
    }
}

class MovieSeries
{
    public $id;
    public function __construct($id)
    {
        if (is_null($id))
            hd_print("MovieSeries::id is null");
        $this->id = strval($id);
    }
    public $name = '';
	public $img = '';
    public $playback_url = '';
    public $playback_url_is_stream_url = true;
	public $season_id = null;
}

class MovieSeason
{
    public $id;
    public function __construct($id)
    {
        if (is_null($id))
            hd_print("MovieSeason::id is null");
        $this->id = strval($id);
    }
    public $name = '';
    public $season_url = '';
	public $type = '';
}

class Movie implements UserInputHandler
{
    public $id;
    public $name = '';
    public $name_original = '';
    public $description = '';
    public $poster_url = '';
    public $length_min = -1;
    public $year = 0;
    public $directors_str = '';
    public $scenarios_str = '';
    public $actors_str = '';
    public $genres_str = '';
    public $rate_imdb = '';
    public $rate_kinopoisk = '';
    public $rate_mpaa = '';
    public $country = '';
    public $budget = '';
    public $rate_details;
    public $details;
    public $images;
	public $relap;
	public $entity_link;
	public $other_link;
	public $poxog;
	public $kp_id;
	public $urls;
    public $series_list = null;
	public $plugin_vod_series_ndx = null;
	const ID = 'smart_movie';
	
    public function __construct($id)
    {
        if (is_null($id))
            hd_print("Movie::id is null");
        $this->id = strval($id);
    }
	
	public function get_handler_id()
    { return self::ID; }
	
	public function handle_user_input(&$user_input, &$plugin_cookies)
    {
		$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
		
		if ($user_input->control_id == 'menu')
        {
			$defs = array();
			$add_action = UserInputHandlerRegistry::create_action($this, 'reviews');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_works', 'Отзывы', 300, $add_action);
			$add_action = UserInputHandlerRegistry::create_action($this, 'dload');
			if (HD::get_dload_app()==true)
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_link', 'Скачать', 300, $add_action);
			$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
			$attrs['actions'] = null;
			return ActionFactory::show_dialog("Меню", $defs,true,0,$attrs);
		}
		
		if ($user_input->control_id == 'dload')
        {
			$defs = array();
			$dload_dir_path = smbtree::get_folder_info ('dload_dir_path');
			if (!file_exists($dload_dir_path))
				return  ActionFactory::show_title_dialog('Папка для закачки не найдена!!!',null,"Папка не выбрана или удалена! Перейдите в настроки плагина (кнопка SETUP пульта) и выберите папку для закачки.",800,1);
			$dload_url = $this->series_list[$user_input->plugin_vod_series_ndx]->playback_url;
			$dload_list = HD::get_items('dload_list');
			$dload_list[$dload_url] = array ('dload_dir_path' => $dload_dir_path, 'folder_movie' => VodMovieScreen::get_media_url_str($user_input->plugin_vod_id), 'rd_url' => '');
			HD::save_items('dload_list',$dload_list);
			$dload_app = HD::get_dload_app();
			exec("$dload_app -x2 --file-allocation=none --continue=true --log-level=info $dload_url --dir=\"$dload_dir_path\" > ".DuneSystem::$properties['tmp_dir_path']. "/aria.log &");
			return UserInputHandlerRegistry::create_action($this, 'aria_inf');
		}
		
		if ($user_input->control_id == 'aria_inf')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			if ($this->counter < 5)
				$this->counter = $this->counter+1;
			else
				$this->counter = 0;
			
			$do_aria_inf = UserInputHandlerRegistry::create_action($this, 'aria_inf');
			$q = array();
			$preferred_width = 1400;
			$nmr = $size = $speed = $downloaded = $prsnt = $eta =
			$dfile = $qq = $d_complete = $status = false;
			if (file_exists(DuneSystem::$properties['tmp_dir_path']. '/aria.log')){
				$log = file_get_contents (DuneSystem::$properties['tmp_dir_path']. '/aria.log');
				if (preg_match('|================================================================================|', $log)){
					$tmp = explode ("================================================================================", $log);
					$log = array_pop($tmp);
					$fp = fopen(DuneSystem::$properties['tmp_dir_path']. '/aria.log', 'w');
					fwrite($fp, $log);
					fclose($fp);
				}
				$q = file(DuneSystem::$properties['tmp_dir_path']. '/aria.log', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
				if (isset($q[0])){
					foreach ($q as $v){
						if (preg_match("|#(.*?)\s|", $v, $matches)){
							$nmr = $matches[1];
							if (preg_match("|SIZE:(.*?)\/(.*?)\((.*?)\)\s|", $v, $matches)){
								$downloaded = $matches[1];
								$size = $matches[2];
								$prsnt = $matches[3];
							}
							if (preg_match("|\s(.*?)\/(.*?)\((.*?)\)\s|", $v, $matches)){
								$downloaded = $matches[1];
								$size = $matches[2];
								$prsnt = $matches[3];
							}
							if (preg_match("|ETA:(.*?)\]|", $v, $matches))
								$eta = $matches[1];
							if (preg_match("|SPD:(.*?)\s|", $v, $matches))
								$speed = $matches[1];
							if (preg_match("|DL:(.*?)\s|", $v, $matches))
								$speed = $matches[1];
						}else if (preg_match("|Download complete: (.*)|", $v, $matches))
							$d_complete = basename($matches[1])."\n" . $d_complete;
						else if (preg_match("|FILE: (.*)|", $v, $matches))
							$dfile = basename($matches[1]);
						else if (preg_match("#(\d*?)\|(.*?)\|(.*?)\|(.*)#", $v, $matches)){
							$nmr = $matches[1];
							$status = trim($matches[2]);
							if ($status== 'stat')
								continue;
							$speed = trim($matches[3]);
							$name = basename($matches[4]);
							$qq .= "[$nmr][$status] $name => [$speed]\n";
						}else if (preg_match("|download completed|", $v))
							$qq2 = "Закачки завершены";
					}
				}
				else{
					$qq2 = "Закачка запущена". str_repeat(".", $this->counter);
					$qq = "Старт". str_repeat(".", $this->counter);
					$status = 2;
					$preferred_width = 1000;
				}
			}else{
				$qq2 = "Закачки остановленны";
				$qq = "Закачек нет";
				$status = true;
				$preferred_width = 1000;
			}
			if ($status == false){
				ControlFactory::add_label($defs, '', str_repeat(".", round($prsnt/2)));
				ControlFactory::add_multiline_label($defs, 'Качаем:#'.$nmr, "[$size] $dfile",2);
				ControlFactory::add_label($defs, 'Скачано:', "[$downloaded][$prsnt] Скорость:$speed Осталось: $eta");
				if ($d_complete == true)
					ControlFactory::add_multiline_label($defs, 'Завершено:', $d_complete, 10);
				$attrs['timer'] = ActionFactory::timer(3000);
				$attrs['actions'] = array(GUI_EVENT_TIMER => ActionFactory::close_dialog_and_run($do_aria_inf));
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'aria_stop',	'Остановить закачку',500, UserInputHandlerRegistry::create_action($this, 'aria_stop'));
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'dload_list', 'Загрузки',500, ActionFactory::open_folder('dload_list', 'Загрузки'));
				return  ActionFactory::show_dialog('Состояние закачки'. str_repeat(".", $this->counter),$defs,true, $preferred_width,$attrs);
			}else{
				ControlFactory::add_multiline_label($defs, '', $qq, 10);
				if ($status != 2)
					ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'open_folder','Открыть папку',300, UserInputHandlerRegistry::create_action($this, 'open_folder'));
				$attrs['timer'] = ActionFactory::timer(3000);
				$attrs['actions'] = array(GUI_EVENT_TIMER => ActionFactory::close_dialog_and_run($do_aria_inf));
				return  ActionFactory::show_dialog($qq2,$defs,true, $preferred_width,$attrs);
			}
		}
		
		if ($user_input->control_id == 'reviews')
        {
			// if (isset($this->itemId)){
				// $domain_name = (HD::get_item('domain_name') !='') ? HD::get_item('domain_name') : 'http://fs.to';
				// $itemId = $this->itemId;
				// if (isset($user_input->nextPageToken))
					// $nextPageToken = $user_input->nextPageToken;
				// else
					// $nextPageToken = 0;
			// }else
				// return null;
					
			// $linkreview = HD::http_get_document($domain_name .'/review/list/i'. $itemId . '?itemisfull=1&loadedcount='.$nextPageToken);
			// $coments = '';
			// if (preg_match('|comments__count">(.*?)</p>|', $linkreview, $matches))
				// $coments .= 'У этого материала '. $matches[1] . "\n";
			// if (!preg_match('/data-count="end">/',$linkreview))
				// $nextPageToken = $nextPageToken + 9;
			// else
				// $nextPageToken = false;
			// $pattrern = "|<span itemprop=\"reviewer\">(.*?)</span>.*?";
			// $pattrern .= "comments__item-time\">(.*?)</time>.*?";
			// $pattrern .= "comments__item-answer-value\">(.*?)</span>.*?";
			// $pattrern .= "comments__item-answer-value\">(.*?)</span>.*?";
			// $pattrern .= "description\">(.*?)</div>|ms";
			
			// if (preg_match_all($pattrern, $linkreview, $com_arr)){
				// unset ($com_arr[0]);
				// foreach ($com_arr[1] as $key => $value){
					// $coments .= "[$value] ". HD::str_remove_tag($com_arr[2][$key]) . "\n"
					// . "Отзыв полезен: Да - ". $com_arr[3][$key] . ", Нет - ". $com_arr[4][$key]. "\n"
					// . HD::str_remove_tag($com_arr[5][$key]) .  "\n";
				// }
			// }
			// ControlFactory::add_multiline_label($defs, '', $coments, 15);
			// if ($nextPageToken==true){
				// $add_params ['nextPageToken'] = $nextPageToken;
				// ControlFactory::add_button_close(&$defs, $this, $add_params, 'reviews', '', 'Далее', 300);
			// }
			return  ActionFactory::show_dialog('Коментарии',$defs,true,1500,$attrs);
		}
		
		if ($user_input->control_id == 'sleep')
        {
			$defs = array();
			$sleep_time = '';
			$cron_file = '/tmp/cron/crontabs/root';
			$doc = file_get_contents($cron_file);
			$tmp = explode('Выключение в:', $doc);
			if (count($tmp) > 1)
				$sleep_time = strstr($tmp[1], '+', true);
			if (preg_match('/\[(\d\d)\:(\d\d)\] \[(\d\d)\-(\d\d)\]/', $sleep_time, $matches)){
				$docs = file_get_contents('/config/settings.properties');
				if (preg_match('/time_zone =(.*)\s/', $docs, $match)) {
					$tmp = explode(':', $match[1]);
					$rec_shift =($tmp[0] * 3600 ) + ($tmp[1] * 60 );
				}
				$year =  date("y");
				$timestamp = mktime($matches[1], $matches[2], 0, $matches[4], $matches[3], $year);
				$unix_time = time() - $rec_shift;
				if($timestamp < $unix_time){
					if (preg_match('/Выключение/i', $doc)){
						$tmp = explode('#*#*#', $doc);
						if (count($tmp) > 1)
							$sleep_old = strstr($tmp[1], '#-#-#', true);
						$sleep_old = "\n#*#*#" . $sleep_old . "#-#-#";
						$save_cron = "";
						$data = str_replace($sleep_old, $save_cron, $doc);
						$cron_data = fopen($cron_file,"w");
						if (!$cron_data)
							hd_print("НЕ МОГУ ЗАПИСАТЬ cron");
						fwrite($cron_data, $data);
						@fclose($cron_data);
						chmod($cron_file, 0575);
					}
				shell_exec('crontab -e');
				$sleep_time = '';
				}
			}
			$sleep_time_hour = 0;
			$sleep_time_ops = array();
			$sleep_time_ops ["0"] = 'Установите';
			$sleep_time_ops ["0.25"] = '15 минут';
			$sleep_time_ops ["0.5"] = '30 минут';
			$sleep_time_ops ["0.75"] = '45 минут';
			$sleep_time_ops ["1"] = '1 час';
			$sleep_time_ops ["1.25"] = '1 час 15 минут';
			$sleep_time_ops ["1.5"] = '1 час 30 минут';
			$sleep_time_ops ["1.75"] = '1 час 45 минут';
			$sleep_time_ops ["2"] = '2 часа';
			$sleep_time_ops ["2.5"] = '2 часа 30 минут';
			$sleep_time_ops ["3"] = '3 часа';
			$sleep_time_ops ["3.5"] = '3 часа 30 минут';
			$sleep_time_ops ["4"] = '4 часа';
			$sleep_time_ops ["4.5"] = '4 часа 30 минут';
			$sleep_time_ops ["5"] = '5 часов';
			$sleep_time_ops ["5.5"] = '5 часов 30 минут';
			$sleep_time_ops ["6"] = '6 часов';
			
			ControlFactory::add_combobox($defs, $this, null,
				'sleep_time_hour', 'Выключение через:',
				$sleep_time_hour, $sleep_time_ops, 0, $need_confirm = false, $need_apply = false
			);
			ControlFactory::add_button_close ($defs, $this, $add_params=null,'cleer_sleep',
			"Сброс Sleep таймера:", 'Очистить таймеры', 0);	
			
			ControlFactory::add_close_dialog_and_apply_button($defs,
				$this, null,
				'sleep_time', 'Применить', 300, $params=null);
			$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
			$attrs['actions'] = null;
			return ActionFactory::show_dialog("Sleep таймер $sleep_time", $defs,true,0,$attrs);
        }
		if ($user_input->control_id == 'sleep_time')
        {
			$sleep_time_hour = $user_input->sleep_time_hour;
			$sleep_time_hour = $sleep_time_hour * 3600;
			$settings_file = '/config/settings.properties';
			$doc = file_get_contents($settings_file);
			$tmp = explode('time_zone =', $doc);
			if (count($tmp) > 1)
				$sleep_shift = (strstr($tmp[1], ':', true));
			$sleep_shift = $sleep_shift * 3600;
			$seconds = '00';
			$year = date("Y");
			$cron_file = '/tmp/cron/crontabs/root';
			$doc = file_get_contents($cron_file);
			$unix_time = time() - $sleep_shift + $sleep_time_hour;
			$date = date("m-d H:i:s" , $unix_time);
			$day_s = date("d", $unix_time);
			$mns_s = date("m", $unix_time);
			$hrs_s = date("H", $unix_time);
			$min_s = date("i", $unix_time);
			$unix_time = time() + $sleep_time_hour;
			HD::save_item_tmp('unix_time', $unix_time);
			$date = date("m-d H:i:s" , $unix_time);
			$day_s1 = date("d", $unix_time);
			$mns_s1 = date("m", $unix_time);
			$hrs_s1 = date("H", $unix_time);
			$min_s1 = date("i", $unix_time);
			if (preg_match('/Выключение/i', $doc)){
				$tmp = explode('#*#*#', $doc);
				if (count($tmp) > 1)
					$sleep_old = strstr($tmp[1], '#-#-#', true);
				$sleep_old = "\n#*#*#" . $sleep_old . "#-#-#";
				$save_cron = "\n#*#*# Выключение в: [$hrs_s:$min_s] [$day_s-$mns_s] + \n$min_s1 $hrs_s1 $day_s1 $mns_s1 * wget --quiet -O - \"http://127.0.0.1/cgi-bin/do?cmd=standby\"\n#-#-#";
				$data = str_replace($sleep_old, $save_cron, $doc);
				$cron_data = fopen($cron_file,"w");
				if (!$cron_data)
					hd_print("НЕ МОГУ ЗАПИСАТЬ cron");
				fwrite($cron_data, $data);
				@fclose($cron_data);
				chmod($cron_file, 0575);
			}else{
				$save_cron = "\n#*#*# Выключение в: [$hrs_s:$min_s] [$day_s-$mns_s] + \n$min_s $hrs_s1 $day_s1 $mns_s1 * wget --quiet -O - \"http://127.0.0.1/cgi-bin/do?cmd=standby\"\n#-#-#";
				$cron_data = fopen($cron_file,"a");
				if (!$cron_data)
					hd_print("НЕ МОГУ ЗАПИСАТЬ cron");
				fwrite($cron_data, $save_cron);
				@fclose($cron_data);
				chmod($cron_file, 0575);
			}
			shell_exec('crontab -e');
			return null;
		}
		if ($user_input->control_id == 'sleep_warn')
        {
			$defs = array();
			$sleep_time = '';
			if (preg_match('|Выключение в:(.*)\+|', file_get_contents('/tmp/cron/crontabs/root'), $match))
				$sleep_time = $match[1];
			HD::save_item_tmp('unix_time', 0);
			ControlFactory::add_label($defs, 'Выключение через:', "1-2 мин.");
			$sleep_time_hour = 0;
			$sleep_time_ops = array();
			$sleep_time_ops ["0"] = 'Установите';
			$sleep_time_ops ["0.05"] = '15 минут';
			$sleep_time_ops ["0.5"] = '30 минут';
			$sleep_time_ops ["0.75"] = '45 минут';
			$sleep_time_ops ["1"] = '1 час';
			$sleep_time_ops ["1.25"] = '1 час 15 минут';
			$sleep_time_ops ["1.5"] = '1 час 30 минут';
			$sleep_time_ops ["1.75"] = '1 час 45 минут';
			$sleep_time_ops ["2"] = '2 часа';
			$sleep_time_ops ["2.5"] = '2 часа 30 минут';
			$sleep_time_ops ["3"] = '3 часа';
			$sleep_time_ops ["3.5"] = '3 часа 30 минут';
			$sleep_time_ops ["4"] = '4 часа';
			$sleep_time_ops ["4.5"] = '4 часа 30 минут';
			$sleep_time_ops ["5"] = '5 часов';
			$sleep_time_ops ["5.5"] = '5 часов 30 минут';
			$sleep_time_ops ["6"] = '6 часов';
				
			ControlFactory::add_combobox($defs, $this, null, 'sleep_t_hour', 'Выключение через:', $sleep_time_hour, $sleep_time_ops, 0, $need_confirm = false, $need_apply = false);
			$do_time_hour = UserInputHandlerRegistry::create_action($this, 'sleep_time_hour');
			ControlFactory::add_button_close ($defs, $this, $add_params=null,'cleer_sleep',	"Сброс Sleep таймера:", 'Очистить таймеры', 0);
			$sleep_time_hour = UserInputHandlerRegistry::create_action($this, 'sleep_time_hour');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,	'_sleep_time_hour', 'Применить', 250, $sleep_time_hour);
			$attrs['timer'] = ActionFactory::timer(30000);
			$attrs['actions'] = array(GUI_EVENT_TIMER => ActionFactory::close_dialog());
			$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
			return  ActionFactory::show_dialog("Sleep таймер $sleep_time",$defs,true, 0,$attrs);
		}
		
		if ($user_input->control_id == 'cleer_sleep')
        {
			$cron_file = '/tmp/cron/crontabs/root';
			$doc = file_get_contents($cron_file);
			if (preg_match('/Выключение/i', $doc))
			{
				$tmp = explode('#*#*#', $doc);
				if (count($tmp) > 1)
				$sleep_old = strstr($tmp[1], '#-#-#', true);
				$sleep_old = "\n#*#*#" . $sleep_old . "#-#-#";
				$save_cron = "";
				$data = str_replace($sleep_old, $save_cron, $doc);
				$cron_data = fopen($cron_file,"w");
				if (!$cron_data)
				hd_print("НЕ МОГУ ЗАПИСАТЬ cron");
				fwrite($cron_data, $data);
				@fclose($cron_data);
				chmod($cron_file, 0575);
			}
			else
				return ActionFactory::show_title_dialog_gl("Таймер выключениня не был задан!");
			shell_exec('crontab -e');
			return UserInputHandlerRegistry::create_action($this, 'sleep', $params=null);
		}
		
		if ($user_input->control_id == 'watched')
        {
			if ((isset($this->playback_info))&&($this->playback_info != null)){
				$series = $this->series_list[$this->playback_info_ndx];
				if ($series->season_id == true){
					$save_folder = HD::get_items('save_folder');
					if ((isset($save_folder[$user_input->plugin_vod_id][$series->season_id]))&&
					($save_folder[$user_input->plugin_vod_id][$series->season_id] !='not_check')){
						$save_folder[$user_input->plugin_vod_id][$series->season_id][] = $series->playback_url;
						HD::save_items('save_folder', $save_folder);
					}
				}
				if ((!preg_match("/audio\//i",$user_input->plugin_vod_id))&&(!preg_match("/clips\//i",$user_input->plugin_vod_id))&&
				(!preg_match("/\.(?:mp3|wav|og(?:g|a)|flac|midi?|rm|m4a|aac|wma|mka|ape|jpg|png)$/i",$series->playback_url))){
						$viewed_items = HD::get_items('viewed_items');
						$viewed_items[$series->playback_url] = $this->playback_info;
						HD::save_items('viewed_items', $viewed_items);
				}
				if (isset($user_input->playback_stop_pressed)){
					$hide_history = isset($plugin_cookies->hide_history) ? $plugin_cookies->hide_history : 'nohide';
					if ($hide_history == 'nohide'){
						if (HD::get_lock_items()=='unlock'){
							$history_items = HD::get_items('history_items');
							$history_items = array_reverse($history_items, true);
							if (isset($history_items[$user_input->plugin_vod_id]))
								unset ($history_items[$user_input->plugin_vod_id]);
							$history_items[$user_input->plugin_vod_id] = array('name' => $this->name,'poster_url' => $this->poster_url, 'info' => $this->name."|$series->name||Просмотрено:|".date("d.m.Y"),'kp_id' => $this->kp_id);
							$history_items = array_reverse($history_items, true);
							if (count($history_items) == 31)
								array_pop($history_items);
							HD::save_items('history_items', $history_items);
						}
					}
					
					if ((!preg_match("/audio\//i",$user_input->plugin_vod_id))&&(!preg_match("/clips\//i",$user_input->plugin_vod_id))&&
					(!preg_match("/\.(?:mp3|wav|og(?:g|a)|flac|midi?|rm|m4a|aac|wma|mka|ape|jpg|png)$/i",$series->playback_url))){
						// if ($series->season_id == true)
							$mUrl = VodSeriesListScreen::get_media_url_str($user_input->plugin_vod_id,$series->season_id);
						// else
							// $mUrl = VodSeasonListScreen::get_media_url_str($user_input->plugin_vod_id);
						sleep (1);
						return ActionFactory::invalidate_folders(array($mUrl), null );
					}
				}
			}
		}
		
		if ($user_input->control_id == 'timer')
        {
			$actions = $this->get_movie_actions();
			$post_action = null;
			$sleep_unix_time = HD::get_item_tmp('unix_time');
			if ($sleep_unix_time > 0){
				$unix_time = time();
				$r = $sleep_unix_time - $unix_time;
				if (($r>120)||($r<0))
					$post_action = null;
				else
					$post_action = UserInputHandlerRegistry::create_action($this, 'sleep_warn');
			}
			$ext_command = file_get_contents('/tmp/run/ext_command.state');
			if ((preg_match('/playback_position = (\d*)/', $ext_command, $match))
				&&(preg_match('/playback_duration = (\d*)/', $ext_command, $matches)))
				if ((intval($match[1])>0)&&(intval($matches[1])>0))
					$this->playback_info = array ($match[1],$matches[1]);
					$this->playback_info_ndx = $user_input->plugin_vod_series_ndx;
			return  ActionFactory::change_behaviour($actions, 5000, $post_action);
		}
		
	    return null;
    }
	
    private function to_string($v)
    {
        return $v === null ? '' : strval($v);
    }

    private function to_int($v, $default_value)
    {
        $v = strval($v);
        if (!is_numeric($v))
            return $default_value;
        $v = intval($v);
        return $v <= 0 ? $default_value : $v;
    }

    public function set_data(
        $name,
        $name_original,
        $description,
        $poster_url,
        $length_min,
        $year,
        $directors_str,
        $scenarios_str,
        $actors_str,
        $genres_str,
        $rate_imdb,
        $rate_kinopoisk,
        $rate_mpaa,
        $country,
        $budget,
		$rate_details,
		$details,
		$images,
		$relap,
		$entity_link,
		$other_link,
		$poxog,
		$kp_id,
		$urls)
    {
        $this->name = $this->to_string($name);
        $this->name_original = $this->to_string($name_original);
        $this->description = $this->to_string($description);
        $this->poster_url = $this->to_string($poster_url);
        $this->length_min = $this->to_int($length_min, -1);
        $this->year = $this->to_int($year, -1);
        $this->directors_str = $this->to_string($directors_str);
        $this->scenarios_str = $this->to_string($scenarios_str);
        $this->actors_str = $this->to_string($actors_str);
        $this->genres_str = $this->to_string($genres_str);
        $this->rate_imdb = $this->to_string($rate_imdb);
        $this->rate_kinopoisk = $this->to_string($rate_kinopoisk);
        $this->rate_mpaa = $this->to_string($rate_mpaa);
        $this->country = $this->to_string($country);
        $this->budget = $this->to_string($budget);
		$this->rate_details = $rate_details;
		$this->details = $details;
		$this->images = $images;
		$this->relap = $relap;
		$this->entity_link = $entity_link;
		$this->other_link = $other_link;
		$this->poxog = $poxog;
		$this->kp_id = $kp_id;
		$this->urls = $urls;
        $this->series_list = array();
    }

    public function add_series_data($id, $name, $img,
        $playback_url, $playback_url_is_stream_url, $season_id=null, $size=null, $episode=null, $info=null)
    {
        $series = new MovieSeries($id);

        $series->name = $this->to_string($name);
		$series->img = $this->to_string($img);
        $series->playback_url = $this->to_string($playback_url);
        $series->playback_url_is_stream_url =
            $playback_url_is_stream_url === true;
		if ($season_id == true)
			$series->season_id = $this->to_string($season_id);
		if ($size == true)
			$series->size = $this->to_string($size);
		if ($episode == true)
			$series->episode = $this->to_string($episode);
		if ($info == true)
			$series->info = $this->to_string($info);
        $this->series_list[] = $series;
    }
	
	public function add_season_data($id, $name,
        $season_url, $type)
    {
        $season = new MovieSeason($id);
        $season->name = $this->to_string($name);
        $season->season_url = $this->to_string($season_url);
		$season->type = $this->to_string($type);
        $this->season_list[] = $season;
    }

    public function get_movie_array()
    {
        return array(
            PluginMovie::name => $this->name,
            PluginMovie::name_original => $this->name_original,
            PluginMovie::description => $this->description,
            PluginMovie::poster_url => $this->poster_url,
            PluginMovie::length_min => $this->length_min,
            PluginMovie::year => $this->year,
            PluginMovie::directors_str => $this->directors_str,
            PluginMovie::scenarios_str => $this->scenarios_str,
            PluginMovie::actors_str => $this->actors_str,
            PluginMovie::genres_str => $this->genres_str,
            PluginMovie::rate_imdb => $this->rate_imdb,
            PluginMovie::rate_kinopoisk => $this->rate_kinopoisk,
            PluginMovie::rate_mpaa => $this->rate_mpaa,
            PluginMovie::country => $this->country,
            PluginMovie::budget => $this->budget,
			PluginMovie::details =>  $this->details,
			PluginMovie::rate_details   => $this->rate_details,
        );
    }
	
	protected function get_movie_actions()
    {
        UserInputHandlerRegistry::get_instance()->register_handler($this);
		$actions[GUI_EVENT_KEY_CLEAR] = UserInputHandlerRegistry::create_action($this, 'aria_inf');
        $actions[GUI_EVENT_PLAYBACK_STOP] = UserInputHandlerRegistry::create_action($this, 'watched');
		$actions[GUI_EVENT_KEY_C_YELLOW] = UserInputHandlerRegistry::create_action($this, 'sleep');
		$actions[GUI_EVENT_KEY_D_BLUE] = UserInputHandlerRegistry::create_action($this, 'menu');
        $actions[GUI_EVENT_TIMER] = UserInputHandlerRegistry::create_action($this, 'timer');
        return $actions;        
    }

    public function get_vod_info($sel_id, $buffering_ms)
    {
		if (!is_array($this->series_list) ||
            count($this->series_list) == 0)
        {
            hd_print('Invalid movie: series list is empty');
        }
		$viewed_items = HD::get_items('viewed_items');
        $series_array = array();
        $initial_series_ndx = -1;
		$initial_position_ms = array();
        foreach ($this->series_list as $ndx => $series)
        {
			$tt = '';
			if (isset($viewed_items[$series->playback_url])){
				if ($viewed_items[$series->playback_url] =='viewed')
					$tt = '[ПРОСМ] ';
				else{
					$tt = '[ПРОСМ ' . HD::sec_format_duration($viewed_items[$series->playback_url][0]) . '/' . HD::sec_format_duration($viewed_items[$series->playback_url][1]) . '] ';
					$pos = intval($viewed_items[$series->playback_url][0]);
					if ($pos < 0)
						$pos = 0;
					if ($pos + 5 >= intval($viewed_items[$series->playback_url][1]))
						$pos = 0;
					$initial_position_ms[$ndx] = $pos * 1000;
				}
			}
			if (!is_null($sel_id) && $series->playback_url === $sel_id)
                $initial_series_ndx = $ndx;
            $series_array[] = array(
                PluginVodSeriesInfo::name => $tt . $series->name,
                PluginVodSeriesInfo::playback_url => $series->playback_url,
                PluginVodSeriesInfo::playback_url_is_stream_url =>
                    $series->playback_url_is_stream_url,
            );
        }
		$ims = 0;
		if (isset($initial_position_ms[$initial_series_ndx]))
			$ims = $initial_position_ms[$initial_series_ndx];
        return array(
            PluginVodInfo::id => $this->id,
            PluginVodInfo::name => $this->name,
            PluginVodInfo::description => $this->description,
            PluginVodInfo::poster_url => $this->poster_url,
            PluginVodInfo::series => $series_array,
            PluginVodInfo::initial_series_ndx => $initial_series_ndx,
            PluginVodInfo::buffering_ms => $buffering_ms,
			PluginVodInfo::actions => $this->get_movie_actions(),
			PluginVodInfo::timer => array(GuiTimerDef::delay_ms => 5000),
			PluginVodInfo::initial_position_ms => $ims,
        );
    }
}

?>
