<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/abstract_preloaded_regular_screen.php';

///////////////////////////////////////////////////////////////////////////

class TvGroupListScreen extends AbstractPreloadedRegularScreen
    implements UserInputHandler
{
    const ID = 'tv_group_list';

    ///////////////////////////////////////////////////////////////////////

    protected $tv;

    ///////////////////////////////////////////////////////////////////////

    public function __construct($tv, $folder_views)
    {
        parent::__construct(self::ID, $folder_views);

        $this->tv = $tv;
		UserInputHandlerRegistry::get_instance()->
            register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
        $actions = array();
		$add_action = ActionFactory::open_folder(SmartSetupScreen::get_media_url_str(),"Настройки");
		$actions[GUI_EVENT_KEY_SETUP] = $add_action;
		$add_action['caption'] = 'Настройки';
		$actions[GUI_EVENT_KEY_C_YELLOW] = $add_action;
		$add_action = UserInputHandlerRegistry::create_action($this, 'whats_new');
        $add_action['caption'] = 'v' . HD::ver();
        $actions[GUI_EVENT_KEY_B_GREEN] = $add_action;
		$add_action = UserInputHandlerRegistry::create_action($this, 'get_info');
        $add_action['caption'] = 'Информация';
        $actions[GUI_EVENT_KEY_D_BLUE] = $add_action;
		$actions[GUI_EVENT_KEY_INFO] = $add_action;
		$actions[GUI_EVENT_KEY_ENTER] = ActionFactory::open_folder();
		$actions[GUI_EVENT_KEY_PLAY]  = ActionFactory::tv_play();
		$popup_menu_action = UserInputHandlerRegistry::create_action($this, 'popup_menu');
		$actions[GUI_EVENT_KEY_POPUP_MENU] = $popup_menu_action;
		return  $actions;
    }
	
	public function get_handler_id()
    { return self::ID; }
    ///////////////////////////////////////////////////////////////////////
	
	public function handle_user_input(&$user_input, &$plugin_cookies)
    {
		$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
		if ($user_input->control_id == 'add_category')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$defs = array();
			ControlFactory::add_text_field($defs,
				$this, $add_params=null,
				'newname', '',
				'', 0, 0, 1, 1, 1300, 0, 1);
			ControlFactory::add_vgap($defs, 500);	
			return  ActionFactory::show_dialog("Укажите название категории и выберите иконку",$defs,true,1200,$attrs);
        }

		if ($user_input->control_id === 'get_info'){
            $defs = array();
			$tsproxy_access = $success = $vip_status = 'Нет';
			$user_info = SmartConfig::get_user_info();
			
			if ($user_info->success == 1)
				$success = 'Да';
			else
				ControlFactory::add_label($defs,'Error:', $user_info->error);
			ControlFactory::add_label($defs,'Пользователь авторизован:', $success);
			
			ControlFactory::add_label($defs,'Баланс:',  number_format(round($user_info->balance, 2), 2,  '.', '') . ' руб.');
			if ($user_info->vip_status == 1)
				$vip_status = 'Да';
			ControlFactory::add_label($defs,'VIP статус:', $vip_status);
			
			if ($user_info->tsproxy_access == 1){
				$tsproxy_access = 'Да';
				ControlFactory::add_label($defs,'Серверный ts-proxy:', $tsproxy_access);
				ControlFactory::add_label($defs,'Тариф ts-proxy:', $user_info->tsproxy_tariff);
				ControlFactory::add_label($defs,'Cерверный TS-Proxy до:', date("d.m.Y (G:i)", $user_info->tsproxy_date));
				$zones = SmartConfig::get_zones();
				ControlFactory::add_label($defs,'Источник TS-Proxy (город):', $zones[$user_info->zone_id]);
				ControlFactory::add_img_label($defs, '', '<icon>gui_skin://small_icons/info.aai</icon><text dy="7" size="small">Источник изменяется в настройках</text>', 0, 0, 0);
			}
			return ActionFactory::show_dialog('Информация по пользователю', $defs,true,1200,$attrs);
		}
				
		if ($user_input->control_id === 'cleer_folder')
		{
			if (!isset($user_input->parent_media_url))
				return null;
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$sel_ndx = $user_input->sel_ndx;
				if ($sel_ndx < 0)
					$sel_ndx = 0;
			$range = $this->get_folder_range($parent_media_url, 0, $plugin_cookies);
			return ActionFactory::update_regular_folder($range, true, $sel_ndx);
		}
		
		if ($user_input->control_id == 'add_group_img')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			if ($user_input->selected_media_url =='tv_group_list'){
				$action = 'plugin_ico';
				$arg = 'tv_group_list';
			}
			else if ($media_url->screen_id =='vod_favorites'){
				$action = 'plugin_ico';
				$arg = 'vod_favorites';
			}
			else{
				$action = 'portals_link';
				$arg = $media_url->category_id;
			}
			$media_url = MediaURL::encode (
                    array
                    (
                        'screen_id'     => 'file_list',
						'save_file'		=> array(	
						'parent' => self::ID,
						'action' => $action,
						'arg' => $arg,
						'extension' => 'png'
						),
                    )
			);
			return ActionFactory::open_folder($media_url,'Folders');
		}

		if ($user_input->control_id == 'del_plugin_img')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$plugin_ico = HD::get_items('plugin_ico');
			if (isset($plugin_ico[$media_url->group_id])){
				$mci = $plugin_ico[$media_url->group_id];
				unset ($plugin_ico[$media_url->group_id]);
			}
			if (isset($plugin_ico[$media_url->screen_id])){
				$mci = $plugin_ico[$media_url->screen_id];
				unset ($plugin_ico[$media_url->screen_id]);
			}
			HD::save_items('plugin_ico', $plugin_ico);
			unlink($mci);
			return ActionFactory::invalidate_folders(array(self::ID), null);
		}
		
		if ($user_input->control_id == 'add_portal_img')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			if ($media_url->screen_id =='tv_favorites')
				$arg = 'tv_favorites';
			else
				$arg = $media_url->group_id;
			$media_url = MediaURL::encode (
                    array
                    (
                        'screen_id'     => 'file_list',
						'save_file'		=> array(	
						'parent' => self::ID,
						'action' => 'plugin_ico',
						'arg' => $arg,
						'extension' => 'png'
						),
                    )
			);
			return ActionFactory::open_folder($media_url,'Выбор иконки категорий');
		}
		
		if ($user_input->control_id == 'up_group')
		{
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$group = $this->tv->get_group($media_url->group_id);
			$name_pl = $group->get_title();				
			$group_list = HD::get_items('group_list');
			$group_list = array_flip($group_list);
			unset ($group_list[$name_pl]) ;
			$group_list = array_flip($group_list);
			array_unshift($group_list, $name_pl);
			HD::save_items('group_list', $group_list);
			return ActionFactory::invalidate_folders(array('tv_group_list'), null);
		}
		
		if ($user_input->control_id == 'add_tv_group_bg')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$msg = "Для применения изменений выйдите из плагина, нажмите кнопку POPUP и выберите 'Обновить'.";
			$media_url = MediaURL::encode (
                    array
                    (
                        'screen_id'     => 'file_list',
						'save_file'		=> array(	
						'parent' => self::ID,
						'action' => 'plugin_ico',
						'arg' => 'tv_group_bg',
						'msg' => $msg,
						'extension' => 'jpg'
						),
                    )
			);
			return ActionFactory::open_folder($media_url,'Выбор бекграунда');
		}
		
		if ($user_input->control_id == 'del_tv_group_bg')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$plugin_ico = HD::get_items('plugin_ico');
			unlink($plugin_ico['tv_group_bg']);
			unset ($plugin_ico['tv_group_bg']);
			HD::save_items('plugin_ico', $plugin_ico);
			return ActionFactory::invalidate_folders(array('vod_category_list'), 
			ActionFactory::show_title_dialog('Бекграунд удален',null,"Для применения изменений выйдите из плагина, нажмите кнопку POPUP и выберите 'Обновить'.",800,1));
		}
		if ($user_input->control_id == 'whats_new')
        {
			$doc = HD::http_get_document('http://dune-club.info/plugins/update/'.DuneSystem::$properties['plugin_name'].'/info.txt');
			ControlFactory::add_img_label($defs, '', '<icon>gui_skin://special_icons/controls_button_yellow.aai</icon><text dy="7" size="small"> - во время просмотра Sleep timer</text>', 0, 0, 0);
			ControlFactory::add_img_label($defs, '', '<icon>gui_skin://small_icons/info.aai</icon><text dy="7" size="small"> кнопка INFO в категориях - информация</text>', 0, 0, 0);
			ControlFactory::add_img_label($defs, '', '<icon>'.DuneSystem::$properties['install_dir_path'].'/icons/setup.png</icon><text dy="7" size="small"> - переход в настройки плагина</text>', 0, 0, 0);
			ControlFactory::add_multiline_label($defs, '', $doc, 10);
			ControlFactory::add_close_dialog_button($defs, 'ОК', 300);
			return ActionFactory::show_dialog('Информация об изменениях.', $defs,true,1200,$attrs);
        }
		if ($user_input->control_id == 'popup_menu')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);

			$menu_items[] = array(
            GuiMenuItemDef::caption => 'Задать иконку',
            GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'add_portal_img'),
			GuiMenuItemDef::icon_url => 'gui_skin://small_icons/photo_viewer.aai'
			);
			
			$plugin_ico = HD::get_items('plugin_ico');
			if ((isset($plugin_ico[$media_url->group_id]))||
				(isset($plugin_ico[$media_url->screen_id]))){
				$menu_items[] = array(
				GuiMenuItemDef::caption => 'Удалить иконку',
				GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'del_plugin_img'),
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
				);
			}
			
			if ($media_url->screen_id != 'tv_favorites'){
				$up_group_action = UserInputHandlerRegistry::create_action($this, 'up_group');
				$up_group_caption = 'Поднять вверх';
				$menu_items[] = array(
				GuiMenuItemDef::caption => $up_group_caption,
				GuiMenuItemDef::action => $up_group_action);
			}

			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
				
			$menu_items[] = array(
            GuiMenuItemDef::caption => 'Задать бекграунд',
            GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'add_tv_group_bg'),
			GuiMenuItemDef::icon_url => 'gui_skin://small_icons/photo_viewer.aai'
			);
			
			if (isset($plugin_ico['tv_group_bg'])){
				$menu_items[] = array(
				GuiMenuItemDef::caption => 'Удалить бекграунд',
				GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'del_tv_group_bg'),
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
				);
			}
			return ActionFactory::show_popup_menu($menu_items);
        }
        return null;
    }
	
    public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies)
    {
		$this->tv->folder_entered($media_url, $plugin_cookies);
        $this->tv->ensure_channels_loaded($plugin_cookies);

        $items = array();
		$group_list = HD::get_items('group_list');
		$i=1000;
        foreach ($this->tv->get_groups() as $group)
        {
            $media_url = $group->is_favorite_channels() ?
                TvFavoritesScreen::get_media_url_str() :
                TvChannelListScreen::get_media_url_str($group->get_id());

            $key = false;
			if ($group->get_id()=='__favorites')
				$n = 0;
			else{
				$key = array_search($group->get_title(), $group_list);
				if ($key === false)
					$n = $i;
				else
					$n = $key+2;
			}

			$items[$n] = array
            (
                PluginRegularFolderItem::media_url => $media_url,
                PluginRegularFolderItem::caption => $group->get_title(),
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $group->get_icon_url(),
                    ViewItemParams::item_detailed_icon_path => $group->get_icon_url()
                )
            );
			$i++;
        }
		foreach (SmartConfig::get_menu() as $k => $v){
			$key = array_search($v['caption'], $group_list);
				if ($key === false)
					$n = $i;
				else
					$n = $key+2;
			$items[] = array
			(
				PluginRegularFolderItem::media_url => $v['mUrl'],
				PluginRegularFolderItem::caption => $v['caption'],
				PluginRegularFolderItem::view_item_params => array
				(
					ViewItemParams::icon_path => $v['img'],
				),
			);
			$i++;
		}
		ksort($items);
		$items = array_values($items);
        $this->tv->add_special_groups($items);
        return $items;
    }

    public function get_archive(MediaURL $media_url)
    {
        return $this->tv->get_archive($media_url);
    }
}

///////////////////////////////////////////////////////////////////////////
?>
