<?php

require_once 'lib/tv/tv.php';
require_once 'lib/abstract_preloaded_regular_screen.php';

class TvFavoritesScreen extends AbstractPreloadedRegularScreen
    implements UserInputHandler
{
    const ID = 'tv_favorites';

    public static function get_media_url_str()
    {
        return MediaURL::encode(
            array(
                'screen_id' => self::ID,
                'is_favorites' => true));
    }

    ///////////////////////////////////////////////////////////////////////

    private $tv;
	private $select_id = false;
    public function __construct(Tv $tv, $folder_views)
    {
        $this->tv = $tv;

        parent::__construct(self::ID, $folder_views);

        UserInputHandlerRegistry::get_instance()->register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
		$actions = array();
		$use_fav = (HD::get_item('use_fav') !='') ? HD::get_item('use_fav') : 0;
		$add_action = UserInputHandlerRegistry::create_action($this, 'remove_favorite');
		$menu_items[] = array(
            GuiMenuItemDef::caption => 'Удалить из избранного',
            GuiMenuItemDef::action => $add_action,
			GuiMenuItemDef::icon_url => 'gui_skin://button_icons/cancel.aai');
		if ($use_fav == 1){
			$nbr_favorite_action = UserInputHandlerRegistry::create_action($this, 'nbr_favorite');		
			$menu_items[] = array(
				GuiMenuItemDef::caption => 'Задать позицию канала',
				GuiMenuItemDef::action => $nbr_favorite_action,
				GuiMenuItemDef::icon_url => 'gui_skin://button_icons/proceed.aai');
		}
		
		$menu_items[] = array(
                GuiMenuItemDef::caption => 'Выделить (SELECT)',
                GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'select'),
				GuiMenuItemDef::icon_url => 'gui_skin://button_icons/restart.aai'
				);
				
		$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
				
		$menu_items[] = array(
                GuiMenuItemDef::caption => 'Обновить список каналов',
                GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'cleer_folder_key'),
				GuiMenuItemDef::icon_url => 'gui_skin://small_icons/service_file.aai'
				);
        $popup_menu_action = ActionFactory::show_popup_menu($menu_items);
		
		$add_action = ActionFactory::open_folder(SmartSetupScreen::get_media_url_str(),"Настройки");
		$actions[GUI_EVENT_KEY_SETUP]	= $add_action;
		$actions[GUI_EVENT_KEY_ENTER]	= ActionFactory::tv_play();
		$actions[GUI_EVENT_KEY_PLAY]	= ActionFactory::tv_play();
		$add_action = UserInputHandlerRegistry::create_action($this, 'move_backward_favorite');
        $add_action['caption'] = 'Вверх';
        $actions[GUI_EVENT_KEY_B_GREEN] = $add_action;
		$add_action = UserInputHandlerRegistry::create_action($this, 'move_forward_favorite');
        $add_action['caption'] = 'Вниз';
        $actions[GUI_EVENT_KEY_C_YELLOW] = $add_action;
		$add_action = UserInputHandlerRegistry::create_action($this, 'remove_favorite');
        $add_action['caption'] = 'Удалить';
        $actions[GUI_EVENT_KEY_D_BLUE] = $add_action;
		$actions[GUI_EVENT_KEY_POPUP_MENU] = $popup_menu_action;
		$actions[GUI_EVENT_KEY_SELECT] = UserInputHandlerRegistry::create_action($this, 'select');
		return  $actions;
		
    }

    public function get_handler_id()
    { return self::ID; }

    private function get_update_action($sel_increment,
        &$user_input, &$plugin_cookies)
    {
        $parent_media_url = MediaURL::decode($user_input->parent_media_url);

        $num_favorites = 
            count($this->tv->get_fav_channel_ids($plugin_cookies));

        $sel_ndx = $user_input->sel_ndx + $sel_increment;
        if ($sel_ndx < 0)
            $sel_ndx = 0;
        if ($sel_ndx >= $num_favorites)
            $sel_ndx = $num_favorites - 1;

        $range = HD::create_regular_folder_range(
            $this->get_all_folder_items(
                $parent_media_url, $plugin_cookies));
        return ActionFactory::update_regular_folder(
            $range, true, $sel_ndx);
    }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
		$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
		if ($user_input->control_id == 'move_backward_favorite')
        {
            if (!isset($user_input->selected_media_url))
                return null;

            $media_url = MediaURL::decode($user_input->selected_media_url);
            $channel_id = $media_url->channel_id;

            $this->tv->change_tv_favorites(PLUGIN_FAVORITES_OP_MOVE_UP,
                $channel_id, $plugin_cookies);

            return $this->get_update_action(-1, $user_input, $plugin_cookies);
        }
		
		if ($user_input->control_id == 'select')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$links = $this->select_id;
			if (isset($links[$media_url->channel_id]))
				unset ($links[$media_url->channel_id]);
			else
				$links[$media_url->channel_id] = 1;
			$this->select_id = $links;
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder_plus');
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
		}
		
		if ($user_input->control_id === 'cleer_folder')
		{
			if (!isset($user_input->parent_media_url))
				return null;
			$this->select_id = false;
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$sel_ndx = $user_input->sel_ndx;
				if ($sel_ndx < 0)
					$sel_ndx = 0;
			$range = $this->get_folder_range($parent_media_url, 0, $plugin_cookies);
			return ActionFactory::update_regular_folder($range, true, $sel_ndx);
		}
		
		if ($user_input->control_id === 'cleer_folder_key')
		{
			if (!isset($user_input->parent_media_url))
				return null;
			$this->tv->global_channels = null;
			$this->select_id = false;
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
		}
		
		if ($user_input->control_id === 'cleer_folder_plus')
		{
			if (!isset($user_input->parent_media_url))
				return null;
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$sel_ndx = $user_input->sel_ndx+1;
				if ($sel_ndx < 0)
					$sel_ndx = 0;
			$range = $this->get_folder_range($parent_media_url, 0, $plugin_cookies);
			return ActionFactory::update_regular_folder($range, true, $sel_ndx);
		}
        if ($user_input->control_id == 'move_forward_favorite')
        {
            if (!isset($user_input->selected_media_url))
                return null;

            $media_url = MediaURL::decode($user_input->selected_media_url);
            $channel_id = $media_url->channel_id;

            $this->tv->change_tv_favorites(PLUGIN_FAVORITES_OP_MOVE_DOWN,
                $channel_id, $plugin_cookies);

            return $this->get_update_action(1, $user_input, $plugin_cookies);
        }
        if ($user_input->control_id == 'remove_favorite')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			if ($this->select_id==true)
				 $channel_ids = $this->select_id;
			else{
				$media_url = MediaURL::decode($user_input->selected_media_url);
				$channel_ids[$media_url->channel_id] = $media_url->channel_id;
			}
			foreach ($channel_ids as $channel_id => $v){
				$this->tv->change_tv_favorites(PLUGIN_FAVORITES_OP_REMOVE,
					$channel_id, $plugin_cookies);
			}
			$this->select_id = false;
            return $this->get_update_action(0, $user_input, $plugin_cookies);
        }
		if ($user_input->control_id == 'nbr_favorite')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$defs = array();
			ControlFactory::add_text_field($defs, $this, $add_params=null,
				'nbr',
				'Укажите позицию канала',
				'', 1, 0, 0, 1, 250, 0, false
			);

			$do_new_login_action = UserInputHandlerRegistry::create_action($this, 'do_nbr_action');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'apply_subscription', 'Применить', 350, $do_new_login_action);
			return ActionFactory::show_dialog("Позиция канала в Избранном Торрент-ТВ", $defs, true,0,$attrs);
        }
		if ($user_input->control_id == 'do_nbr_action')
        {
			if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			if ($user_input->nbr==0)
				return ActionFactory::show_title_dialog('Err!',null,"Укажите номер канала! Начиная с единицы!",800,1);			
			SmartConfig::ttv_fav_nbr($media_url->channel_id, $user_input->nbr);
            return $this->get_update_action(0, $user_input, $plugin_cookies);
        }
		
        return null;
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies)
    {
        $this->tv->folder_entered($media_url, $plugin_cookies);

        $fav_channel_ids = $this->tv->get_fav_channel_ids($plugin_cookies);

        $items = array();

        foreach ($fav_channel_ids as $channel_id)
        {
            if (preg_match('/^\s*$/', $channel_id))
                continue;
			
			if ($channel_id==false)
                continue;

            $c = $this->tv->get_channel($channel_id);
			if ($c==false)
				continue;
			$color = 15;
			if (isset($this->select_id[$channel_id]))
				$color = 18;
            array_push($items,
                array
                (
                    PluginRegularFolderItem::media_url =>
                        MediaURL::encode(
                            array(
                                'channel_id' => $c->get_id(),
                                'group_id' => '__favorites')),
                    PluginRegularFolderItem::caption => $c->get_title(),
                    PluginRegularFolderItem::view_item_params => array
                    (
                        ViewItemParams::icon_path => $c->get_icon_url(),
                        ViewItemParams::item_detailed_icon_path => $c->get_icon_url(),
						ViewItemParams::item_caption_color => $color,
                    ),
                    PluginRegularFolderItem::starred => false,
                ));
        }

        return $items;
    }

    public function get_archive(MediaURL $media_url)
    {
        return $this->tv->get_archive($media_url);
    }
}

?>
