<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/abstract_preloaded_regular_screen.php';

///////////////////////////////////////////////////////////////////////////

class TvChannelListScreen extends AbstractPreloadedRegularScreen
    implements UserInputHandler
{
    const ID = 'tv_channel_list';

    public static function get_media_url_str($group_id)
    {
        return MediaURL::encode(
            array
            (
                'screen_id' => self::ID,
                'group_id'  => $group_id,
            ));
    }

    ///////////////////////////////////////////////////////////////////////

    protected $tv;
	private $select_id = false;
	private $fav_ttv_items = false;
	private $fav_ttv = false;
    ///////////////////////////////////////////////////////////////////////

    public function __construct(Tv $tv, $folder_views)
    {
        parent::__construct(self::ID, $folder_views);
        $this->tv = $tv;
        UserInputHandlerRegistry::get_instance()->register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
        $actions = array();
		$actions[GUI_EVENT_KEY_SETUP] = ActionFactory::open_folder(SmartSetupScreen::get_media_url_str(),"Настройки");
		// $add_action = UserInputHandlerRegistry::create_action($this, 'add_id');
		// $add_action['caption'] = 'Задать vsetvID';
		// $actions[GUI_EVENT_KEY_B_GREEN] = $add_action;
		$add_action = UserInputHandlerRegistry::create_action($this, 'add_logo');
		$add_action['caption'] = 'Задать иконку';
		$actions[GUI_EVENT_KEY_C_YELLOW] = $add_action;
		$actions[GUI_EVENT_KEY_SELECT] = UserInputHandlerRegistry::create_action($this, 'select');
		$actions[GUI_EVENT_KEY_CLEAR] = UserInputHandlerRegistry::create_action($this, 'hide_ch_apply');
		$add_action = UserInputHandlerRegistry::create_action($this, 'add_favorite');
		$add_action['caption'] = 'Избранное';
		$actions[GUI_EVENT_KEY_D_BLUE] = $add_action;
        $actions[GUI_EVENT_KEY_POPUP_MENU] = UserInputHandlerRegistry::create_action($this, 'popup_menu');
        $actions[GUI_EVENT_KEY_INFO] = UserInputHandlerRegistry::create_action($this, 'info');
		$actions[GUI_EVENT_KEY_SEARCH] = UserInputHandlerRegistry::create_action($this, 'search_channel');
		$actions[GUI_EVENT_KEY_ENTER] = ActionFactory::tv_play();
        $actions[GUI_EVENT_KEY_PLAY] = ActionFactory::tv_play();
        return $actions;
    }

    public function get_handler_id()
    { return self::ID; }

    private function get_sel_item_update_action(&$user_input, &$plugin_cookies)
    {
        $parent_media_url = MediaURL::decode($user_input->parent_media_url);
        $sel_ndx = $user_input->sel_ndx;
        $group = $this->tv->get_group($parent_media_url->group_id);
        $channels = $group->get_channels($plugin_cookies);
        $items[] = $this->get_regular_folder_item($group,
            $channels->get_by_ndx($sel_ndx), $plugin_cookies);
        $range = HD::create_regular_folder_range($items,
            $sel_ndx, $channels->size());
		$this->fav_ttv_items = false;
        return ActionFactory::update_regular_folder($range, false);
    }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        $attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
		$use_fav = (HD::get_item('use_fav') !='') ? HD::get_item('use_fav') : 0;
		if ($user_input->control_id == 'info')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
            $channel_id = $media_url->channel_id;
            $channels = $this->tv->get_channels();
            $c = $channels->get($channel_id);
            $id = $c->get_id();
            $title = $c->get_title();
			$defs = array();
			ControlFactory::add_label($defs,'', "ttvID: $id");
            return ActionFactory::show_dialog("Channel '$title'",$defs,true,1300,$attrs);
        }
		
		if ($user_input->control_id == 'add_channel_list_bg')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$msg = "Для применения изменений выйдите из плагина, нажмите кнопку POPUP и выберите 'Обновить'.";
			$media_url = MediaURL::encode (
                    array
                    (
                        'screen_id'     => 'file_list',
						'save_file'		=> array(	
						'parent' => self::ID,
						'action' => 'plugin_ico',
						'arg' => 'channel_list_bg',
						'msg' => $msg,
						'extension' => 'jpg'
						),
                    )
			);
			return ActionFactory::open_folder($media_url,'Folders');
		}
		
		if ($user_input->control_id == 'del_channel_list_bg')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$plugin_ico = HD::get_items('plugin_ico');
			unlink($plugin_ico['channel_list_bg']);
			unset ($plugin_ico['channel_list_bg']);
			HD::save_items('plugin_ico', $plugin_ico);
			return ActionFactory::invalidate_folders(array('vod_category_list'), 
			ActionFactory::show_title_dialog('Бекграунд удален',null,"Для применения изменений выйдите из плагина, нажмите кнопку POPUP и выберите 'Обновить'.",800,1));
		}
		
		if ($user_input->control_id == 'del_rename')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$channel_id = $media_url->channel_id;
			$user_list = array_flip (HD::get_items('vsetv_list'));
			unset($user_list[$channel_id]);
			$user_list = array_flip ($user_list);
			HD::save_items('vsetv_list', $user_list);
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
		}
		
		if ($user_input->control_id == 'rename')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$channel_id = $media_url->channel_id;
			$channels = $this->tv->get_channels();
			$c = $channels->get($channel_id);
			$title = $c->get_title();
			if (!isset($user_input->selected_media_url))
                return null;
			$defs = array();
			ControlFactory::add_text_field($defs,
				$this, $add_params=null,
				'newname', '',
				$title, 0, 0, 1, 1, 1300, 0, 1);
			ControlFactory::add_vgap($defs, 500);	
			return  ActionFactory::show_dialog("Укажите новое имя канала",$defs,true,0,$attrs);
		}
		if ($user_input->control_id == 'newname')
        {
			if ($user_input->newname == '')
				return ActionFactory::show_title_dialog("Название не может быть пустым!",null,"",800,1);
			$do = UserInputHandlerRegistry::create_action($this, 'add_newname_apply');
			return ActionFactory::close_dialog_and_run($do);
		}
		if ($user_input->control_id == 'add_newname_apply')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$channel_id = $media_url->channel_id;
			$user_list = array_flip (HD::get_items('vsetv_list'));
			$user_list[$channel_id] = $user_input->newname;
			$user_list = array_flip ($user_list);
			HD::save_items('vsetv_list', $user_list);
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
		}
		if ($user_input->control_id == 'select')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$links = $this->select_id;
			if (isset($links[$media_url->channel_id]))
				unset ($links[$media_url->channel_id]);
			else
				$links[$media_url->channel_id] = 1;
			$this->select_id = $links;
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder_plus');
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
		}
		
		if ($user_input->control_id == 'search_channel'){
			$defs = array();
			$media_url = MediaURL::decode($user_input->selected_media_url);
            $channel_id = $media_url->channel_id;
			$channels = $this->tv->get_channels();
			$c = $channels->get($channel_id);
			$title = $c->get_title();
			$use_osk = (HD::get_item('use_osk') !='') ? HD::get_item('use_osk') : 1;
			ControlFactory::add_text_field(
				$defs, $this, null,
				'do_new_search', '',
				$title, 0, 0, $use_osk, 1, 1300,0,1
			);
			if ($use_osk == 1)
				ControlFactory::add_vgap($defs, 500);
			return  ActionFactory::show_dialog('Введите название или часть названия канала для поиска', $defs,true,1300,$attrs);
		}
		
		if ($user_input->control_id == 'do_new_search')
        {
			$do_search = UserInputHandlerRegistry::create_action($this, 'run_search');
			return ActionFactory::close_dialog_and_run($do_search);
		}
		
		if ($user_input->control_id == 'run_search')
		{
			$defs = array();
			$find_text = $user_input->do_new_search;
			$playlist = SmartConfig::get_playlist();
			foreach ($playlist->categories as $tv_category)
				$categories[$tv_category->id]=$tv_category->name;
			$hide_ch_defs = HD::get_items('hide_ch');
			$channels_name = array_flip (
			HD::get_items('vsetv_list'));
			$i = 0;
			$q = false;
			foreach ($playlist->channels as $tv_channel){
				$h = false;
				$caption = isset($channels_name[$tv_channel->id]) ? $channels_name[$tv_channel->id] : $tv_channel->name;
				$s = mb_stripos($caption, $find_text, 0, "UTF-8");
				if (array_key_exists($tv_channel->id, $hide_ch_defs)){
					$caption = $caption . '(hide)';
					$h = true;
				}
				if ($s !== false){
					$q = true;
					$group_name = $categories[strval($tv_channel->group)];
					$add_params['number'] = intval($i);
					ControlFactory::add_close_dialog_and_apply_button_title(&$defs, $this, $add_params, 'jump', strval($group_name), strval($caption), 900, false);
				}
				if ($h == false)
					$i++;
			}
			if ($q == false){
				ControlFactory::add_multiline_label(&$defs, '', "Ничего не найдено. Попробуйте изменить шаблон поиска.",6);
				ControlFactory::add_vgap($defs, 20);
				ControlFactory::add_close_dialog_and_apply_button_title($defs, $this, null, 'search_channel', '', 'Новый поиск', 300, true);
			}
			return  ActionFactory::show_dialog('Результат поиска', $defs, true, 0, $attrs);
		}
		
		if ($user_input->control_id == 'jump')
		{
			$ndx = $user_input->number;
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$range = $this->get_folder_range($parent_media_url, 0, $plugin_cookies);
			return ActionFactory::update_regular_folder($range, true, $ndx);
		}
		
        if ($user_input->control_id == 'popup_menu')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$group_id = $media_url->group_id;
            $channel_id = $media_url->channel_id;
			
			$channels = $this->tv->get_channels();
			$c = $channels->get($channel_id);
			$title = $c->get_title();
			if ($use_fav == 0)
				$is_favorite = $this->tv->is_favorite_channel_id($channel_id, $plugin_cookies);
			else
				$is_favorite = $this->is_favorite_id($channel_id);
			if ($is_favorite)
				$caption = 'Удалить из Избранного';
			else
				$caption = 'Добавить в Избранное';
				$action = UserInputHandlerRegistry::create_action($this, 'add_favorite');
            $menu_items[] = array(
                GuiMenuItemDef::caption => $caption,
                GuiMenuItemDef::action => $action,
				GuiMenuItemDef::icon_url => 'gui_skin://small_icons/favorites.aai');
			$a = SmartConfig::arc_list();
			if (isset($a[$channel_id])){
				$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
				$caption = 'Архив';
				$action = ActionFactory::open_folder(VodSeriesListScreen::get_media_url_str($a[$channel_id], false, $title, '', ''),"Архив - $title");
				$menu_items[] = array(
					GuiMenuItemDef::caption => $caption,
					GuiMenuItemDef::action => $action,
					GuiMenuItemDef::icon_url => 'plugin_file://icons/arc_ico.png');
			}
			if ($group_id == '__all_channels'){
				$menu_items [] =  array(
					GuiMenuItemDef::is_separator => true,);
				$caption = 'Поиск канала';
				$action = UserInputHandlerRegistry::create_action($this, 'search_channel');
				$menu_items[] = array(
					GuiMenuItemDef::caption => $caption,
					GuiMenuItemDef::action => $action,
					GuiMenuItemDef::icon_url => 'plugin_file://icons/search.png');
			}
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
			$caption = 'Информация (INFO)';
			$action = UserInputHandlerRegistry::create_action($this, 'info');
            $menu_items[] = array(
                GuiMenuItemDef::caption => $caption,
                GuiMenuItemDef::action => $action,
				GuiMenuItemDef::icon_url => 'gui_skin://small_icons/info.aai');
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
			$parental_defs = HD::get_items('parental');
			$is_protected = (array_key_exists($channel_id, $parental_defs)) ? 1 : 0;
			if ($is_protected == 1){
				$caption = 'Открыть канал';
				$action = UserInputHandlerRegistry::create_action($this, 'del_parental');
			}else{
				$caption = 'Закрыть канал';
				$action = UserInputHandlerRegistry::create_action($this, 'add_parental');
			}
            $menu_items[] = array(
                GuiMenuItemDef::caption => $caption,
                GuiMenuItemDef::action => $action,
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/kartina_tv_lock.png'
				);
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
			$caption = 'Скрыть канал (CLEAR)';
			$action = UserInputHandlerRegistry::create_action($this, 'hide_ch');
            $menu_items[] = array(
                GuiMenuItemDef::caption => $caption,
                GuiMenuItemDef::action => $action,
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
				);
			$caption = 'Список скрытых каналов';
			$action = UserInputHandlerRegistry::create_action($this, 'hide_list');
            $menu_items[] = array(
                GuiMenuItemDef::caption => $caption,
                GuiMenuItemDef::action => $action,
				GuiMenuItemDef::icon_url => 'gui_skin://small_icons/unknown_file.aai'
				);
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
				
            $menu_items[] = array(
                GuiMenuItemDef::caption => 'Выделить (SELECT)',
                GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'select'),
				GuiMenuItemDef::icon_url => 'gui_skin://button_icons/restart.aai'
				);
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
			$menu_items[] = array(
                GuiMenuItemDef::caption => 'Обновить список каналов',
                GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'cleer_folder_key'),
				GuiMenuItemDef::icon_url => 'gui_skin://small_icons/service_file.aai'
				);
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
			$my_channels_id = array_flip (HD::get_items('my_channels_id'));
			if (isset($my_channels_id[$channel_id]))
				$menu_items[] = array(
                GuiMenuItemDef::caption => 'Удалить ID',
                GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'del_id'),
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
				);
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
			$menu_items[] = array(
                GuiMenuItemDef::caption => 'Переименовать',
                GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'rename'),
				GuiMenuItemDef::icon_url => 'gui_skin://small_icons/language_settings.aai'
				);
			$channels = array_flip (HD::get_items('vsetv_list'));
			if (isset($channels[$channel_id]))
				$menu_items[] = array(
                GuiMenuItemDef::caption => 'Удалить переименование',
                GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'del_rename'),
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
				);
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
			$menu_items[] = array(
                GuiMenuItemDef::caption => 'Задать иконку',
                GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'add_logo'),
				GuiMenuItemDef::icon_url => 'gui_skin://small_icons/photo_viewer.aai'
				);
			if (file_exists(SmartConfig::get_data_path() . "/logo/$channel_id.png"))
			$menu_items[] = array(
                GuiMenuItemDef::caption => 'Удалить иконку',
                GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'del_logo'),
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
				);
			
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
				
			$menu_items[] = array(
            GuiMenuItemDef::caption => 'Задать бекграунд',
            GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'add_channel_list_bg'),
			GuiMenuItemDef::icon_url => 'gui_skin://small_icons/photo_viewer.aai'
			);
			$plugin_ico = HD::get_items('plugin_ico');
			if (isset($plugin_ico['channel_list_bg'])){
				$menu_items[] = array(
				GuiMenuItemDef::caption => 'Удалить бекграунд',
				GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'del_channel_list_bg'),
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
				);
			}
            return ActionFactory::show_popup_menu($menu_items);
        }
		
		if ($user_input->control_id == 'del_id')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$defs = array();
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$id = $media_url->channel_id;
			$my_channels_id = HD::get_items('my_channels_id');
			foreach ($this->tv->global_channels[$id]['caption'] as $k => $v){
				$id_key = HD::get_id_key($v);
				$add_params['id_key']= $id_key;
				if (isset($my_channels_id[$id_key]))
					ControlFactory::add_button_close ($defs, $this, $add_params,'del_id_applay',  $v, 'Удалить', 0);
			}
            return ActionFactory::show_dialog('Удалить id для этого имени канала:', $defs, true, 0, $attrs);
		}
		
		if ($user_input->control_id == 'del_id_applay')
        {
            if (!isset($user_input->selected_media_url))
				return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$channel_id = $media_url->channel_id;
			$my_channels_id = HD::get_items('my_channels_id');
			unset ($my_channels_id[$user_input->id_key]);
			HD::save_items('my_channels_id', $my_channels_id);
			$id = $user_input->id_key;
			$channels_id_parsed = array_merge(
			HD::get_items('vsetv_channels_id'), 
			$my_channels_id
			);
			foreach ($this->tv->global_channels[$channel_id]['caption'] as $k => $v){
				if (HD::get_id_key($v)==$id){
					if (preg_match("|[a-zA-Z]|", $id))
						$id = array_key_exists($id,$channels_id_parsed) ? $channels_id_parsed[$id] : $id;
					$this->tv->global_channels[$id]['caption'][$k] = $this->tv->global_channels[$channel_id]['caption'][$k];
					$this->tv->global_channels[$id]['urls'][$k] = $this->tv->global_channels[$channel_id]['urls'][$k];
					unset ($this->tv->global_channels[$channel_id]['caption'][$k]);
					unset ($this->tv->global_channels[$channel_id]['urls'][$k]);
				}
			}
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
        }
		
		if ($user_input->control_id == 'del_logo')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$channel_id = $media_url->channel_id;
            if (file_exists(SmartConfig::get_data_path() . "/logo/$channel_id.png"))
				unlink(SmartConfig::get_data_path() . "/logo/$channel_id.png");
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
        }
		
		if ($user_input->control_id == 'add_logo')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
            $media_url = MediaURL::encode (
								array
								(
									'screen_id'     => 'file_list',
									'save_file'		=> array(
									'parent' 		=> 'tv_group_list',
									'action' 		=> 'ch_ico',
									'arg'			=> $media_url->channel_id,
									'gid'			=> $media_url->group_id,
									'sid'			=> self::ID,
									'extension'		=> 'png'
									),
								)
						);
			return ActionFactory::open_folder($media_url,'Folders');
        }
		
		if ($user_input->control_id === 'cleer_folder_key')
		{
			if (!isset($user_input->parent_media_url))
				return null;
			$this->tv->global_channels = null;
			$this->select_id = false;
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
		}
				
		if ($user_input->control_id == 'hide_list')
		{
			if (!isset($user_input->selected_media_url))
				return null;
				$hide_ch_defs = HD::get_items('hide_ch');
				if (count($hide_ch_defs) == 0)
					return ActionFactory::show_title_dialog("Скрытых каналов нет",null,"",800,1);
				$i=1;
				$cleer_hide_all = UserInputHandlerRegistry::create_action($this, 'cleer_hide_all');
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs, '_del', 'Востановить все', 350,  $cleer_hide_all);
				ControlFactory::add_vgap($defs, -25);
				ControlFactory::add_label($defs,'                                           ',' ');
				ControlFactory::add_vgap($defs, -25);
				foreach($hide_ch_defs as $key => $value){
					$add_params ['ch_pl'] = $key;
					ControlFactory::add_button_close ($defs, $this, $add_params,'cleer_hide', "$i. $value", 'Востановить', 0);
					$i++;
				}
				$attrs['max_height'] = 740;
				return ActionFactory::show_dialog("Скрытые каналы", $defs, true,0,$attrs);
		}
		
		if ($user_input->control_id == 'cleer_hide_all')
		{
			if (!isset($user_input->selected_media_url))
                return null;
			HD::save_items('hide_ch', array());
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
		}
		
		if ($user_input->control_id == 'cleer_hide')
		{
			if (!isset($user_input->selected_media_url))
                return null;
			if (isset($user_input->ch_pl))
				$ch_pl = $user_input->ch_pl;
			$hide_ch_defs = HD::get_items('hide_ch');
			unset ($hide_ch_defs [$ch_pl]);
			HD::save_items('hide_ch', $hide_ch_defs);
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
		}
		
		if ($user_input->control_id == 'hide_ch')
		{
			if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$channel_id = $media_url->channel_id;
            $channels = $this->tv->get_channels();
            $c = $channels->get($channel_id);
            $title = $c->get_title();
			ControlFactory::add_label($defs, "Внимание:", "востановить канал можно через Список скрытых каналов.");
			ControlFactory::add_label($defs, "Внимание:", "скрывать каналы так же можно нажатием кнопки CLEAR.");
			$do_hide_ch_apply = UserInputHandlerRegistry::create_action($this, 'hide_ch_apply');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,	'_hide_ch_apply', 'Да', 250, $do_hide_ch_apply);
			ControlFactory::add_close_dialog_button($defs,'Нет', 250);
			return  ActionFactory::show_dialog("Скрыть канал: $title ?", $defs,	true,0,$attrs);
		}
		
		if ($user_input->control_id == 'hide_ch_apply')
		{
			if (!isset($user_input->selected_media_url))
                return null;
            if ($this->select_id==true)
				 $channel_ids = $this->select_id;
			else{
				$media_url = MediaURL::decode($user_input->selected_media_url);
				$channel_ids[$media_url->channel_id] = $media_url->channel_id;
			}
			$channels = $this->tv->get_channels();
			foreach ($channel_ids as $channel_id => $v){
				$c = $channels->get($channel_id);
				$title = $c->get_title();
				$hide_ch_defs = HD::get_items('hide_ch');
				$is_hide = (array_key_exists($channel_id, $hide_ch_defs)) ? 1 : 0;
				if ($is_hide == 1)
					return ActionFactory::show_title_dialog("Что-то тут не так. Канал $title уже скрыт!",null,"",800,1);
				$hide_ch_defs [$channel_id] = $title;
				HD::save_items('hide_ch', $hide_ch_defs);
			}
			$this->select_id = false;
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
		}
		
		if ($user_input->control_id == 'add_parental')
		{
			if (!isset($user_input->selected_media_url))
				return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$channel_id = $media_url->channel_id;
			$channels = $this->tv->get_channels();
			$c = $channels->get($channel_id);
			$title = $c->get_title();
			$defs = array();
			ControlFactory::add_label($defs, "", "Вы уверены что хотите закрыть канал");
			ControlFactory::add_label($defs, "", "$title Родительским контролем ?");
			ControlFactory::add_label($defs, "", "Внимание: открыть канал можно через");
			ControlFactory::add_label($defs, "", "Открыть канал (Parental)");
			$do_add_parental_apply = UserInputHandlerRegistry::create_action($this, 'add_parental_apply');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs, '_add_parental_apply', 'Да', 250, $do_add_parental_apply);
			ControlFactory::add_close_dialog_button($defs, 'Нет', 250);
			return  ActionFactory::show_dialog ("Закрыть канал: $title (Parental Control)?", $defs, true,0,$attrs);
		}
		
		if ($user_input->control_id == 'add_parental_apply')
		{
			if (!isset($user_input->selected_media_url))
				return null;
			if ($this->select_id==true)
				 $channel_ids = $this->select_id;
			else{
				$media_url = MediaURL::decode($user_input->selected_media_url);
				$channel_ids[$media_url->channel_id] = $media_url->channel_id;
			}
			$channels = $this->tv->get_channels();
			foreach ($channel_ids as $channel_id => $v){
				$c = $channels->get($channel_id);
				$title = $c->get_title();
				$parental_defs = HD::get_items('parental');
				$is_protected = (array_key_exists($channel_id, $parental_defs)) ? 1 : 0;
				if ($is_protected == 1)
					return ActionFactory::show_title_dialog("Канал $title уже защищен!!!",null,"",800,1);
				$parental_defs [$channel_id] = 1;	
				HD::save_items('parental', $parental_defs);
			}
			$this->select_id = false;
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
		}
		
		if ($user_input->control_id == 'del_parental')
		{
			if (!isset($user_input->selected_media_url))
				return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$channel_id = $media_url->channel_id;
			$channels = $this->tv->get_channels();
			$c = $channels->get($channel_id);
			$title = $c->get_title();
			$parental_defs = HD::get_items('parental');
			$is_protected = (array_key_exists($channel_id, $parental_defs)) ? 1 : 0;
			if ($is_protected == 0)
				return ActionFactory::show_title_dialog("Канал $title не защищен!!!",null,"",800,1);
			$defs = array();
			ControlFactory::add_text_field($defs,0,0,
				'pin', 'Код закрытых каналов:',
				'', 1, 1, 0, 1, 500, 0, false);
			$do_kill_parent_apply = UserInputHandlerRegistry::create_action($this, 'del_parent_apply');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs, '_kill_parent_apply', 'ОК', 250, $do_kill_parent_apply);
			ControlFactory::add_close_dialog_button($defs, 'Отмена', 250);
			return  ActionFactory::show_dialog(	"Открыть канал (Parental) - $title",$defs,true,0,$attrs);
		}
		
		if ($user_input->control_id == 'del_parent_apply')
		{
			$pin = isset($plugin_cookies->pin) ? $plugin_cookies->pin : '0000';
			if ($user_input->pin !== $pin)
				return ActionFactory::show_title_dialog("Код не правильный!!!",null,"",800,1);
			if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
            $channel_id = $media_url->channel_id;
            $channels = $this->tv->get_channels();
            $c = $channels->get($channel_id);
            $title = $c->get_title();
			$parental_defs = HD::get_items('parental');
			unset ($parental_defs [$channel_id]);
			HD::save_items('parental', $parental_defs);
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
		}
		
        if ($user_input->control_id == 'add_favorite')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			if ($this->select_id==true)
				 $channel_ids = $this->select_id;
			else{
				$media_url = MediaURL::decode($user_input->selected_media_url);
				$channel_ids[$media_url->channel_id] = $media_url->channel_id;
			}
			foreach ($channel_ids as $channel_id => $v){
				if ($use_fav == 0)
					$is_favorite = $this->tv->is_favorite_channel_id($channel_id, $plugin_cookies);
				else
					$is_favorite = $this->is_favorite_id($channel_id);
				if ($is_favorite){
					$this->tv->change_tv_favorites(PLUGIN_FAVORITES_OP_REMOVE,
						$channel_id, $plugin_cookies);
					$msg = 'Удалено из Избранного!';
				}else{
					$this->tv->change_tv_favorites(PLUGIN_FAVORITES_OP_ADD,
						$channel_id, $plugin_cookies);
					$msg = 'Добавленно в Избранное!';
				}

			}
			$this->select_id = false;
			$this->fav_ttv_items = false;
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::show_title_dialog($msg,
			ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action),'',800,1);
        }
						
		if ($user_input->control_id === 'cleer_folder')
		{
			if (!isset($user_input->parent_media_url))
				return null;
			$this->select_id = false;
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$sel_ndx = $user_input->sel_ndx;
				if ($sel_ndx < 0)
					$sel_ndx = 0;
			$range = $this->get_folder_range($parent_media_url, 0, $plugin_cookies);
			return ActionFactory::update_regular_folder($range, true, $sel_ndx);
		}
		if ($user_input->control_id === 'cleer_folder_plus')
		{
			if (!isset($user_input->parent_media_url))
				return null;
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$sel_ndx = $user_input->sel_ndx+1;
				if ($sel_ndx < 0)
					$sel_ndx = 0;
			$range = $this->get_folder_range($parent_media_url, 0, $plugin_cookies);
			return ActionFactory::update_regular_folder($range, true, $sel_ndx);
		}
        return null;
    }
	private function is_favorite_id($id)
    {
		if ($this->fav_ttv_items == false){
			$this->fav_ttv = SmartConfig::get_ttv_fav();
			$this->fav_ttv_items = true;
		}
		$k = array_search($id, $this->fav_ttv);
		return $k !== false;
	}
    ///////////////////////////////////////////////////////////////////////

    private function get_regular_folder_item($group, $c, &$plugin_cookies)
    {
		$color = 15;
		if (isset($this->select_id[$c->get_id()]))
			$color = 18;
		$use_fav = (HD::get_item('use_fav') !='') ? HD::get_item('use_fav') : 0;
		if ($use_fav == 0)
			$starred = $this->tv->is_favorite_channel_id($c->get_id(), $plugin_cookies);
		else
			$starred = $this->is_favorite_id($c->get_id());
        return array
        (
            PluginRegularFolderItem::media_url =>
                MediaURL::encode(
                    array(
                        'channel_id' => $c->get_id(),
                        'group_id' => $group->get_id())),
            PluginRegularFolderItem::caption => $c->get_title(),
            PluginRegularFolderItem::view_item_params => array
            (
                ViewItemParams::icon_path => $c->get_icon_url(),
                ViewItemParams::item_detailed_icon_path => $c->get_icon_url(),
				ViewItemParams::item_caption_color => $color,
            ),
            PluginRegularFolderItem::starred => $starred,
        );
    }

    public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies)
    {
        $this->tv->folder_entered($media_url, $plugin_cookies);

        //$this->tv->ensure_channels_loaded($plugin_cookies);

        $group = $this->tv->get_group($media_url->group_id);

        $items = array();

        foreach ($group->get_channels($plugin_cookies) as $c)
        {
            $items[] = $this->get_regular_folder_item(
                $group, $c, $plugin_cookies);
        }
		$this->fav_ttv_items = false;
        return $items;
    }

    public function get_archive(MediaURL $media_url)
    {
        return $this->tv->get_archive($media_url);
    }
}

///////////////////////////////////////////////////////////////////////////
?>
