<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/vod/vod_list_screen.php';

class SmartVodListScreen extends VodListScreen
{
    static public $total;
	public static function get_media_url_str($cat_id, $genre_id=false, $name=false)
    {
        $arr['screen_id'] = self::ID;
        $arr['category_id'] = $cat_id;
		if ($genre_id == true)
			$arr['genre_id'] = $genre_id;
		if ($name == true)
			$arr['name'] = $name;
        return MediaURL::encode($arr);
    }

    ///////////////////////////////////////////////////////////////////////

    public function __construct(Vod $vod)
    {
        parent::__construct($vod);
    }

    ///////////////////////////////////////////////////////////////////////

    protected function get_short_movie_range(MediaURL $media_url, $from_ndx,
        &$plugin_cookies)
    {
		if($media_url->category_id == 'search') {
            $movies = SmartConfig::getSearchList(urlencode($media_url->genre_id), $media_url->name, $this->vod->m_feed);
            if(!count($movies))
                return new ShortMovieRange(0, 0);
        }elseif($media_url->category_id == 'ch_arc') {
            $movies = SmartConfig::getChArcList();
            if(!count($movies))
                return new ShortMovieRange(0, 0);
        }else{
            $movies = SmartConfig::getVideoList($media_url->category_id, $media_url->genre_id, $this->vod->m_feed);
            if(!count($movies))
                return new ShortMovieRange(0, 0);
        }
        self::$total += count($movies);
        return new ShortMovieRange($from_ndx, self::$total, $movies);
    }

    public function get_folder_range(MediaURL $media_url, $from_ndx, &$plugin_cookies)
    {
		$movie_range = $this->get_short_movie_range($media_url, $from_ndx, $plugin_cookies);
        $total = intval($movie_range->total);
        if ($total <= 0)
            return HD::create_regular_folder_range(array());
		if ($movie_range->from_ndx > 0 && $total == 0)
        {
            return  HD::create_regular_folder_range
                (
                    $items,
                    $movie_range->from_ndx > 0 ? $movie_range->from_ndx - 1 : 0,
                    $movie_range->from_ndx ,
                    false
                );
        }
        $items = array();
		$save_folder = HD::get_items('save_folder');

        foreach ($movie_range->short_movies as $movie)
        {
			$color = 15; $info = $new = ''; $starred = false;
			if ((isset ($save_folder[$movie->id]))&&(($save_folder[$movie->id][key($save_folder[$movie->id])]) != 'not_check')){
				$season_items = SmartConfig::parse_season_items($movie->id, key($save_folder[$movie->id]));
				$save_items =  array_flip($save_folder[$movie->id][key($save_folder[$movie->id])]);
				foreach ($season_items as $k => $v){
					if (!isset($save_items[$v])){
						$info .= '||NEW:|'.$k;
						$new = '[NEW] ';$starred = true;
						$color = 18;
					}
				}
			}
			if ($media_url->category_id == 'ch_arc')
				$mUrl = VodSeriesListScreen::get_media_url_str($movie->id, false, $movie->name, $movie->poster_url, $movie->info);
			else
				$mUrl = VodMovieScreen::get_media_url_str($movie->id, $movie->name, $movie->poster_url, $movie->info, $movie->kp_id );
			$items[] = array
            (
                PluginRegularFolderItem::media_url => $mUrl,
                PluginRegularFolderItem::caption => $new  .  $movie->name,
				PluginRegularFolderItem::starred => $starred,
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $movie->poster_url,
					ViewItemParams::item_detailed_info => $movie->info . $info
                )
            );

            $this->vod->set_cached_short_movie(
                new ShortMovie($movie->id, $movie->name, $movie->poster_url, $movie->info, $movie->kp_id));
        }
        return HD::create_regular_folder_range(
            $items, $movie_range->from_ndx, $total, true);
    }    
    
    public function get_folder_view(MediaURL $media_url, &$plugin_cookies)
    {
        $this->clear_video_cache();
        $this->vod->m_feed = 0;
        $this->vod->folder_entered($media_url, $plugin_cookies);
        return parent::get_folder_view($media_url, $plugin_cookies);
    }
    
    private function clear_video_cache() {
        self::$total = 0;
        $this->vod->clear_movie_cache();
    }
    
}

///////////////////////////////////////////////////////////////////////////
?>
