<?php
///////////////////////////////////////////////////////////////////////////

require_once 'Smart_vod_category.php';
require_once 'Smart_vod_list_screen.php';

///////////////////////////////////////////////////////////////////////////

class SmartVodCategoryListScreen extends AbstractPreloadedRegularScreen
implements UserInputHandler
{
    const ID = 'vod_category_list';

    public static function get_media_url_str($category_id, $subcategory_id=false,$name=false)
    {
		$arr['screen_id'] = self::ID;
        $arr['category_id'] = $category_id;
        if ($subcategory_id == true)
			$arr['subcategory_id'] = $subcategory_id;
		if ($name == true)
			$arr['name'] = $name;
        return MediaURL::encode($arr);
    }

    ///////////////////////////////////////////////////////////////////////

    private $category_list;
    private $category_index;

    ///////////////////////////////////////////////////////////////////////

    public function __construct(Vod $vod)
    {
        parent::__construct(
            self::ID, $this->get_folder_views());
		$this->vod = $vod;
		 UserInputHandlerRegistry::get_instance()->
            register_handler($this);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
        $actions = array();
		$add_action = UserInputHandlerRegistry::create_action($this, 'setup');
        $add_action['caption'] = 'Настройки';
        $actions[GUI_EVENT_KEY_C_YELLOW] = $add_action;
		$actions[GUI_EVENT_KEY_SETUP] = $add_action;
		$add_action = UserInputHandlerRegistry::create_action($this, 'categories');
        $add_action['caption'] = 'Добавить в главное меню';
		$actions[GUI_EVENT_KEY_B_GREEN] = $add_action;
		$add_action = UserInputHandlerRegistry::create_action($this, 'add_favorite');
        $add_action['caption'] = 'В Избранное';
        $actions[GUI_EVENT_KEY_D_BLUE] = $add_action;
		$actions[GUI_EVENT_KEY_CLEAR] = UserInputHandlerRegistry::create_action($this, 'hide_id_apply');
		$actions[GUI_EVENT_KEY_ENTER] = UserInputHandlerRegistry::create_action($this, 'add_actions');
		$actions[GUI_EVENT_KEY_PLAY] = UserInputHandlerRegistry::create_action($this, 'add_actions');
		$popup_menu_action = UserInputHandlerRegistry::create_action($this, 'popup_menu');
		$actions[GUI_EVENT_KEY_POPUP_MENU] = $popup_menu_action;
        return  $actions;
    }
	
	public function get_handler_id()
    { return self::ID; }
	
    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
        $pin = isset($plugin_cookies->pin) ? $plugin_cookies->pin : '0000';
		$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
		if ($user_input->control_id == 'setup')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			return ActionFactory::open_folder('setup', "Настройки");
        }
		
		if ($user_input->control_id == 'add_favorite')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$this->vod->ensure_favorites_loaded($plugin_cookies);
			$is_favorite = $this->vod->is_favorite_movie_id($user_input->selected_media_url);
			$ufav_itms = HD::get_items('ufav_itms');
			if (!empty($ufav_itms)){
				if ($is_favorite)
					$caption = 'Удалить из Избранного';
				else
					$caption = 'Добавить в Избранное';
				$add_favorite_action = UserInputHandlerRegistry::create_action($this, 'add_fav');
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_works', $caption, 600, $add_favorite_action);
				foreach ($ufav_itms as $k => $v){
					$caption = "Добавить в: $v";
					$params['ufav_itms_name'] = $k;
					$add_favorite_action = UserInputHandlerRegistry::create_action($this, 'add_fav_itm',$params);
					ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'_other_works', $caption, 600, $add_favorite_action);
				}
				return ActionFactory::show_dialog('Избранное', $defs, true, 0,$attrs);
			}else{
				if ($is_favorite){
					$media_url = MediaURL::decode($user_input->selected_media_url);
					$save_folder = HD::get_items('save_folder');
					if (isset($save_folder[$media_url->movie_id])){
						unset ($save_folder[$media_url->movie_id]);
						$movie->series_list = null;
						HD::save_items('save_folder', $save_folder);
					}
					$this->vod->remove_favorite_movie($user_input->selected_media_url, $plugin_cookies);
					return ActionFactory::show_title_dialog_gl('Удалено из Избранного');
				}
				else{
					$this->vod->add_favorite_movie($user_input->selected_media_url, $plugin_cookies);
					return ActionFactory::show_title_dialog_gl('Добавленно в Избранное');
				}
			}
			
        }
		if ($user_input->control_id == 'add_fav_itm')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$fav_movies = HD::get_items($user_input->ufav_itms_name);
			$flipped = array_flip($fav_movies);
			if (isset($flipped[$user_input->selected_media_url])){
				unset ($flipped[$user_input->selected_media_url]);
				$fav_movies = array_flip($flipped);
				$fav_movies = array_values($fav_movies);
				HD::save_items($user_input->ufav_itms_name, $fav_movies);
				$media_url = MediaURL::decode($user_input->selected_media_url);
				$save_folder = HD::get_items('save_folder');
				if (isset($save_folder[$media_url->movie_id])){
					unset ($save_folder[$media_url->movie_id]);
					$movie->series_list = null;
					HD::save_items('save_folder', $save_folder);
				}
				return ActionFactory::show_title_dialog_gl('Удалено из Избранного');
			}else
				array_unshift($fav_movies,$user_input->selected_media_url);
				//$fav_movies[] = $user_input->selected_media_url;
			HD::save_items($user_input->ufav_itms_name, $fav_movies);
			return ActionFactory::show_title_dialog_gl('Добавленно в Избранное');
        }
		if ($user_input->control_id == 'add_fav')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$this->vod->ensure_favorites_loaded($plugin_cookies);
            $is_favorite = $this->vod->is_favorite_movie_id($user_input->selected_media_url);
            if ($is_favorite){
				$media_url = MediaURL::decode($user_input->selected_media_url);
				$save_folder = HD::get_items('save_folder');
				if (isset($save_folder[$media_url->movie_id])){
					unset ($save_folder[$media_url->movie_id]);
					$movie->series_list = null;
					HD::save_items('save_folder', $save_folder);
				}
				$this->vod->remove_favorite_movie($user_input->selected_media_url, $plugin_cookies);
                return ActionFactory::show_title_dialog_gl('Удалено из Избранного');
			}
            else{
                $this->vod->add_favorite_movie($user_input->selected_media_url, $plugin_cookies);
                return ActionFactory::show_title_dialog_gl('Добавленно в Избранное');
            }
        }
		if ($user_input->control_id == 'up_portal')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			if (isset($media_url->subcategory_id))
				$id = $media_url->subcategory_id;
			else if (isset($media_url->category_id))
				$id = $media_url->category_id;
			else if (isset($media_url->action))
				$id = $media_url->action;
			$group_list = HD::get_items('group_list');
			if (isset($group_list[$id]))
				unset ($group_list[$id]);
			$group_list = array_flip($group_list);
			array_unshift($group_list, $id);
			$group_list = array_flip($group_list);
			HD::save_items('group_list', $group_list);
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('vod_category_list'), $perform_new_action);
		}
		
		if ($user_input->control_id == 'reset_portal')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$group_list = HD::get_items('group_list');
			$group_list = array();
			HD::save_items('group_list', $group_list);
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('vod_category_list'), $perform_new_action);
		}
		
		if ($user_input->control_id === 'cleer_folder')
		{
			if (!isset($user_input->parent_media_url))
				return null;
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$sel_ndx = $user_input->sel_ndx;
				if (($sel_ndx < 0)||(isset($user_input->categories_actions)))
					$sel_ndx = 0;
			$range = $this->get_folder_range($parent_media_url, 0, $plugin_cookies);
			return ActionFactory::update_regular_folder($range, true, $sel_ndx);
		}
		
		if ($user_input->control_id == 'add_plugin_img')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			if (isset($media_url->subcategory_id))
				$id = $media_url->subcategory_id;
			else if (isset($media_url->category_id))
				$id = $media_url->category_id;
			else if (isset($media_url->action))
				$id = $media_url->action;
			$media_url = MediaURL::encode (
                    array
                    (
                        'screen_id'     => 'file_list',
						'save_file'		=> array(	
						'parent' => self::ID,
						'action' => 'plugin_ico',
						'arg' => $id,
						'extension' => 'png'
						),
                    )
			);
			return ActionFactory::open_folder($media_url,'Folders');
		}
		
		if ($user_input->control_id == 'add_category_bg')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$msg = "Для применения изменений выйдите из плагина, нажмите кнопку POPUP и выберите 'Обновить'.";
			$media_url = MediaURL::encode (
                    array
                    (
                        'screen_id'     => 'file_list',
						'save_file'		=> array(	
						'parent' => self::ID,
						'action' => 'plugin_ico',
						'arg' => 'category_bg',
						'msg' => $msg,
						'extension' => 'jpg'
						),
                    )
			);
			return ActionFactory::open_folder($media_url,'Folders');
		}
		
		if ($user_input->control_id == 'del_plugin_img')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			if (isset($media_url->subcategory_id))
				$id = $media_url->subcategory_id;
			else if (isset($media_url->category_id))
				$id = $media_url->category_id;
			else if (isset($media_url->action))
				$id = $media_url->action;
			$plugin_ico = HD::get_items('plugin_ico');
			if (isset($plugin_ico[$id])){
				$mci = $plugin_ico[$id];
				unset ($plugin_ico[$id]);
				HD::save_items('plugin_ico', $plugin_ico);
				unlink($mci);
			}
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('vod_category_list'), $perform_new_action);
		}
		
		if ($user_input->control_id == 'del_category_bg')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$plugin_ico = HD::get_items('plugin_ico');
			unlink($plugin_ico['category_bg']);
			unset ($plugin_ico['category_bg']);
			HD::save_items('plugin_ico', $plugin_ico);
			return ActionFactory::invalidate_folders(array('vod_category_list'), 
			ActionFactory::show_title_dialog('Бекграунд удален',null,"Для применения изменений выйдите из плагина, нажмите кнопку POPUP и выберите 'Обновить'.",800,1));
		}
		
		if ($user_input->control_id == 'hide_id')
		{
			if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			$title = $media_url->name;
			ControlFactory::add_label($defs, "Внимание:", "востановить категорию можно через Список скрытых итемов.");
			ControlFactory::add_label($defs, "Внимание:", "скрывать категории так же можно нажатием кнопки CLEAR.");
			$do_hide_id_apply = UserInputHandlerRegistry::create_action($this, 'hide_id_apply');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,	'_hide_id_apply', 'Да', 250, $do_hide_id_apply);
			ControlFactory::add_close_dialog_button($defs,'Нет', 250);
			return  ActionFactory::show_dialog("Скрыть категорию $title?", $defs,	true, 0,$attrs);
		}
		
		if ($user_input->control_id == 'categories')
		{
			if (!isset($user_input->selected_media_url))
                return null;
			$mmm = $user_input->selected_media_url;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			if (isset($media_url->name))
				$name = $media_url->name;
			else if (isset($media_url->second_arg))
				$name = $media_url->second_arg;
			$main_menu_manually = HD::get_items('main_menu_manually');
			$main_menu_manually[$mmm] = $name;
			HD::save_items('main_menu_manually', $main_menu_manually);
			$perform_new_action = ActionFactory::show_title_dialog_gl("$name добавлено в главное меню!");
			return ActionFactory::invalidate_folders(array('main_menu'), $perform_new_action);
		}
		
		if ($user_input->control_id == 'hide_id_apply')
		{
			if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			if (isset($media_url->subcategory_id))
				$id = $media_url->subcategory_id;
			else if (isset($media_url->category_id))
				$id = $media_url->category_id;
			else if (isset($media_url->action))
				$id = $media_url->action;
			$hide_id_defs = HD::get_items('hide_id');
			$is_hide = (array_key_exists($id, $hide_id_defs)) ? 1 : 0;
			if ($is_hide == 1)
				return ActionFactory::show_title_dialog_gl("Что-то тут не так. Категория уже скрыта!");
			$hide_id_defs [$id] = $media_url->name;
			HD::save_items('hide_id', $hide_id_defs);
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('vod_category_list'), $perform_new_action);
		}
		
		if ($user_input->control_id === 'hide_pin_control'){
			if ($user_input->hide_pin_control == $pin){
				$params['unlock'] = true;
				$do_actions = UserInputHandlerRegistry::create_action($this, 'hide_list', $params);
				return ActionFactory::close_dialog_and_run($do_actions);
			}
			else
				return  ActionFactory::show_title_dialog_gl('Код не верный!');
		}
		
		if ($user_input->control_id == 'hide_list')
		{
			if (!isset($user_input->selected_media_url))
				return null;
			if (($pin != '1111')&&(!isset($user_input->unlock))){
					$defs = array();
					ControlFactory::add_text_field($defs, $this, $add_params=null,
						'hide_pin_control', '',
						'', 1, 1, 0, 1, 500, 0, true);
					return  ActionFactory::show_dialog('Введите код:',$defs,true, 0,$attrs);
				
			}
			$hide_id_defs = HD::get_items('hide_id');
			if (count($hide_id_defs) == 0)
				return ActionFactory::show_title_dialog_gl("Скрытых итемов нет");
			$i=1;
			$cleer_hide_all = UserInputHandlerRegistry::create_action($this, 'cleer_hide_all');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs, '_del', 'Востановить все', 350,  $cleer_hide_all);
			ControlFactory::add_vgap($defs, -25);
			ControlFactory::add_label($defs,'                                           ',' ');
			ControlFactory::add_vgap($defs, -25);
			foreach($hide_id_defs as $key => $value){
				$add_params ['ch_pl'] = $key;
				ControlFactory::add_button_close ($defs, $this, $add_params,'cleer_hide', "$i. $value", 'Востановить', 0);
				$i++;
			}
			$attrs['max_height'] = 740;
			return ActionFactory::show_dialog("Скрытые итемы", $defs, true,0,$attrs);
		}
		
		if ($user_input->control_id == 'cleer_hide_all')
		{
			if (!isset($user_input->selected_media_url))
                return null;
			HD::save_items('hide_id', array());
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('vod_category_list'), $perform_new_action);
		}
		
		
		if ($user_input->control_id == 'cleer_hide')
		{
			if (!isset($user_input->selected_media_url))
                return null;
			if (isset($user_input->ch_pl))
				$ch_pl = $user_input->ch_pl;
			$hide_id_defs = HD::get_items('hide_id');
			unset ($hide_id_defs [$ch_pl]);
			HD::save_items('hide_id', $hide_id_defs);
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('vod_category_list'), $perform_new_action);
		}
		
		if ($user_input->control_id == 'del_parent_apply')
		{
			if ($user_input->pin !== $pin)
				return ActionFactory::show_title_dialog_gl("Код не правильный!!!");
			if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
            if (isset($media_url->subcategory_id))
				$id = $media_url->subcategory_id;
			else if (isset($media_url->category_id))
				$id = $media_url->category_id;
			else if (isset($media_url->action))
				$id = $media_url->action;
			$title = $media_url->name;
			$parental_defs = HD::get_items('parental_item');
			unset ($parental_defs [$id]);
			HD::save_items('parental_item', $parental_defs);
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('vod_category_list'), $perform_new_action);
		}
		
		if ($user_input->control_id == 'del_parental')
		{
			if (!isset($user_input->selected_media_url))
				return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			if (isset($media_url->subcategory_id))
				$id = $media_url->subcategory_id;
			else if (isset($media_url->category_id))
				$id = $media_url->category_id;
			else if (isset($media_url->action))
				$id = $media_url->action;
			$title = $media_url->name;
			$parental_defs = HD::get_items('parental_item');
			$is_protected = (array_key_exists($id, $parental_defs)) ? 1 : 0;
			if ($is_protected == 0)
				return ActionFactory::show_title_dialog_gl("Итем $title не защищен!!!");
			$defs = array();
			ControlFactory::add_text_field($defs,0,0,
				'pin', 'Код родительского контроля:',
				'', 1, 1, 0, 1, 500, 0, false);
			$do_kill_parent_apply = UserInputHandlerRegistry::create_action($this, 'del_parent_apply');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs, '_kill_parent_apply', 'ОК', 250, $do_kill_parent_apply);
			ControlFactory::add_close_dialog_button($defs, 'Отмена', 250);
			return  ActionFactory::show_dialog(	"Открыть итем (Parental) - $title",$defs,true, 0,$attrs);
		}
		
		if ($user_input->control_id == 'add_parental_apply')
		{
			if (!isset($user_input->selected_media_url))
				return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			if (isset($media_url->subcategory_id))
				$id = $media_url->subcategory_id;
			else if (isset($media_url->category_id))
				$id = $media_url->category_id;
			else if (isset($media_url->action))
				$id = $media_url->action;
			$title = $media_url->name;
			$parental_defs = HD::get_items('parental_item');
			$is_protected = (array_key_exists($id, $parental_defs)) ? 1 : 0;
			if ($is_protected == 1)
				return ActionFactory::show_title_dialog_gl("Итем $title уже защищен!!!");
			$parental_defs [$id] = 1;	
			HD::save_items('parental_item', $parental_defs);
			$perform_new_action = UserInputHandlerRegistry::create_action($this, 'cleer_folder');
			return ActionFactory::invalidate_folders(array('vod_category_list'), $perform_new_action);
		}
		
		if ($user_input->control_id == 'add_parental')
		{
			if (!isset($user_input->selected_media_url))
				return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$title = $media_url->name;
			$defs = array();
			ControlFactory::add_label($defs, "", "Вы уверены что хотите закрыть итем");
			ControlFactory::add_label($defs, "", "$title Родительским контролем ?");
			ControlFactory::add_label($defs, "", "Внимание: открыть итем можно через");
			ControlFactory::add_label($defs, "", "Открыть итем (Parental)");
			$do_add_parental_apply = UserInputHandlerRegistry::create_action($this, 'add_parental_apply');
			ControlFactory::add_custom_close_dialog_and_apply_buffon($defs, '_add_parental_apply', 'Да', 250, $do_add_parental_apply);
			ControlFactory::add_close_dialog_button($defs, 'Нет', 250);
			return  ActionFactory::show_dialog ("Закрыть итем (Parental Control): $title ?", $defs, true, 0,$attrs);
		}
		
		if ($user_input->control_id === 'pin_control'){
				if ($user_input->pin_control == $pin){
					$params['unlock'] = true;
					$do_actions = UserInputHandlerRegistry::create_action($this, 'add_actions', $params);
					return ActionFactory::close_dialog_and_run($do_actions);
				}
				else
					return  ActionFactory::show_title_dialog_gl('Код не верный!');
		}
		
		if ($user_input->control_id == 'add_actions')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);
			if (($pin != '1111')&&(!isset($user_input->unlock))){
				$parental_defs = HD::get_items('parental_item');
				if (isset($media_url->subcategory_id))
					$id = $media_url->subcategory_id;
				else if (isset($media_url->category_id))
					$id = $media_url->category_id;
				else if (isset($media_url->action))
					$id = $media_url->action;
				$is_protected = (array_key_exists($id, $parental_defs)) ? 1 : 0;
				if ($is_protected == 1){
					$defs = array();
					ControlFactory::add_text_field($defs, $this, $add_params=null,
						'pin_control', '',
						'', 1, 1, 0, 1, 500, 0, true);
					HD::get_lock_items('lock');
					return  ActionFactory::show_dialog('Введите код:',$defs,true, 0,$attrs);
				}else
					HD::get_lock_items('unlock');
			}
			return ActionFactory::open_folder();
        }
		
		if ($user_input->control_id == 'popup_menu')
        {
            if (!isset($user_input->selected_media_url))
                return null;
            $media_url = MediaURL::decode($user_input->selected_media_url);

			if (isset($media_url->subcategory_id))
				$id = $media_url->subcategory_id;
			else if (isset($media_url->category_id))
				$id = $media_url->category_id;
			else if (isset($media_url->action))
				$id = $media_url->action;
			$menu_items[] = array(
			GuiMenuItemDef::caption => 'В начало списка',
			GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'up_portal'),
			GuiMenuItemDef::icon_url => 'plugin_file://icons/up.png'
			);
			$group_list = HD::get_items('group_list');
			if (count($group_list)>0)
			$menu_items[] = array(
			GuiMenuItemDef::caption => 'Сбросить',
			GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'reset_portal'),
			GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
			);
			$menu_items [] =  array(
			GuiMenuItemDef::is_separator => true,);
			
            $menu_items[] = array(
                GuiMenuItemDef::caption => 'Скрыть категорию (CLEAR)',
                GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'hide_id'),
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
				);
				
            $menu_items[] = array(
                GuiMenuItemDef::caption => 'Список скрытых категорий',
                GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'hide_list'),
				GuiMenuItemDef::icon_url => 'gui_skin://small_icons/unknown_file.aai'
				);
			
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
			$parental_defs = HD::get_items('parental_item');
			
			$is_protected = (array_key_exists($id, $parental_defs)) ? 1 : 0;
			if ($is_protected == 1){
				$caption = 'Открыть итем';
				$action = UserInputHandlerRegistry::create_action($this, 'del_parental');
			}else{
				$caption = 'Закрыть итем';
				$action = UserInputHandlerRegistry::create_action($this, 'add_parental');
			}
            $menu_items[] = array(
                GuiMenuItemDef::caption => $caption,
                GuiMenuItemDef::action => $action,
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/kartina_tv_lock.png'
				);
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
				
			$menu_items[] = array(
            GuiMenuItemDef::caption => 'Задать иконку',
            GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'add_plugin_img'),
			GuiMenuItemDef::icon_url => 'gui_skin://small_icons/photo_viewer.aai'
			);
			
			$plugin_ico = HD::get_items('plugin_ico');
			if (isset($plugin_ico[$id])){
				$menu_items[] = array(
				GuiMenuItemDef::caption => 'Удалить иконку',
				GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'del_plugin_img'),
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
				);
			}
			$menu_items [] =  array(
				GuiMenuItemDef::is_separator => true,);
				
			$menu_items[] = array(
            GuiMenuItemDef::caption => 'Задать бекграунд',
            GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'add_category_bg'),
			GuiMenuItemDef::icon_url => 'gui_skin://small_icons/photo_viewer.aai'
			);
			
			if (isset($plugin_ico['category_bg'])){
				$menu_items[] = array(
				GuiMenuItemDef::caption => 'Удалить бекграунд',
				GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'del_category_bg'),
				GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
				);
			}

			return ActionFactory::show_popup_menu($menu_items);
        }
        return null;
    }

    public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies)
    {
		$items = array();
        if (!isset($media_url->subcategory_id))
            $category_list = SmartConfig::get_main_categories($media_url->category_id);
		else
			$category_list = SmartConfig::get_main_subcategories($media_url->subcategory_id, $media_url->category_id);
		$group_list = HD::get_items('group_list');
		$hide_id_defs = HD::get_items('hide_id');
		$i=1000;
        foreach ($category_list as $k => $v)
        {
			if (isset($hide_id_defs[$v]))
				continue;
			if ($v=='vod_favorites'){
				$mURL = VodFavoritesScreen::get_media_url_str();
				$ico = SmartConfig::get_plugin_ico('vod_favorites');
			}
			else if (preg_match("|_ufav|",$v)){
				$mURL = VodFavoritesScreen::get_media_url_str($v);
				$ico = SmartConfig::get_plugin_ico($v);
			}
			else if ($v=='vod_history'){
				$mURL = VodHistoryScreen::get_media_url_str();
				$ico = SmartConfig::get_plugin_ico('vod_history');
			}
			else if ($v=='search_screen'){
				$mURL = 'search_screen';
				$ico = SmartConfig::get_plugin_ico('search_screen');
			}
			else if (($v=='film')||($v=='serial')||($v=='animation')){
				$mURL = self::get_media_url_str($media_url->category_id, $v, $k);
				$ico = SmartConfig::get_plugin_ico($v);
			}else{
				$mURL = SmartVodListScreen::get_media_url_str($v, $media_url->subcategory_id , $k);
				$ico = SmartConfig::get_plugin_ico('kino_'.$v);
			}
			if (isset($group_list[$v]))
				$n = $group_list[$v];
			else
				$n = $i;
            $items[$n] = array
            (
                PluginRegularFolderItem::media_url => $mURL,
                PluginRegularFolderItem::caption => HD::mb_ucfirst($k),
                PluginRegularFolderItem::view_item_params => array
                (
                    ViewItemParams::icon_path => $ico,
                    ViewItemParams::item_detailed_icon_path => $ico,
                )
            );
			$i++;
        }
		ksort($items);
		$items = array_values($items);
        return $items;
    }

    ///////////////////////////////////////////////////////////////////////

    private function get_folder_views()
    {
        return SmartConfig::GET_VOD_CATEGORY_LIST_FOLDER_VIEWS();
    }
}

///////////////////////////////////////////////////////////////////////////
?>
