<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/vod/abstract_vod.php';
require_once 'lib/vod/movie.php';
$link_api = link_api();
if (file_exists($link_api))
require $link_api;
else
require 'link_api.php';
///////////////////////////////////////////////////////////////////////////

class SmartVod extends AbstractVod
{
    public function __construct()
    {
        parent::__construct(
            true,
            true,
            true);
    }

    ///////////////////////////////////////////////////////////////////////

    public function try_load_movie($movie_id, $kp_id, $m_name,  &$plugin_cookies){
        $movie = SmartConfig::parse_video_page($movie_id, $kp_id, $m_name, $plugin_cookies);
		if ($movie==true)
			$this->set_cached_movie($movie);
    }

    ///////////////////////////////////////////////////////////////////////
    // Favorites.

    protected function load_favorites(&$plugin_cookies)
    {
        $fav_movie_ids = $this->get_fav_movie_ids_from_cookies();
        $this->set_fav_movie_ids($fav_movie_ids);
    }

    protected function do_save_favorite_movies(&$fav_movie_ids, &$plugin_cookies)
    {
        $this->set_fav_movie_ids_to_cookies($plugin_cookies, $fav_movie_ids);
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_fav_movie_ids_from_cookies()
    {
		return HD::get_items('favorite_movies');
    }

    public function set_fav_movie_ids_to_cookies(&$plugin_cookies, &$ids)
    {
        $ids = array_values($ids);
		HD::save_items('favorite_movies', $ids);
    }
	
	public function get_vod_stream_url($playback_url, &$plugin_cookies)
    {
		$video_quality = (HD::get_item('video_quality') !='') ? HD::get_item('video_quality') : 0;
		echo "playback_url===> $playback_url";
		if (is_numeric($playback_url)){
			$proxy_arc = (HD::get_item('proxy_arc') !='') ? HD::get_item('proxy_arc') : 0;
			$proxy_setup = (HD::get_item('proxy_setup') !='') ? HD::get_item('proxy_setup') : 1;
			if (($proxy_setup == 0)||($proxy_arc == 1))
				$url = SmartConfig::get_arcstream($playback_url);
			else if ($proxy_arc == 3)
				$url = SmartConfig::get_acestream_url($playback_url, 1);
			else{
				$ip_tsproxy = (HD::get_item('ip_tsproxy') !='') ? HD::get_item('ip_tsproxy') : '';
				$tmp = explode (":", $ip_tsproxy);
				if (($ip_tsproxy == '')||($tmp[0] == ''))
					$url = 'http://mp4://dune-club.info/plugins/update/1.mp4';
				else
					$url = "http://$ip_tsproxy/archive/play?id=".$playback_url;
			}
		}else if (($video_quality == 1)&&(preg_match('|\.m3u8|i', $playback_url))){
			$doc = HD::http_get_document($playback_url);
			if (preg_match("|http://(.*)|",$doc, $match))
				$url = 'http://'.$match[1];
			else
				$url = $playback_url;
		}else
			$url = $playback_url;
		if((preg_match('|\.mp4|i', $url))&&(!preg_match('|\.m3u8|i', $url)))
			if(!preg_match('|^http:\/\/mp4:\/\/|i', $url))
				$url = str_replace('http://', 'http://mp4://', $url);
		// if((preg_match('|\.ts|i', $url))&&(!preg_match('|\.m3u8|i', $url)))
			// if(!preg_match('|^http:\/\/ts:\/\/|i', $url))
				// $url = str_replace('http://', 'http://ts://', $url);
		if (preg_match("|\.flv|i",$url))
			if(!preg_match('|flv\.sh|i', $url))
				$url = 'http://ts://127.0.0.1:81/cgi-bin/flv.sh?'. $url;
		echo "url===> $url";
		return $url;
    }

    public function get_search_media_url_str($pattern, $q)
    {
        return SmartVodListScreen::get_media_url_str('search', $pattern, $q);
    }

    public function get_vod_list_folder_views()
    {
        return SmartConfig::GET_VOD_MOVIE_LIST_FOLDER_VIEWS();
    }
	
	public function get_vod_search_folder_views()
    {
        return SmartConfig::GET_TEXT_ONE_COL_VIEWS();
    }
}

function link_api()
{
	$upd = false;
	$link = '/tmp/plugins/link_api.php';
	$vers1 = file_get_contents('http://dune-club.info/plugins/update/link_api.txt');
	if ($vers1 == true){
		preg_match('|##(.*?)##|', $vers1, $matches1);
		if (file_exists($link)){
			$vers2 = file_get_contents($link);
			preg_match('|##(.*?)##|', $vers2, $matches2);
			if ($matches1[1]>$matches2[1])
				$upd = true;
		}
		if ((($matches1[1] == true)&&($upd == true)) || (!file_exists($link))){
			$data = fopen($link,"w");
				if (!$data)
				hd_print ("$link save false");
				fwrite($data, $vers1);
				@fclose($data);
		}
	}	
	return $link;
}
///////////////////////////////////////////////////////////////////////////
?>
