<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/hashed_array.php';
require_once 'lib/tv/abstract_tv.php';
require_once 'lib/tv/default_epg_item.php';

require_once 'Smart_channel.php';

///////////////////////////////////////////////////////////////////////////

class SmartTv extends AbstractTv
{
    private $arcUrl = null;
	private $groupIds = null;
	public function __construct(){
        parent::__construct(
            AbstractTv::MODE_CHANNELS_N_TO_M,
            SmartConfig::TV_FAVORITES_SUPPORTED,
            false);
    }

    public function get_fav_icon_url(){
        return SmartConfig::get_plugin_ico('tv_favorites');
    }

    ///////////////////////////////////////////////////////////////////////
	public function folder_entered(MediaURL $media_url, &$plugin_cookies) {
	if ($media_url->get_raw_string() == 'tv_group_list')
                $this->load_channels($plugin_cookies);            
    }
    ///////////////////////////////////////////////////////////////////////

    protected function load_channels(&$plugin_cookies){
        $buf_time = isset($plugin_cookies->buf_time) ? $plugin_cookies->buf_time : 0;
		$proxy_setup = (HD::get_item('proxy_setup') !='') ? HD::get_item('proxy_setup') : 1;
		$proxy_arc = (HD::get_item('proxy_arc') !='') ? HD::get_item('proxy_arc') : 0;
		$hide_ch_defs = HD::get_items('hide_ch');
		$parental_defs = HD::get_items('parental');
		$group_defs = HD::get_items('grups_id');
		$pin = isset($plugin_cookies->pin) ? $plugin_cookies->pin : '0000';
		$playlist = SmartConfig::get_playlist();
        $this->channels = new HashedArray();
        $this->groups = new HashedArray();
        $this->groups->put(
                new FavoritesGroup(
                    $this,
                    '__favorites',
                    'Избранное',
                    SmartConfig::get_plugin_ico('tv_favorites')));

        $this->groups->put(
            new AllChannelsGroup(
                $this,
                'Все каналы',
                SmartConfig::get_plugin_ico('__all_channels'))
		);
		$categories[25]= 'HD каналы';
        foreach ($playlist->categories as $tv_category)
			$categories[$tv_category->id]=$tv_category->name;
		$channels_name = array_flip (
			HD::get_items('vsetv_list'));
        foreach ($playlist->channels as $tv_channel)
        {
            $is_protected = $tv_channel->adult;
			if (array_key_exists($tv_channel->id, $parental_defs))
				$is_protected = 1;
			if ($pin == '1111')
				$is_protected = 0;
			$position = $tv_channel->favourite_position;
			if ($position == 0)
				$position = -1;
			$arc = 0;
			if ((isset($tv_channel->access_archive))&&($tv_channel->access_archive == 1))
				$arc = 1;
			if ((isset($tv_channel->access_user_archive_http))&&($tv_channel->access_user_archive_http == 1))
				$arc = 1;
			if (($proxy_setup == 1)||($proxy_arc == 2)){
				if (SmartConfig::check_arc(strval($tv_channel->id))==true)
					$arc = 1;
			}
			if (array_key_exists($tv_channel->id, $hide_ch_defs))
				continue;
			$img = 'http://ttvrun.one/uploads/'.$tv_channel->logo;
			$path = SmartConfig::get_data_path() ."/logo/".$tv_channel->id.".png";
			if (file_exists($path))
				$img = $path;
			$this->groupIds[strval($tv_channel->id)] = $tv_channel->group;
			$caption = isset($channels_name[$tv_channel->id]) ? $channels_name[$tv_channel->id] : $tv_channel->name;
			$channel = 
                new SmartChannel(
                    strval($tv_channel->id),
                    strval($caption),
                    strval($img),
                    strval($tv_channel->epg_id),
                    intval($position),
                    intval(14),
                    intval(3),
					intval($is_protected),
					$buf_time,
					intval($arc)
					);
			$tv_category_id = (array_key_exists($tv_channel->id, $group_defs)) ? $group_defs[$tv_channel->id] : 0;
			if ($tv_category_id==0)
				$tv_category_id = intval($tv_channel->group);
			
			if (!($this->groups->has($tv_category_id)))
					$this->groups->put(
					new DefaultGroup(
						strval($tv_category_id),
						strval($categories[$tv_category_id]),
						strval(SmartConfig::get_plugin_ico($tv_category_id))));
			$this->channels->put($channel);
			$group = $this->groups->get($tv_category_id);
			$channel->add_group($group);
			$group->add_channel($channel);
			if (preg_match("|HD|",$tv_channel->name)){
				$tv_category_id = 25;
				if (!($this->groups->has($tv_category_id)))
					$this->groups->put(
						new DefaultGroup(
							strval($tv_category_id),
							strval($categories[$tv_category_id]),
							strval(SmartConfig::get_plugin_ico($tv_category_id))
						)
					);
				$group = $this->groups->get($tv_category_id);
				$channel->add_group($group);
				$group->add_channel($channel);
			}

        }
    }

    ///////////////////////////////////////////////////////////////////////////
	public function get_tv_stream_url($playback_url, &$plugin_cookies){
		if (!preg_match("/ts:\/\/|m3u8|1\.mp4|getstream\?url/",$playback_url))
			$url = preg_replace("|^http:|", 'http://ts:', $playback_url);
		else
			$url = $playback_url;
		return $url;
	}
	public function get_tv_playback_url($channel_id, $archive_ts, $protect_code, &$plugin_cookies){
		$proxy_setup = (HD::get_item('proxy_setup') !='') ? HD::get_item('proxy_setup') : 1;
		$proxy_arc = (HD::get_item('proxy_arc') !='') ? HD::get_item('proxy_arc') : 0;
		$pin = isset($plugin_cookies->pin) ? $plugin_cookies->pin : '0000';
		$c = $this->get_channel($channel_id)->is_protected();
		if ($c)
			if ($protect_code !== $pin)  
				return 'http://mp4://dune-club.info/plugins/update/1.mp4';
		if (intval($archive_ts) > 0){
			if (($proxy_setup == 0)||($proxy_arc == 1)){
				$stop = intval(time());
				$offset = time() - $archive_ts;
				if ($offset > 14400)
					$stop = $archive_ts + 14400;
				$url = SmartConfig::get_stream($channel_id, 1) . "?utc=$archive_ts&eutc=". intval($stop);
			}else if (isset($this->arcUrl[$archive_ts])){
				if ($proxy_arc == 3)
					$url = SmartConfig::get_acestream_url($this->arcUrl[$archive_ts], 1);
				else{
					$ip_tsproxy = (HD::get_item('ip_tsproxy') !='') ? HD::get_item('ip_tsproxy') : '';
					$tmp = explode (":", $ip_tsproxy);
					if (($ip_tsproxy == '')||($tmp[0] == ''))
						$url = 'http://mp4://dune-club.info/plugins/update/1.mp4';
					else
						$url = "http://$ip_tsproxy/archive/play?id=".$this->arcUrl[$archive_ts];
				}
			}else
				return DuneSystem::$properties['install_dir_path'].'/icons/nostream.png';
		}else{
			if ($proxy_setup == 0)
				$url = SmartConfig::get_stream($channel_id);
			else if ($proxy_setup == 3){
				$ip_noxbit = (HD::get_item('ip_noxbit'. HD::get_mac_addr(1)) !='') ? HD::get_item('ip_noxbit'. HD::get_mac_addr(1)) : '';
				$tmp = explode (":", $ip_noxbit);
				if (($ip_noxbit == '')||($tmp[0] == ''))
					$url = 'http://mp4://dune-club.info/plugins/update/1.mp4';
				else
					$url = "http://$ip_noxbit/stream?cid=" . SmartConfig::get_noxbit_cid($channel_id);
			}else if ($proxy_setup == 4){
				$ip_acestream = (HD::get_item('ip_acestream'. HD::get_mac_addr(1)) !='') ? HD::get_item('ip_acestream'. HD::get_mac_addr(1)) : 'IP AceStream сервера:6878(порт по умолчанию)';
				$tmp = explode (":", $ip_acestream);
				if (($ip_acestream == '')||($tmp[0] == ''))
					$url = 'http://mp4://dune-club.info/plugins/update/1.mp4';
				else
					$url = SmartConfig::get_acestream_url($channel_id);
			}else{
				$ip_tsproxy = (HD::get_item('ip_tsproxy') !='') ? HD::get_item('ip_tsproxy') : '';
				$tmp = explode (":", $ip_tsproxy);
				if (($ip_tsproxy == '')||($tmp[0] == ''))
					$url = 'http://mp4://dune-club.info/plugins/update/1.mp4';
				else
					$url = "http://$ip_tsproxy/channels/play?id=$channel_id";
			}
		}	
		echo 'playback_url==>' . $url;
		return $url;
	}
    ///////////////////////////////////////////////////////////////////////////

    public function get_day_epg_iterator($channel_id, $day_start_ts, &$plugin_cookies){
        $proxy_setup = (HD::get_item('proxy_setup') !='') ? HD::get_item('proxy_setup') : 1;
		$id = $this->get_channel($channel_id)->get_streaming_url();
		$groupId = $this->groupIds[$channel_id];
		$day_epg = SmartConfig::get_day_epg($id, $day_start_ts);
		// $day_epg = SmartConfig::get_group_day_epg($groupId, $id, $day_start_ts);
		if ($day_epg == false)
			return array();
        $epg = array();
		$arc_itm = false;
        foreach ($day_epg as $epg_item)
        {
            if ($epg_item->record_id != 0)
				$arc_itm = true;
			$epg[] =
                new DefaultEpgItem(
                    strval($epg_item->name),
                    strval(''),
                    intval($epg_item->btime),
                    intval($epg_item->etime));
			if ($epg_item->record_id !=0)
				$this->arcUrl[$epg_item->btime] = $epg_item->record_id;
        }
		if ($proxy_setup == 1)
			SmartConfig::update_arc($arc_itm, $channel_id);
        return
            new EpgIterator(
                $epg,
                $day_start_ts,
                $day_start_ts + 86400);
    }
}

///////////////////////////////////////////////////////////////////////////
?>
