<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/abstract_controls_screen.php';

///////////////////////////////////////////////////////////////////////////

class SmartSetupScreen extends AbstractControlsScreen
{
    const ID = 'setup';

    ///////////////////////////////////////////////////////////////////////

    public function __construct(){
        parent::__construct(self::ID);
    }
	
	public static function get_media_url_str(){
        return MediaURL::encode(array('screen_id' => self::ID));
    }
	
    public function do_get_control_defs(&$plugin_cookies){
        $defs = array();
		$video_quality = (HD::get_item('video_quality') !='') ? HD::get_item('video_quality') : 0;
        $buf_time = isset($plugin_cookies->buf_time) ? $plugin_cookies->buf_time : 0;
		$epg_font = isset($plugin_cookies->epg_font) ? $plugin_cookies->epg_font : PLUGIN_FONT_NORMAL;
		$start_tv = isset($plugin_cookies->start_tv) ? $plugin_cookies->start_tv : 0;
        $show_ops = array();
        $show_ops['yes'] = 'Да';
        $show_ops['no'] = 'Нет';
		
		$vquality = array();
        $vquality[0] = 'Авто';
        $vquality[1] = 'Максимально возможное';
		
		$buf_time_ops = array();
        $buf_time_ops[0] = 'По умолчанию';
        $buf_time_ops[500] = '0.5 сек';
        $buf_time_ops[1000] = '1 сек';
        $buf_time_ops[2000] = '2 сек';
        $buf_time_ops[3000] = '3 сек';
        $buf_time_ops[5000] = '5 сек';
        $buf_time_ops[10000] = '10 сек';
		
		for ($i = -12; $i<13; $i++)
		$shift_ops[$i*3600] = $i;
		
		$epg_font_ops = array();
        $epg_font_ops[PLUGIN_FONT_NORMAL] = 'Нормальный';
        $epg_font_ops[PLUGIN_FONT_SMALL] = 'Мелкий';
		
		$start_ops = array();
		$start_ops[0] = 'Категории и каналы';
		$start_ops[1] = 'Запускать просмотр ТВ';
		
		
		$this->add_button(
            $defs,'additional_settings',
            'Настройки Торрент-ТВ:',
            'Изменить...', 0
		);
        $this->add_combobox($defs,
            'start_tv', 
			'Старт плагина:',
            $start_tv, $start_ops, 0, true
		);
			
		ControlFactory::add_smart_label($defs, 
			"Папка DATA:", 
			'<text color="10" size="normal">'.SmartConfig::get_data_path().'</text>'
		);

		$this->add_button(
            $defs,'data_dialog',
            '',
            'Изменить/Выгрузить/Загрузить/Очистить', 0
		);
		// $rec_dir = smbtree::get_folder_info ('rec_dir_path');
		// if ($rec_dir == '')
			// $rec_dir = 'Не выбрано';
		// ControlFactory::add_smart_label($defs, 
			// "Папка для записи:", 
			// '<text color="10" size="normal">'.$rec_dir.'</text>'
		// );
		
		// $this->add_button($defs,
            // 'rec_path',
            // '',
            // 'Изменить расположение', 0
		// );
		
		$this->add_combobox ($defs,
			'buf_time', 
			'Время буферизации:', 
			$buf_time, $buf_time_ops, 0, true
		);
		
		$this->add_combobox($defs,
			'video_quality',
			'Качество видео VOD:',
			$video_quality, $vquality, 0, true
        );
		
		$this->add_combobox($defs, 
			'epg_font', 
			'Шрифт ТВ программы:', 
			$epg_font, $epg_font_ops, 0, true
		);
		
		$this->add_button(
            $defs,'pin_dialog',
            'Код родительского контроля:',
            'Изменить...', 0
		);
		

        return $defs;
    }

    public function get_control_defs(MediaURL $media_url, &$plugin_cookies){
        return $this->do_get_control_defs($plugin_cookies);
    }

    public function handle_user_input(&$user_input, &$plugin_cookies){
        $attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
		

		if ($user_input->control_id === 'buf_time')
			$plugin_cookies->buf_time = $user_input->buf_time;
		if ($user_input->control_id === 'epg_shift')
			$plugin_cookies->epg_shift = $user_input->epg_shift;
		if ($user_input->control_id === 'epg_font')
            $plugin_cookies->epg_font = $user_input->epg_font;
		if ($user_input->control_id === 'start_tv')
            $plugin_cookies->start_tv = $user_input->start_tv;
		if ($user_input->control_id === 'video_quality')
			HD::save_item('video_quality', $user_input->video_quality);
		if ($user_input->control_id === 'additional_settings'){
			$defs = array();
			$this->add_button(
				$defs,
				'ttv_login',
				'Учетные данные Торрент-ТВ:',
				'Логин/Пароль', 800
			);
			
			$proxy_setup = (HD::get_item('proxy_setup') !='') ? HD::get_item('proxy_setup') : 2;
			$proxy_ops[0] = 'HTTP поток с серверного TS-Proxy';
			$proxy_ops[1] = 'HTTP поток с локального TS-Proxy';
			$proxy_ops[4] = 'HTTP поток с proxy AceStream 3.1+';
			$proxy_ops[3] = 'HTTP поток с Noxbit';
			$proxy_ops[2] = 'Выберите';
			ControlFactory::add_combobox($defs, $this, null,
				'proxy_setup',
				'Тип прокси:',
				$proxy_setup, $proxy_ops, 800, true
			);
			$proxy_arc = (HD::get_item('proxy_arc') !='') ? HD::get_item('proxy_arc') : 0;
			$arc_ops[0] = 'Выберите';
			$arc_ops[1] = 'Архив с серверного TS-Proxy';
			$arc_ops[2] = 'Архив с локального TS-Proxy';
			$arc_ops[3] = 'Архив с Ace Stream 3.1+';
			ControlFactory::add_combobox($defs, $this, null,
				'proxy_arc',
				'Прокси для архива:',
				$proxy_arc, $arc_ops, 800, true
			);
			if ($proxy_setup==0){
				$proxy_server = (HD::get_item('proxy_server') !='') ? HD::get_item('proxy_server') : 1;
				$proxy_server_ops = SmartConfig::get_zones();
				ControlFactory::add_combobox($defs, $this, null,
					'proxy_server',
					'Сервер TS-Proxy:',
					$proxy_server, $proxy_server_ops, 800, true
				);
						
				$use_hls = (HD::get_item('use_hls') !='') ? HD::get_item('use_hls') : 1;
				$hls_ops[0] = 'Да';
				$hls_ops[1] = 'Нет';
				ControlFactory::add_combobox($defs, $this, null,
					'use_hls',
					'Использовать HLS:',
					$use_hls, $hls_ops, 800, true
				);
			}		
			$use_pl = (HD::get_item('use_pl') !='') ? HD::get_item('use_pl') : 'all';
			$use_pl_ops['all'] = 'все (кроме избранного)';
			$use_pl_ops['favourite'] = 'избранное Торрент ТВ';
			$use_pl_ops['channel'] = 'каналы';
			$use_pl_ops['moderation'] = 'каналы на модерации';
			$use_pl_ops['translation'] = 'временные трансляции';
						
			ControlFactory::add_combobox($defs, $this, null,
				'use_pl',
				'Использовать плейлист:',
				$use_pl, $use_pl_ops, 800, true
			);		
			$use_fav = (HD::get_item('use_fav') !='') ? HD::get_item('use_fav') : 0;
			$use_fav_ops[0] = 'плагина';
			$use_fav_ops[1] = 'с Торрент ТВ';
			ControlFactory::add_combobox($defs, $this, null,
				'use_fav',
				'Избранное:',
				$use_fav, $use_fav_ops, 800, true
			);
			if ($proxy_setup==1){
				$ip_tsproxy = (HD::get_item('ip_tsproxy') !='') ? HD::get_item('ip_tsproxy') : 'IP локального сервера:8081(порт по умолчанию)';
				$tmp = explode (":", $ip_tsproxy);
				if ($tmp[0] == '')
					$ip = 'IP локального сервера';
				else
					$ip = $tmp[0];
				ControlFactory::add_text_field($defs, $this, $add_params=null,
					'ip_tsproxy',
					'IP локального TS-Proxy:',
					$ip, 1, 0, 0, 1, 800, 0, false
				);
				if ($tmp[1] == '8081')
					$port = '8081(порт по умолчанию)';
				else
					$port = $tmp[1];
				ControlFactory::add_text_field($defs, $this, $add_params=null,
					'port_tsproxy',
					'Порт локального TS-Proxy:',
					$port, 1, 0, 0, 1, 800, 0, false
				);
				$params['arg'] = 'ip_tsproxy';
			}
			if ($proxy_setup==4){
				$ip_acestream = (HD::get_item('ip_acestream'. HD::get_mac_addr(1)) !='') ? HD::get_item('ip_acestream'. HD::get_mac_addr(1)) : 'IP AceStream сервера:6878(порт по умолчанию)';
				$tmp = explode (":", $ip_acestream);
				if ($tmp[0] == ''){
					if (preg_match('|AceStream|', file_get_contents('/tmp/run/installed_plugins.xml'))){
						$ip = '127.0.0.1 (Локальный AceStream)';
						ControlFactory::add_label($defs, 'Жмите применить ', 'локального AceStream сервера');
					}else
						$ip = 'IP AceStream сервера';
				}else{
					if ((($tmp[0] == 'IP AceStream сервера')||($tmp[0] == '127.0.0.1'))&&(preg_match('|AceStream|', file_get_contents('/tmp/run/installed_plugins.xml')))){
						$ip = '127.0.0.1 (Локальный AceStream)';
						ControlFactory::add_label($defs, 'Жмите применить ', 'локального AceStream сервера');
					}else
						$ip = $tmp[0];
				}
				ControlFactory::add_text_field($defs, $this, $add_params=null,
					'ip_acestream',
					'IP AceStream сервера:',
					$ip, 1, 0, 0, 1, 800, 0, false
				);
				if ($tmp[1] == '6878')
					$port = '6878(порт по умолчанию)';
				else
					$port = $tmp[1];
				ControlFactory::add_text_field($defs, $this, $add_params=null,
					'port_acestream',
					'Порт AceStream сервера:',
					$port, 1, 0, 0, 1, 800, 0, false
				);
				$dune_acestream_ip = (HD::get_item('dune_acestream_ip'. HD::get_mac_addr(1)) !='') ? HD::get_item('dune_acestream_ip'. HD::get_mac_addr(1)) : 0;
				ControlFactory::add_multiline_label($defs, '', "Устройство с AceStream сервер это Dune HD?", 2);
				$show_ops[0] = 'Нет';
				$show_ops[1] = 'Да';		
				ControlFactory::add_combobox($defs, $this, null,
				'dune_acestream_ip', '',
				$dune_acestream_ip, $show_ops, 1150, false, false);
				$params['arg'] = 'ip_acestream';
			}
			if ($proxy_setup==3){
				$ip_noxbit = (HD::get_item('ip_noxbit'. HD::get_mac_addr(1)) !='') ? HD::get_item('ip_noxbit'. HD::get_mac_addr(1)) : 'IP Noxbit сервера:6689(порт по умолчанию)';
				$tmp = explode (":", $ip_noxbit);
				if ($tmp[0] == ''){
					if (preg_match('/Noxbit/', file_get_contents('/tmp/run/installed_plugins.xml'))){
						$ip = '127.0.0.1 (Локальный Noxbit)';
						ControlFactory::add_label($defs, '', 'Жмите применить для использования локального Noxbit сервера');
					}else
						$ip = 'IP Noxbit сервера';
				}else
					$ip = $tmp[0];
				ControlFactory::add_text_field($defs, $this, $add_params=null,
					'ip_noxbit',
					'IP Noxbit сервера:',
					$ip, 1, 0, 0, 1, 800, 0, false
				);
				if ($tmp[1] == '6689')
					$port = '6689(порт по умолчанию)';
				else
					$port = $tmp[1];
				ControlFactory::add_text_field($defs, $this, $add_params=null,
					'port_tsproxy',
					'Порт Noxbit сервера:',
					$port, 1, 0, 0, 1, 800, 0, false
				);
				$dune_noxbit_ip = (HD::get_item('dune_noxbit_ip'. HD::get_mac_addr(1)) !='') ? HD::get_item('dune_noxbit_ip'. HD::get_mac_addr(1)) : 0;
				ControlFactory::add_multiline_label($defs, '', "Устройство с Noxbit сервер это Dune HD?", 2);
				$show_ops[0] = 'Нет';
				$show_ops[1] = 'Да';		
				ControlFactory::add_combobox($defs, $this, null,
				'dune_noxbit_ip', '',
				$dune_noxbit_ip, $show_ops, 1150, false, $need_apply = false);
				$params['arg'] = 'ip_noxbit';
			}
			if ($proxy_setup !=0){
				$do = UserInputHandlerRegistry::create_action($this, 'do_ip_tsproxy', $params);
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'apply_subscription', 'Применить', 350, $do);
			}
			
			$attrs['initial_sel_ndx'] = isset($user_input->initial_sel_ndx) ? $user_input->initial_sel_ndx : -1;
			return  ActionFactory::show_dialog("Настройки Торрент-ТВ",	$defs, true,1400, $attrs);
		}
		if ($user_input->control_id === 'do_ip_tsproxy'){
			
			$arg = $user_input->arg;
			if (($user_input->$arg=='IP локального сервера')||($user_input->$arg=='IP Noxbit сервера')||($user_input->$arg=='IP AceStream сервера')){
				$params['initial_sel_ndx'] = 5;
				$do = UserInputHandlerRegistry::create_action($this, 'additional_settings',$params);
				return ActionFactory::show_title_dialog('IP адрес не задан!',$do,"Задайте IP адрес",800,1);
			}
			if ($arg == 'ip_acestream'){
				$port_acestream = str_replace(array ('http',':','//','(порт по умолчанию)'), '', $user_input->port_acestream);
				$ip_acestream = str_replace(array ('http',':','//',' (Локальный AceStream)'), '', $user_input->$arg);
				if ($ip_acestream == '127.0.0.1')
					$user_input->dune_acestream_ip = 1;
				HD::save_item('dune_acestream_ip'. HD::get_mac_addr(1), $user_input->dune_acestream_ip);
				HD::save_item($arg. HD::get_mac_addr(1), $ip_acestream .':'. $port_acestream);
				$do = ActionFactory::reset_controls($this->do_get_control_defs($plugin_cookies));
				return ActionFactory::show_title_dialog('Адрес локального AceStream сохранен!',$do,$ip_acestream .':'. $port_acestream,800,1);
			}
			
			if (($user_input->port_tsproxy =='')||(preg_match( '|[a-zA-Z]|',$user_input->port_tsproxy))){
				$port_tsproxy = '8081';
				if ($arg == 'ip_noxbit')
					$port_tsproxy = 6689;
			}else
				$port_tsproxy = str_replace(array ('http',':','//','(порт по умолчанию)'), '', $user_input->port_tsproxy);
			$ip_tsproxy = str_replace(array ('http',':','//',' (Локальный Noxbit)'), '', $user_input->$arg);
			if (isset($user_input->dune_noxbit_ip)){
				if ($ip_tsproxy == '127.0.0.1')
					$user_input->dune_noxbit_ip = 1;
				HD::save_item('dune_noxbit_ip'. HD::get_mac_addr(1), $user_input->dune_noxbit_ip);
			}
			if ($arg == 'ip_noxbit')
				HD::save_item($arg. HD::get_mac_addr(1), $ip_tsproxy .':'. $port_tsproxy);
			else
				HD::save_item($user_input->arg, $ip_tsproxy .':'. $port_tsproxy);
			$do = ActionFactory::reset_controls($this->do_get_control_defs($plugin_cookies));
			return ActionFactory::show_title_dialog('Адрес локального прокси сохранен!',$do,"",800,1);
		}
		if ($user_input->control_id === 'proxy_setup'){
			HD::save_item('proxy_setup', $user_input->proxy_setup);
			$params['initial_sel_ndx'] = 1;
			$do_actions = UserInputHandlerRegistry::create_action($this, 'additional_settings',$params);
			return ActionFactory::close_dialog_and_run($do_actions);
		}
		if ($user_input->control_id === 'proxy_arc'){
			HD::save_item('proxy_arc', $user_input->proxy_arc);
			$params['initial_sel_ndx'] = 2;
			$do_actions = UserInputHandlerRegistry::create_action($this, 'additional_settings',$params);
			return ActionFactory::close_dialog_and_run($do_actions);
		}
		if ($user_input->control_id === 'proxy_server'){
			HD::save_item('proxy_server', $user_input->proxy_server);
			$params['initial_sel_ndx'] = 3;
			$do_actions = UserInputHandlerRegistry::create_action($this, 'additional_settings',$params);
			return ActionFactory::close_dialog_and_run($do_actions);
		}
		if ($user_input->control_id === 'use_hls'){
			HD::save_item('use_hls', $user_input->use_hls);
			$params['initial_sel_ndx'] = 4;
			$do_actions = UserInputHandlerRegistry::create_action($this, 'additional_settings',$params);
			return ActionFactory::close_dialog_and_run($do_actions);
		}
		if ($user_input->control_id === 'use_pl'){
			HD::save_item('use_pl', $user_input->use_pl);
			if ($user_input->use_pl = 'favourite')
				HD::save_item('use_fav', 0);
			$params['initial_sel_ndx'] = 5;
			$do_actions = UserInputHandlerRegistry::create_action($this, 'additional_settings',$params);
			$perform_new_action = ActionFactory::close_dialog_and_run($do_actions);
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
		}
		if ($user_input->control_id === 'use_fav'){
			HD::save_item('use_fav', $user_input->use_fav);
			if (($user_input->use_fav = 1)&&(HD::get_item('use_pl') == 'favourite'))
				HD::save_item('use_pl', 'all');
			$params['initial_sel_ndx'] = 6;
			$do_actions = UserInputHandlerRegistry::create_action($this, 'additional_settings',$params);
			$perform_new_action = ActionFactory::close_dialog_and_run($do_actions);
			return ActionFactory::invalidate_folders(array('tv_group_list', TvFavoritesScreen::get_media_url_str()), $perform_new_action);
		}
		if ($user_input->control_id === 'data_path'){
            $media_url = MediaURL::encode
                (
                    array
                    (
                        'screen_id'     => 'file_list',
						'save_data'		=> 'data_dir_path'
                    )
                );
				$do_actions = ActionFactory::open_folder($media_url,'Расположение DATA');
				return ActionFactory::close_dialog_and_run($do_actions);
		}
		
		if ($user_input->control_id === 'rec_path'){
                $media_url = MediaURL::encode
                (
                    array
                    (
                        'screen_id'     => 'file_list',
						'save_data'		=> 'rec_dir_path'
                    )
                );
				return ActionFactory::open_folder($media_url,'Расположение папки для записи');
		}
		
		if ($user_input->control_id === 'ttv_login'){
				$defs = array();
				$login_settings = HD::get_items('login_settings');
				$user_login = isset($login_settings['user_login']) ? $login_settings['user_login'] : 'Введите логин';
				$user_pass = isset($login_settings['user_pass']) ? $login_settings['user_pass'] : 'Введите пароль';
				ControlFactory::add_multiline_label($defs,'' ,'Логин на Торрент-ТВ необходим для получения плейлиста.',6);
				if ($user_pass == 'Введите пароль')
					$p = 0;
				else
					$p = 1;
				ControlFactory::add_text_field($defs, $this, $add_params=null,
						'user_login',
						'',
						$user_login, 0, 0, 0, 1, 950, 0, false
				);
				ControlFactory::add_text_field($defs, $this, $add_params=null,
						'user_pass',
						'',
						$user_pass, 0, $p, 0, 1, 950, 0, false
				);
				ControlFactory::add_label($defs, '', '');
				$do_new_login_action = UserInputHandlerRegistry::create_action($this, 'do_login_action');
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'apply_subscription', 'Применить', 350, $do_new_login_action);
				return ActionFactory::show_dialog("Логин и пароль Торрент-ТВ", $defs, true,1100,$attrs);
		}
		
		if ($user_input->control_id == 'do_login_action'){
				if (!isset($user_input->selected_media_url))
					return null;
				if (($user_input->user_login == '' )||
				($user_input->user_pass == '' )||
				($user_input->user_login == 'Введите логин' )||
				($user_input->user_pass == 'Введите пароль' ))
					return ActionFactory::show_title_dialog_gl("Логин или пароль не могут быть пустыми!");
				$login_settings['user_login'] = $user_input->user_login;
				$login_settings['user_pass'] = $user_input->user_pass;
				HD::save_items('login_settings', $login_settings);
				if (SmartConfig::get_login_check(true) == true)
					return ActionFactory::invalidate_folders(array('tv_group_list'));
				else
					return ActionFactory::show_title_dialog('Логин не удался!',null,"Возможно не верный логин и/или пароль",800,1);
		}
		
		if ($user_input->control_id === 'pin_dialog'){
				$defs = array();
				$this->add_text_field($defs,
					'pin1', 'Старый код родительского контроля:',
					'', 1, 1, 0, 1, 500, 0, false);
				$this->add_text_field($defs,
					'pin2', 'Новый код родительского контроля:',
					'', 1, 1, 0, 1, 500, 0, false);
				$this->add_label($defs, 'Код 1111 - отключение', '');
				$this->add_close_dialog_and_apply_button($defs,'pin_apply', 'Применить', 250);					
				return  ActionFactory::show_dialog("Родительский контроль",	$defs, true,0, $attrs);
		}
		
		if ($user_input->control_id === 'data_dialog'){
				$defs = array();
				ControlFactory::add_multiline_label($defs, 'Внимание', "Возможно удаление внесенных изменений!\nВыгрузка происходит в текущую папку.\nЗагрузка происходит из текущей папки.\nВыберите папку и нажмите синюю кнопку:",6);
				ControlFactory::add_img_label($defs, '', '<icon>gui_skin://special_icons/controls_button_blue.aai</icon><text dy="7" size="small"> - нажмите для выгрузки или загрузки DATA</text>', 0, 0, 0);
				
				$this->add_button(
					$defs,
					'data_path',
					'Папка DATA:',
					'Изменить расположение', 
					500
				);
				$this->add_button(
					$defs,
					'export_data',
					'Выгрузить DATA',
					"Плагин => Накопитель",
					500
				);
				$this->add_button(
					$defs,
					'import_data',
					'Загрузить DATA',
					'Накопитель => Плагин',
					500
				);
				$this->add_button(
					$defs,
					'import_file_data',
					'Файл в DATA',
					'Накопитель => Плагин',
					500
				);
				$this->add_button(
					$defs,
					'clear_data',
					'',
					'Очистить DATA в плагине',
					850
				);
				return  ActionFactory::show_dialog("Папка DATA",$defs, true,1200, $attrs);
		}
		
		if ($user_input->control_id === 'clear_data'){
				
				if (file_exists(DuneSystem::$properties['data_dir_path']))
					shell_exec("rm -rf ".DuneSystem::$properties['data_dir_path']);
				if (!file_exists(DuneSystem::$properties['data_dir_path']))
				mkdir(DuneSystem::$properties['data_dir_path'],0777,true);
				$do_actions = ActionFactory::show_title_dialog_gl("Папка DATA в плагине очищена!");
				return ActionFactory::close_dialog_and_run($do_actions);
		}
		
		if ($user_input->control_id === 'import_data'){
				$media_url = MediaURL::encode
                (
                    array
                    (
                        'screen_id'     => 'file_list',
						'save_data'		=> 'import_data'
                    )
                );
				$do_actions = ActionFactory::open_folder($media_url,'Folders');
				return ActionFactory::close_dialog_and_run($do_actions);
		}
		
		if ($user_input->control_id === 'import_file_data'){
				$media_url = MediaURL::encode (
                    array
                    (
                        'screen_id'     => 'file_list',
						'save_file'		=> array(	
						'parent' 		=> 'setup',
						'action' 		=> 'import_file_data',
						'extension' 	=> 'all_extension'
						),
                    )
				);
				$do_actions = ActionFactory::open_folder($media_url,'Выберите файл для загрузки в DATA');
				return ActionFactory::close_dialog_and_run($do_actions);
		}
		
		if ($user_input->control_id === 'reset_controls')
				return ActionFactory::reset_controls($this->do_get_control_defs($plugin_cookies));
		
		if ($user_input->control_id === 'export_data'){
				$media_url = MediaURL::encode
                (
                    array
                    (
                        'screen_id'     => 'file_list',
						'save_data'		=> 'export_data'
                    )
                );
				$do_actions = ActionFactory::open_folder($media_url,'Folders');
				return ActionFactory::close_dialog_and_run($do_actions);
		}
		
		if ($user_input->control_id === 'pin_apply'){
				$pin = isset($plugin_cookies->pin) ? $plugin_cookies->pin : '0000';
				if ($user_input->pin1 == '' || $user_input->pin2 == '')
					$msg = 'Код не изменен!';
				else if ($user_input->pin1 == $pin){
					$plugin_cookies->pin = $user_input->{'pin2'};
					$action = ActionFactory::invalidate_folders(array('tv_group_list'));
					$msg = 'Код изменен!';
				}
				else{
					$action = null;
					$msg = 'Код не изменен!';
				}
				return  ActionFactory::show_title_dialog($msg,$action,"",800,1);
		}

        return ActionFactory::reset_controls(
            $this->do_get_control_defs($plugin_cookies));
    }
}

///////////////////////////////////////////////////////////////////////////
?>
