<?php
require_once 'lib/vod/vod.php';
require_once 'lib/abstract_preloaded_regular_screen.php';

class SmartSearchScreen extends AbstractPreloadedRegularScreen
    implements UserInputHandler
{
    const ID = 'search_screen';

    public static function get_media_url_str($category = '')
    {
        return  MediaURL::encode
                (
                    array
                    (
                        'screen_id' => self::ID,
                        'category' => $category
                    )
                );
    }

    ///////////////////////////////////////////////////////////////////////

    private $vod;

    public function __construct(Vod $vod)
    {
        $this->vod = $vod;

        parent::__construct(self::ID, $this->get_folder_views());
        
        UserInputHandlerRegistry::get_instance()->register_handler($this);
    }

    protected function get_folder_views()
    {
        return $this->vod->get_vod_search_folder_views();
    }
    ///////////////////////////////////////////////////////////////////////

    public function get_action_map(MediaURL $media_url, &$plugin_cookies)
    {
		$actions = array();
		$actions[GUI_EVENT_KEY_SETUP] = ActionFactory::open_folder(SmartSetupScreen::get_media_url_str(),"Настройки");
		$add_params['search_actions'] = 'open';
        $actions[GUI_EVENT_KEY_ENTER] = UserInputHandlerRegistry::create_action($this, 'do_search',$add_params);
		$add_params['search_actions'] = 'keyboard';
        $actions[GUI_EVENT_KEY_PLAY] = UserInputHandlerRegistry::create_action($this, 'do_search',$add_params);
		$add_action = UserInputHandlerRegistry::create_action($this, 'del_search');
        $add_action['caption'] = 'Удалить';
		$actions[GUI_EVENT_KEY_D_BLUE] = $add_action;
        $add_action = UserInputHandlerRegistry::create_action($this, 'up_item');
		$add_action['caption'] = 'Поднять';
		$actions[GUI_EVENT_KEY_B_GREEN] = $add_action;
		$add_action = UserInputHandlerRegistry::create_action($this, 'down_item');
		$add_action['caption'] = 'Опустить';
		$actions[GUI_EVENT_KEY_C_YELLOW] = $add_action;
        $actions[GUI_EVENT_KEY_POPUP_MENU] = UserInputHandlerRegistry::create_action($this, 'popup_menu');
        return $actions;
    }

    public function get_handler_id()
    { return self::ID; }

    private function get_update_action(&$user_input, &$plugin_cookies)
    {
        $parent_media_url = MediaURL::decode($user_input->parent_media_url);
        $range = HD::create_regular_folder_range( $this->get_all_folder_items( $parent_media_url, $plugin_cookies));
        return ActionFactory::update_regular_folder( $range, true, 1);
    }

    public function handle_user_input(&$user_input, &$plugin_cookies)
    {	
		$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
		if ($user_input->control_id === 'cleer_folder')
		{
			if (!isset($user_input->parent_media_url))
				return null;
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$sel_ndx = $user_input->sel_ndx;
				if ($sel_ndx < 0)
					$sel_ndx = 0;
			$range = $this->get_folder_range($parent_media_url, 0, $plugin_cookies);
			return ActionFactory::update_regular_folder($range, true, $sel_ndx);
		}
		
		if ($user_input->control_id === 'do_search')
		{
			if (!isset($user_input->parent_media_url))
				return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$use_osk = (HD::get_item('use_osk') !='') ? HD::get_item('use_osk') : 1;
			if (($media_url->genre_id != 'search')&&($user_input->search_actions!='keyboard'))
                    return ActionFactory::open_folder($user_input->selected_media_url);
			$defs = array();
			if ($user_input->search_actions=='keyboard')
				$search_text = $media_url->genre_id;
			else
				$search_text = HD::get_item('search_item');
			ControlFactory::add_text_field($defs,
			$this, $add_params=null,
			'do_new_search', '',
			$search_text, 0, 0, $use_osk, 1, 1300,0,1);
			if ($use_osk == 1)
				ControlFactory::add_vgap($defs, 500);
			return ActionFactory::show_dialog('Поиск', $defs, true, 0,$attrs);
		}
		if ($user_input->control_id == 'do_new_search')
        {
			$do_search = UserInputHandlerRegistry::create_action($this, 'run_search');
			return ActionFactory::close_dialog_and_run($do_search);
		}
		
		if ($user_input->control_id == 'run_search')
        {
			$media_url = MediaURL::decode($user_input->selected_media_url);
			HD::save_item('search_item', $user_input->do_new_search);
			$search_items = HD::get_items('search_items');
			$k = array_search($user_input->do_new_search, $search_items);
			if ($k !== false)
				unset ($search_items [$k]);
			array_unshift($search_items, $user_input->do_new_search); 
			HD::save_items('search_items', $search_items);
			$action = ActionFactory::open_folder(SmartVodListScreen::get_media_url_str('search', $user_input->do_new_search, $media_url->name), "Поиск: ".$user_input->do_new_search);
			return ActionFactory::invalidate_folders(array('search_screen'),$action);
		}
		
		if ($user_input->control_id == 'up_item')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$video_id = $media_url->genre_id;
			$search_items = HD::get_items('search_items');
			$k = array_search($video_id, $search_items);
			if ($k !== false && $k !== 0){
				$t = $search_items[$k - 1];
				$search_items[$k - 1] = $search_items[$k];
				$search_items[$k] = $t;
			}
			HD::save_items('search_items', $search_items);
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$range = HD::create_regular_folder_range(
				$this->get_all_folder_items(
					$parent_media_url, $plugin_cookies));
			return ActionFactory::update_regular_folder(
				$range, false, $user_input->sel_ndx - 1);
        }
		
		if ($user_input->control_id == 'down_item')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$video_id = $media_url->genre_id;
			$search_items = HD::get_items('search_items');
			$k = array_search($video_id, $search_items);
			if ($k !== false && $k !== count($search_items) - 1){
				$t = $search_items[$k + 1];
				$search_items[$k + 1] = $search_items[$k];
				$search_items[$k] = $t;
			}
			HD::save_items('search_items', $search_items);
			$parent_media_url = MediaURL::decode($user_input->parent_media_url);
			$range = HD::create_regular_folder_range(
				$this->get_all_folder_items(
					$parent_media_url, $plugin_cookies));
			return ActionFactory::update_regular_folder(
				$range, false, $user_input->sel_ndx + 1);
        }
		
		if ($user_input->control_id == 'del_search')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$media_url = MediaURL::decode($user_input->selected_media_url);
			$video_id = $media_url->genre_id;
			$search_items = HD::get_items('search_items');
			$k = array_search($video_id, $search_items);
			unset ($search_items[$k]);
			HD::save_items('search_items', $search_items);
            return ActionFactory::invalidate_folders(array('search_screen'));
        }
		
		if ($user_input->control_id == 'add_vod_list_bg')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$msg = "Для применения изменений выйдите из плагина, нажмите кнопку POPUP и выберите 'Обновить'.";
			$media_url = MediaURL::encode (
                    array
                    (
                        'screen_id'     => 'file_list',
						'save_file'		=> array(	
						'parent' 		=> self::ID,
						'action' 		=> 'plugin_ico',
						'arg' 			=> 'one_col_bg',
						'msg' 			=> $msg,
						'extension' 	=> 'jpg'
						),
                    )
			);
			return ActionFactory::open_folder($media_url,'Folders');
		}
		
		if ($user_input->control_id == 'del_vod_list_bg')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			$plugin_ico = HD::get_items('plugin_ico');
			unlink($plugin_ico['one_col_bg']);
			unset ($plugin_ico['one_col_bg']);
			HD::save_items('plugin_ico', $plugin_ico);
			return ActionFactory::invalidate_folders(array('search_screen'), 
			ActionFactory::show_title_dialog('Бекграунд удален',null,"Для применения изменений выйдите из плагина, нажмите кнопку POPUP и выберите 'Обновить'.",800,1));
		}
		
		if ($user_input->control_id == 'popup_menu')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			
			$menu_items[] = array(
				GuiMenuItemDef::caption => 'Задать бекграунд',
				GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'add_vod_list_bg'),
				GuiMenuItemDef::icon_url => 'gui_skin://small_icons/photo_viewer.aai'
			);
			$plugin_ico = HD::get_items('plugin_ico');
			if (isset($plugin_ico['one_col_bg'])){
				$menu_items[] = array(
					GuiMenuItemDef::caption => 'Удалить бекграунд',
					GuiMenuItemDef::action => UserInputHandlerRegistry::create_action($this, 'del_vod_list_bg'),
					GuiMenuItemDef::icon_url => 'gui_skin://special_icons/off.aai'
				);
			}
            return ActionFactory::show_popup_menu($menu_items);
        }
		
        return null;
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_all_folder_items(MediaURL $media_url, &$plugin_cookies)
    {
        $this->vod->folder_entered($media_url, $plugin_cookies);
        $items = array();
		// $domain_name = (HD::get_item('domain_name') !='') ? HD::get_item('domain_name') : 'http://fs.to';
        array_push
        (
            $items,
            array
            (
                PluginRegularFolderItem::caption => '[Новый запрос]',
                PluginRegularFolderItem::view_item_params => array
					(
                        ViewItemParams::icon_path => 'plugin_file://icons/v_search.png',
                        ViewItemParams::item_layout => HALIGN_LEFT,
                        ViewItemParams::icon_valign => VALIGN_CENTER,
                        ViewItemParams::icon_dx => 20,
                        ViewItemParams::icon_dy => -5,
                        ViewItemParams::item_caption_font_size => FONT_SIZE_NORMAL,
                        ViewItemParams::item_caption_width => 1100
                    ),
                PluginRegularFolderItem::media_url => $this->vod->get_search_media_url_str('search', 'video')
            )
        );
		// if ($domain_name == 'http://fs.to')
		// array_push
        // (
            // $items,
            // array
            // (
                // PluginRegularFolderItem::caption => '[Новый запрос аудио]',
                // PluginRegularFolderItem::view_item_params => array
					// (
                        // ViewItemParams::icon_path => 'plugin_file://icons/a_search.png',
                        // ViewItemParams::item_layout => HALIGN_LEFT,
                        // ViewItemParams::icon_valign => VALIGN_CENTER,
                        // ViewItemParams::icon_dx => 20,
                        // ViewItemParams::icon_dy => -5,
                        // ViewItemParams::item_caption_font_size => FONT_SIZE_NORMAL,
                        // ViewItemParams::item_caption_width => 1100
                    // ),
                // PluginRegularFolderItem::media_url => $this->vod->get_search_media_url_str('search', 'audio')
            // )
        // );
        $search_items = array();
		$search_items = HD::get_items('search_items');
        foreach ($search_items as $item)
        {
            if ($item !== "")
            {
                array_push
                (
                    $items,
                    array
                    (
                        PluginRegularFolderItem::caption => "Поиск: $item",
                        PluginRegularFolderItem::view_item_params =>  array
					(
                        ViewItemParams::icon_path => 'plugin_file://icons/ico_search.png',
                        ViewItemParams::item_layout => HALIGN_LEFT,
                        ViewItemParams::icon_valign => VALIGN_CENTER,
                        ViewItemParams::icon_dx => 20,
                        ViewItemParams::icon_dy => -5,
                        ViewItemParams::item_caption_font_size => FONT_SIZE_NORMAL,
                        ViewItemParams::item_caption_width => 1100
                    ),
                        PluginRegularFolderItem::media_url => $this->vod->get_search_media_url_str($item,'')
                    )
                );
            }
        }
        return $items;
    }

    public function get_archive(MediaURL $media_url)
    {
        return $this->vod->get_archive($media_url);
    }
}

