<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/default_dune_plugin.php';
require_once 'lib/utils.php';
require_once 'lib/tv/tv_group_list_screen.php';
require_once 'lib/tv/tv_favorites_screen.php';
require_once 'lib/vod/vod_list_screen.php';
require_once 'lib/vod/vod_movie_screen.php';
require_once 'lib/vod/vod_series_list_screen.php';
require_once 'lib/vod/vod_season_list_screen.php';
require_once 'lib/vod/vod_favorites_screen.php';
require_once 'lib/vod/vod_history_screen.php';
require_once 'lib/vod/vod_other_screen.php';
require_once 'lib/vod/vod_actor_screen.php';
require_once 'lib/vod/vod_aserials_screen.php';
require_once 'Smart_file_screen.php';
require_once 'Smart_config.php';
require_once 'Smart_entry_handler.php';
require_once 'Smart_tv.php';
require_once 'Smart_vod.php';
require_once 'Smart_setup_screen.php';
require_once 'Smart_search_screen.php';
require_once 'Smart_tv_channel_list_screen.php';
require_once 'Smart_vod_category_list_screen.php';
require_once 'Smart_vod_list_screen.php';
require_once 'Smart_vod_simple_list_screen.php';
///////////////////////////////////////////////////////////////////////////

class SmartPlugin extends DefaultDunePlugin
{
    public function __construct()
    {
		$this->vod = new SmartVod();
		$this->tv = new SmartTv();
		$this->entry_handler = new SmartEntryHandler($this->vod);
		$this->add_screen(new TvGroupListScreen($this->tv,SmartConfig::GET_TV_GROUP_LIST_FOLDER_VIEWS()));
        $this->add_screen(new SmartTvChannelListScreen($this->tv, SmartConfig::GET_TV_CHANNEL_LIST_FOLDER_VIEWS()));
        $this->add_screen(new TvFavoritesScreen($this->tv,SmartConfig::GET_TV_CHANNEL_LIST_FOLDER_VIEWS()));
        $this->add_screen(new SmartSetupScreen());
		$this->add_screen(new SmartFileSystemScreen());
        $this->add_screen(new VodFavoritesScreen($this->vod));
        $this->add_screen(new SmartVodCategoryListScreen($this->vod));
		$this->add_screen(new SmartVodListScreen($this->vod));
        $this->add_screen(new VodMovieScreen($this->vod));
        $this->add_screen(new VodSeriesListScreen($this->vod));
		$this->add_screen(new VodSeasonListScreen($this->vod));
		$this->add_screen(new VodHistoryScreen($this->vod));
		$this->add_screen(new VodOthetScreen($this->vod));
		$this->add_screen(new VodActorScreen($this->vod));
		$this->add_screen(new VodAserialsScreen($this->vod));
		$this->add_screen(new SmartSearchScreen($this->vod));
		$this->add_screen(new SmartVodSimpleListScreen($this->vod));
    }
}

///////////////////////////////////////////////////////////////////////////
?>
