<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/user_input_handler_registry.php';
class SmartEntryHandler
    implements UserInputHandler
{
    private $vod;

    public function __construct($vod)
    {
        $this->vod = $vod;

        UserInputHandlerRegistry::get_instance()->
            register_handler($this);
    }

    public function get_handler_id()
    {
        return 'entry';
    }
	
    public function handle_user_input(&$user_input, &$plugin_cookies)
    {
		$attrs['dialog_params'] = array('frame_style' => DIALOG_FRAME_STYLE_GLASS);
		$start_tv = isset($plugin_cookies->start_tv) ? $plugin_cookies->start_tv : 0;
		if ($user_input->control_id == 'do_login_action')
        {
            if (!isset($user_input->selected_media_url))
                return null;
			if (($user_input->user_login == '' )||
			($user_input->user_pass == '' )||
			($user_input->user_login == 'Введите логин' )||
			($user_input->user_pass == 'Введите пароль' ))
				return ActionFactory::show_title_dialog_gl("Логин или пароль не могут быть пустыми!");
			$login_settings['user_login'] = $user_input->user_login;
			$login_settings['user_pass'] = $user_input->user_pass;
			HD::save_items('login_settings', $login_settings);
			if (SmartConfig::get_login_check() == true){
				if ((HD::get_item('ip_tsproxy') == '')||(HD::get_item('proxy_setup')== 2)){
					$do = UserInputHandlerRegistry::create_action($this, 'additional_settings');
					return ActionFactory::show_title_dialog('Необходима настройка плагина!',$do," Выберите тип прокси! Если используете локальный прокси задайте адрес сервера!",800,1);
				}else
					return ActionFactory::open_folder();
			}else
				return ActionFactory::show_title_dialog('Логин не удался!',null,"Возможно не верный логин и/или пароль",800,1);
        }
		if ($user_input->control_id == 'do_open_setup'){
			return ActionFactory::open_folder(SmartSetupScreen::get_media_url_str(),"Настройки");
		}
		
		if ($user_input->control_id == 'do_soft_reset'){
			return shell_exec('killall shell');
		}
		
		if ($user_input->control_id == 'do_hard_reset'){
			return shell_exec('reboot');
		}
		if ($user_input->control_id == 'open')
        {
			if (isset($user_input->save))
				HD::save_item('end_subscription', $user_input->save);
			if (($start_tv == 0)&&($user_input->etr == 'entry_enter'))
				return ActionFactory::open_folder();
			if (($start_tv == 0)&&($user_input->etr == 'entry_play'))
				return ActionFactory::tv_play();
			if (($start_tv == 1)&&($user_input->etr == 'entry_enter'))
				return ActionFactory::tv_play();
			if (($start_tv == 1)&&($user_input->etr == 'entry_play'))
				return ActionFactory::open_folder();
		}
		if ($user_input->control_id === 'do_ip_tsproxy'){
			
			$arg = $user_input->arg;
			if (($user_input->$arg=='IP локального сервера')||($user_input->$arg=='IP Noxbit сервера')||($user_input->$arg=='IP AceStream сервера')){
				$params['initial_sel_ndx'] = 5;
				$do = UserInputHandlerRegistry::create_action($this, 'additional_settings',$params);
				return ActionFactory::show_title_dialog('IP адрес не задан!',$do,"Задайте IP адрес",800,1);
			}
			if ($arg == 'ip_acestream'){
				$port_acestream = str_replace(array ('http',':','//','(порт по умолчанию)'), '', $user_input->port_acestream);
				$ip_acestream = str_replace(array ('http',':','//',' (Локальный AceStream)'), '', $user_input->$arg);
				if ($ip_acestream == '127.0.0.1')
					$user_input->dune_acestream_ip = 1;
				HD::save_item('dune_acestream_ip'. HD::get_mac_addr(1), $user_input->dune_acestream_ip);
				HD::save_item($arg. HD::get_mac_addr(1), $ip_acestream .':'. $port_acestream);
				$params['etr'] = 'entry_enter';
				$do = UserInputHandlerRegistry::create_action($this, 'open',$params);
				return ActionFactory::show_title_dialog('Адрес локального AceStream сохранен!',$do,$ip_acestream .':'. $port_acestream,800,1);
			}
			
			if (($user_input->port_tsproxy =='')||(preg_match( '|[a-zA-Z]|',$user_input->port_tsproxy))){
				$port_tsproxy = '8081';
				if ($arg == 'ip_noxbit')
					$port_tsproxy = 6689;
			}else
				$port_tsproxy = str_replace(array ('http',':','//','(порт по умолчанию)'), '', $user_input->port_tsproxy);
			$ip_tsproxy = str_replace(array ('http',':','//',' (Локальный Noxbit)'), '', $user_input->$arg);
			if (isset($user_input->dune_noxbit_ip)){
				if ($ip_tsproxy == '127.0.0.1')
					$user_input->dune_noxbit_ip = 1;
				HD::save_item('dune_noxbit_ip'. HD::get_mac_addr(1), $user_input->dune_noxbit_ip);
			}
			if ($arg == 'ip_noxbit')
				HD::save_item($arg. HD::get_mac_addr(1), $ip_tsproxy .':'. $port_tsproxy);
			else
				HD::save_item($user_input->arg, $ip_tsproxy .':'. $port_tsproxy);
			$params['etr'] = 'entry_enter';
			$do = UserInputHandlerRegistry::create_action($this, 'open',$params);
			return ActionFactory::show_title_dialog('Адрес локального прокси сохранен!',$do,"",800,1);
		}
		if ($user_input->control_id === 'proxy_setup'){
			HD::save_item('proxy_setup', $user_input->proxy_setup);
			$params['initial_sel_ndx'] = 0;
			$do_actions = UserInputHandlerRegistry::create_action($this, 'additional_settings',$params);
			return ActionFactory::close_dialog_and_run($do_actions);
		}
		if ($user_input->control_id === 'proxy_arc'){
			HD::save_item('proxy_arc', $user_input->proxy_arc);
			$params['initial_sel_ndx'] = 1;
			$do_actions = UserInputHandlerRegistry::create_action($this, 'additional_settings',$params);
			return ActionFactory::close_dialog_and_run($do_actions);
		}
		if ($user_input->control_id === 'proxy_server'){
			HD::save_item('proxy_server', $user_input->proxy_server);
			$params['initial_sel_ndx'] = 2;
			$do_actions = UserInputHandlerRegistry::create_action($this, 'additional_settings',$params);
			return ActionFactory::close_dialog_and_run($do_actions);
		}
		if ($user_input->control_id === 'use_hls'){
			HD::save_item('use_hls', $user_input->use_hls);
			$params['initial_sel_ndx'] = 3;
			$do_actions = UserInputHandlerRegistry::create_action($this, 'additional_settings',$params);
			return ActionFactory::close_dialog_and_run($do_actions);
		}
		if ($user_input->control_id === 'use_pl'){
			HD::save_item('use_pl', $user_input->use_pl);
			if ($user_input->use_pl = 'favourite')
				HD::save_item('use_fav', 0);
			$params['initial_sel_ndx'] = 4;
			$do_actions = UserInputHandlerRegistry::create_action($this, 'additional_settings',$params);
			$perform_new_action = ActionFactory::close_dialog_and_run($do_actions);
			return ActionFactory::invalidate_folders(array('tv_group_list'), $perform_new_action);
		}
		if ($user_input->control_id === 'use_fav'){
			HD::save_item('use_fav', $user_input->use_fav);
			if (($user_input->use_fav = 1)&&(HD::get_item('use_pl') == 'favourite'))
				HD::save_item('use_pl', 'all');
			$params['initial_sel_ndx'] = 5;
			$do_actions = UserInputHandlerRegistry::create_action($this, 'additional_settings',$params);
			$perform_new_action = ActionFactory::close_dialog_and_run($do_actions);
			return ActionFactory::invalidate_folders(array('tv_group_list', TvFavoritesScreen::get_media_url_str()), $perform_new_action);
		}
		if ($user_input->control_id === 'additional_settings'){
			$defs = array();		
			$proxy_setup = (HD::get_item('proxy_setup') !='') ? HD::get_item('proxy_setup') : 2;
			$proxy_ops[0] = 'HTTP поток с серверного TS-Proxy';
			$proxy_ops[1] = 'HTTP поток с локального TS-Proxy';
			$proxy_ops[4] = 'HTTP поток с proxy AceStream 3.1+';
			$proxy_ops[3] = 'HTTP поток с Noxbit';
			$proxy_ops[2] = 'Выберите';
			ControlFactory::add_combobox($defs, $this, null,
				'proxy_setup',
				'Тип прокси:',
				$proxy_setup, $proxy_ops, 800, true
			);
			$proxy_arc = (HD::get_item('proxy_arc') !='') ? HD::get_item('proxy_arc') : 0;
			$arc_ops[0] = 'Выберите';
			$arc_ops[1] = 'Архив с серверного TS-Proxy';
			$arc_ops[2] = 'Архив с локального TS-Proxy';
			$arc_ops[3] = 'Архив с Ace Stream 3.1+';
			ControlFactory::add_combobox($defs, $this, null,
				'proxy_arc',
				'Прокси для архива:',
				$proxy_arc, $arc_ops, 800, true
			);
			if ($proxy_setup==0){
				$proxy_server = (HD::get_item('proxy_server') !='') ? HD::get_item('proxy_server') : 1;
				$proxy_server_ops = SmartConfig::get_zones();
				ControlFactory::add_combobox($defs, $this, null,
					'proxy_server',
					'Сервер TS-Proxy:',
					$proxy_server, $proxy_server_ops, 800, true
				);
						
				$use_hls = (HD::get_item('use_hls') !='') ? HD::get_item('use_hls') : 1;
				$hls_ops[0] = 'Да';
				$hls_ops[1] = 'Нет';
				ControlFactory::add_combobox($defs, $this, null,
					'use_hls',
					'Использовать HLS:',
					$use_hls, $hls_ops, 800, true
				);
			}		
			$use_pl = (HD::get_item('use_pl') !='') ? HD::get_item('use_pl') : 'all';
			$use_pl_ops['all'] = 'все (кроме избранного)';
			$use_pl_ops['favourite'] = 'избранное Торрент ТВ';
			$use_pl_ops['channel'] = 'каналы';
			$use_pl_ops['moderation'] = 'каналы на модерации';
			$use_pl_ops['translation'] = 'временные трансляции';
						
			ControlFactory::add_combobox($defs, $this, null,
				'use_pl',
				'Использовать плейлист:',
				$use_pl, $use_pl_ops, 800, true
			);		
			$use_fav = (HD::get_item('use_fav') !='') ? HD::get_item('use_fav') : 0;
			$use_fav_ops[0] = 'плагина';
			$use_fav_ops[1] = 'с Торрент ТВ';
			ControlFactory::add_combobox($defs, $this, null,
				'use_fav',
				'Избранное:',
				$use_fav, $use_fav_ops, 800, true
			);
			if ($proxy_setup==1){
				$ip_noxbit = (HD::get_item('ip_noxbit'. HD::get_mac_addr(1)) !='') ? HD::get_item('ip_noxbit'. HD::get_mac_addr(1)) : 'IP Noxbit сервера:6689(порт по умолчанию)';
				$tmp = explode (":", $ip_tsproxy);
				if ($tmp[0] == '')
					$ip = 'IP локального сервера';
				else
					$ip = $tmp[0];
				ControlFactory::add_text_field($defs, $this, $add_params=null,
					'ip_tsproxy',
					'IP локального TS-Proxy:',
					$ip, 1, 0, 0, 1, 800, 0, false
				);
				if ($tmp[1] == '8081')
					$port = '8081(порт по умолчанию)';
				else
					$port = $tmp[1];
				ControlFactory::add_text_field($defs, $this, $add_params=null,
					'port_tsproxy',
					'Порт локального TS-Proxy:',
					$port, 1, 0, 0, 1, 800, 0, false
				);
				$params['arg'] = 'ip_tsproxy';
				$do = UserInputHandlerRegistry::create_action($this, 'do_ip_tsproxy', $params);
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'apply_subscription', 'Применить', 350, $do);
			}
			if ($proxy_setup==3){
				$ip_noxbit = (HD::get_item('ip_noxbit'. HD::get_mac_addr(1)) !='') ? HD::get_item('ip_noxbit'. HD::get_mac_addr(1)) : 'IP Noxbit сервера:6689(порт по умолчанию)';
				$tmp = explode (":", $ip_noxbit);
				if ($tmp[0] == ''){
					if (preg_match('/Noxbit/', file_get_contents('/tmp/run/installed_plugins.xml'))){
						$ip = '127.0.0.1 (Локальный Noxbit)';
						ControlFactory::add_label($defs, '', 'Жмите применить для использования локального Noxbit сервера');
					}else
						$ip = 'IP Noxbit сервера';
				}else
					$ip = $tmp[0];
				ControlFactory::add_text_field($defs, $this, $add_params=null,
					'ip_noxbit',
					'IP Noxbit сервера:',
					$ip, 1, 0, 0, 1, 800, 0, false
				);
				if ($tmp[1] == '6689')
					$port = '6689(порт по умолчанию)';
				else
					$port = $tmp[1];
				ControlFactory::add_text_field($defs, $this, $add_params=null,
					'port_tsproxy',
					'Порт Noxbit сервера:',
					$port, 1, 0, 0, 1, 800, 0, false
				);
				$dune_noxbit_ip = (HD::get_item('dune_noxbit_ip'. HD::get_mac_addr(1)) !='') ? HD::get_item('dune_noxbit_ip'. HD::get_mac_addr(1)) : 0;
				ControlFactory::add_multiline_label($defs, '', "Устройство с Noxbit сервер это Dune HD?", 2);
				$show_ops[0] = 'Нет';
				$show_ops[1] = 'Да';		
				ControlFactory::add_combobox($defs, $this, null,
				'dune_noxbit_ip', '',
				$dune_noxbit_ip, $show_ops, 1150, false, $need_apply = false);
				$params['arg'] = 'ip_noxbit';
				$do = UserInputHandlerRegistry::create_action($this, 'do_ip_tsproxy', $params);
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'apply_subscription', 'Применить', 350, $do);
			}
			if ($proxy_setup==4){
				$ip_acestream = (HD::get_item('ip_acestream'. HD::get_mac_addr(1)) !='') ? HD::get_item('ip_acestream'. HD::get_mac_addr(1)) : 'IP AceStream сервера:6878(порт по умолчанию)';
				$tmp = explode (":", $ip_acestream);
				if ($tmp[0] == ''){
					if (preg_match('|AceStream|', file_get_contents('/tmp/run/installed_plugins.xml'))){
						$ip = '127.0.0.1 (Локальный AceStream)';
						ControlFactory::add_label($defs, 'Жмите применить ', 'локального AceStream сервера');
					}else
						$ip = 'IP AceStream сервера';
				}else{
					if ((($tmp[0] == 'IP AceStream сервера')||($tmp[0] == '127.0.0.1'))&&(preg_match('|AceStream|', file_get_contents('/tmp/run/installed_plugins.xml')))){
						$ip = '127.0.0.1 (Локальный AceStream)';
						ControlFactory::add_label($defs, 'Жмите применить ', 'локального AceStream сервера');
					}else
						$ip = $tmp[0];
				}
				ControlFactory::add_text_field($defs, $this, $add_params=null,
					'ip_acestream',
					'IP AceStream сервера:',
					$ip, 1, 0, 0, 1, 800, 0, false
				);
				if ($tmp[1] == '6878')
					$port = '6878(порт по умолчанию)';
				else
					$port = $tmp[1];
				ControlFactory::add_text_field($defs, $this, $add_params=null,
					'port_acestream',
					'Порт AceStream сервера:',
					$port, 1, 0, 0, 1, 800, 0, false
				);
				$dune_acestream_ip = (HD::get_item('dune_acestream_ip'. HD::get_mac_addr(1)) !='') ? HD::get_item('dune_acestream_ip'. HD::get_mac_addr(1)) : 0;
				ControlFactory::add_multiline_label($defs, '', "Устройство с AceStream сервер это Dune HD?", 2);
				$show_ops[0] = 'Нет';
				$show_ops[1] = 'Да';		
				ControlFactory::add_combobox($defs, $this, null,
				'dune_acestream_ip', '',
				$dune_acestream_ip, $show_ops, 1150, false, false);
				$params['arg'] = 'ip_acestream';
				$do = UserInputHandlerRegistry::create_action($this, 'do_ip_tsproxy', $params);
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'apply_subscription', 'Применить', 350, $do);
			}
			$attrs['initial_sel_ndx'] = isset($user_input->initial_sel_ndx) ? $user_input->initial_sel_ndx : -1;
			return  ActionFactory::show_dialog("Настройки Торрент-ТВ",	$defs, true,1300, $attrs);
		}
		if ($user_input->handler_id == 'entry')
        {
			if (!file_exists(SmartConfig::get_data_path() . '/arc'))
				SmartConfig::arc_copy();
			if ((file_exists(SmartConfig::get_data_path() . '/login_settings'))&&(SmartConfig::get_login_check()==true)){
				$proxy_setup = (HD::get_item('proxy_setup') !='') ? HD::get_item('proxy_setup') : 2;
				$ip_noxbit = (HD::get_item('ip_noxbit'. HD::get_mac_addr(1)) !='') ? HD::get_item('ip_noxbit'. HD::get_mac_addr(1)) : false;
				if (($proxy_setup == 2)||(($proxy_setup == 3)&&($ip_noxbit == false))){
					echo 'wtf!?' ;
					return UserInputHandlerRegistry::create_action($this, 'additional_settings');
				}
				if (HD::get_item('proxy_setup') == 0){
					$end_subscription = (HD::get_item('end_subscription') !='') ? HD::get_item('end_subscription') : '';
					if ($end_subscription<time())
						HD::save_item('end_subscription', '');
					if ($end_subscription ==''){
						$user_info = SmartConfig::get_user_info();
						if ($user_info->tsproxy_access == 0){
							$defs = array();
							ControlFactory::add_multiline_label($defs,'' , "В настройках плагина выбрано Серверный TS-Proxy но доступа к серверному прокси нет!",5);
							$params['etr'] = $user_input->control_id;
							$do = UserInputHandlerRegistry::create_action($this, 'open',$params);
							ControlFactory::add_custom_close_dialog_and_apply_buffon($defs, 'open', 'Далее', 800, $do);
							$do = UserInputHandlerRegistry::create_action($this, 'do_open_setup');
							ControlFactory::add_custom_close_dialog_and_apply_buffon($defs, 'do_open_setup', 'Перейти в настройки', 800, $do);
							return ActionFactory::show_dialog('Доступа к серверному прокси нет!', $defs, true, 800, $attrs);
						}
						if (($user_info->tsproxy_access == 1)&&(($user_info->tsproxy_date - time())<259200)&&($user_info->tsproxy_date > time())){
							$defs = array();
							ControlFactory::add_multiline_label($defs,'' , date("d.m.Y (G:i)", $user_info->tsproxy_date) . " заканчивается подписка на Серверный TS-Proxy.",5);
							$params['etr'] = $user_input->control_id;
							$do = UserInputHandlerRegistry::create_action($this, 'open',$params);
							ControlFactory::add_custom_close_dialog_and_apply_buffon($defs, 'open', 'Далее', 800, $do);
							$params['save'] = $user_info->tsproxy_date;
							$do = UserInputHandlerRegistry::create_action($this, 'open',$params);
							ControlFactory::add_custom_close_dialog_and_apply_buffon($defs, 'run', 'Далее, больше не напоминать', 800, $do);
							return ActionFactory::show_dialog('Заканчивается подписка!', $defs, true, 800, $attrs);
						}
					}
				}
				if (($proxy_setup == 3)&&($ip_noxbit != false)&&
				((HD::get_item('dune_noxbit_ip'. HD::get_mac_addr(1)) !='') ? HD::get_item('dune_noxbit_ip'. HD::get_mac_addr(1)) : 0 == 1)){
					$tmp = explode (":", $ip_noxbit);
					$q = file_get_contents ("http://".$tmp[0]."/cgi-bin/plugins/Noxbit/service_api?cmd=noxbit_status");
					if (preg_match("|Service not running|",$q)){
						$q = file_get_contents ("http://".$tmp[0]."/cgi-bin/plugins/Noxbit/service_api?cmd=noxbit_start");
						if (!preg_match("|Starting NOXBIT\:Ok|",$q)){
							$params['etr'] = $user_input->control_id;
							$do = UserInputHandlerRegistry::create_action($this, 'open',$params);
							return ActionFactory::show_title_dialog('Err!',$do,$q,800,1);
						}
							
					}
						
				}	
				if (($start_tv == 0)&&($user_input->control_id == 'entry_enter'))
					return ActionFactory::open_folder();
				if (($start_tv == 0)&&($user_input->control_id == 'entry_play'))
					return ActionFactory::tv_play();
				if (($start_tv == 1)&&($user_input->control_id == 'entry_enter'))
					return ActionFactory::tv_play();
				if (($start_tv == 1)&&($user_input->control_id == 'entry_play'))
					return ActionFactory::open_folder();
			}else{
				$defs = array();
				$login_settings = HD::get_items('login_settings');
				$user_login = isset($login_settings['user_login']) ? $login_settings['user_login'] : 'Введите логин';
				$user_pass = isset($login_settings['user_pass']) ? $login_settings['user_pass'] : 'Введите пароль';
				if ($user_pass == 'Введите пароль')
					$p = 0;
				else
					$p = 1;
				
				ControlFactory::add_multiline_label($defs,'' ,'Логин на Торрент-ТВ необходим для получения плейлиста.',6);
				ControlFactory::add_text_field($defs, $this, $add_params=null,
						'user_login',
						'',
						$user_login, 0, 0, 0, 1, 950, 0, false
				);
				ControlFactory::add_text_field($defs, $this, $add_params=null,
						'user_pass',
						'',
						$user_pass, 0, $p, 0, 1, 950, 0, false
				);
				ControlFactory::add_label($defs, '', '');
				$do_new_login_action = UserInputHandlerRegistry::create_action($this, 'do_login_action');
				ControlFactory::add_custom_close_dialog_and_apply_buffon($defs,'apply_subscription', 'Применить', 350, $do_new_login_action);
				return ActionFactory::show_dialog("Логин и пароль Торрент-ТВ", $defs, true,1100,$attrs);
			}
		}
		
    }
}

///////////////////////////////////////////////////////////////////////////
?>
