<?php
define('HOST_API_URL','http://tapitv.com');
class SmartConfig
{
    const VOD_MOVIE_PAGE_SUPPORTED = true;
    const VOD_FAVORITES_SUPPORTED  = true;
    const TV_FAVORITES_SUPPORTED   = true;
    const USE_M3U_FILE = false;
    const CHANNEL_SORT_FUNC_CB = 'SmartConfig::sort_channels_cb';

    ///////////////////////////////////////////////////////////////////////
    // How to sort IPTV-channels.

    public static function sort_channels_cb($a, $b)
    {
        // Sort by channel numbers.
        return strnatcasecmp($a->get_number(), $b->get_number());

        // Other options:
        // return strnatcasecmp($a->get_title(), $b->get_title());
    }
	
	public static function get_data_path() {
		static $link = null;
		if (is_null($link))
			{
				$link = DuneSystem::$properties['data_dir_path'];
						if (file_exists($link . '/data_dir_path')){
							$link = smbtree::get_folder_info ('data_dir_path');
						}
			}
		return $link;
	}
	
	public static function get_menu() {

		$m['ch_arc']	= array (
				'caption'	=>	'Архивы каналов', 
				'mUrl'		=>	SmartVodSimpleListScreen::get_media_url_str('ch_arc'),
				'img'		=>	self::get_plugin_ico('ch_arc')
			);
		$m['film_genres']	= array (
				'caption'	=>	'Стримотека', 
				'mUrl'		=>	SmartVodCategoryListScreen::get_media_url_str('film_genres'),
				'img'		=>	self::get_plugin_ico('film_genres')
			);
		$dload_list = HD::get_items('dload_list');
		if ((file_exists('/ltu/bin/aria2c'))&&(count($dload_list)>0))
		$m['d_load'] = array (
				'caption' => 'Закачки', 
				'mUrl' => SurfaceDloadScreen::get_media_url_str()
			);
		return $m;
    }
	
	public static function get_main_categories($category_id) {
		
		$categories['Избранное'] ='vod_favorites';
		$categories['Поиск'] ='search_screen';
		$categories['История просмотра'] ='vod_history';
		// $categories['Все'] ='all';
		$categories['Фильмы'] ='film';
		$categories['Сериалы'] ='serial';
		$categories['Мультфильмы'] ='animation';
		// $categories['Последние'] ='last_added';
		// $categories['Популярное за месяц'] ='specific_monthtop';
		// $categories['HD фильмы'] ='specific_hd';
		// $categories['FullHD фильмы'] ='specific_1080';
		// $categories['Фильмы HD 4k'] ='specific_4k';
		// $categories['Фильмы в 3D'] ='specific_3d';
		return $categories;
    }
	
	public static function get_main_subcategories($subcategory_id, $category_id)
    {
		$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/film_alt_genres.php?session=".self::get_login_check()));
		if ($jsd->success == 0)
			$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/film_alt_genres.php?session=".self::get_login_check(true)));
		if ($subcategory_id=='film')$q =0;
		if ($subcategory_id=='serial')$q = 1;
		if ($subcategory_id=='animation')$q = 2;
		if (isset ($jsd->data[$q]->genres))
			foreach ($jsd->data[$q]->genres as $v)
				if (isset( $v->query->genre_id))
					$categories [$v->name] = $v->query->genre_id;
		return $categories;
    }
	
	public static function get_plugin_ico($ico) {
		$default_ico = array (
		'tv_group_list'				=> 'plugin_file://icons/tv.png',
		'vod_favorites'				=> 'plugin_file://icons/vod_favorites.png',
		'tv_favorites'				=> 'plugin_file://icons/fav.png',
		'__all_channels'			=> 'plugin_file://icons/all.png',
		'ch_arc'					=> 'plugin_file://icons/ch_arc.png',
		'film_genres'				=> 'plugin_file://icons/film_genres.png',
		'search_screen'				=> 'plugin_file://icons/find.png',
		'category_bg'				=> 'gui_skin://images/bg.jpg',
		'tv_group_bg'				=> 'gui_skin://images/bg.jpg',
		'channel_list_bg'			=> 'gui_skin://images/bg.jpg',
		'vod_list_bg'				=> 'gui_skin://images/bg.jpg',
		'season_list_bg'			=> 'gui_skin://images/bg.jpg',
		'series_list_bg'			=> 'gui_skin://images/bg.jpg',
		'one_col_bg'				=> 'gui_skin://images/bg.jpg',
		'category_sandwich_base'	=> 'gui_skin://special_icons/sandwich_base.aai',
		'channel_sandwich_base'		=> 'gui_skin://special_icons/sandwich_base.aai',
		'sandwich_cover'			=> 'cut_icon://{name=sandwich_cover}'
		);
		$plugin_ico = HD::get_items('plugin_ico');
			if (isset($plugin_ico[$ico]))
				$link = $plugin_ico[$ico];
			else if (file_exists( DuneSystem::$properties['install_dir_path'] ."/icons/$ico.png"))
				$link = "plugin_file://icons/$ico.png";
			else if (file_exists(self::get_data_path() ."/icons/$ico.png"))
				$link = self::get_data_path() . "/icons/$ico.png";
			else if (isset( $default_ico[$ico]))
				$link = $default_ico[$ico];
			else
				$link = 'gui_skin://special_icons/sandwich_base.aai';
		return $link;
	}

	public static function get_login_check($reset=null) {
		static $session = '';
		$q = false;
		if (!preg_match("/persistfs|flashdata/",self::get_data_path())){
			$session = HD::get_item('session');
			$q = true;
		}	
		if ($reset==true)
			$session = null;
		if ($session==''){
			$login_settings = HD::get_items('login_settings');
			$user_login = urlencode (isset($login_settings['user_login']) ? $login_settings['user_login'] : '');
			$user_pass =  urlencode (isset($login_settings['user_pass']) ? $login_settings['user_pass'] : '');
			if ($user_login != ''){
				$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/auth.php?username=$user_login&password=$user_pass&application=tsproxy&guid=dune"));
				if ($jsd->success == 1)
					$session = $jsd->session;
				else
					echo "ERR:". $jsd->error;
			}
		}
		if ($q == true)
			HD::save_item('session', $session);
		return $session;
    }
	
	public static function arc_copy() {
		$file = DuneSystem::$properties['install_dir_path'].'/lib/arc';
		if (!copy($file, self::get_data_path() . '/arc'))
			echo "не удалось скопировать $file...\n";
    }
	
	public static function arc_list() {
		$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/arc_list.php?session=".self::get_login_check()));
		if ($jsd->success == 0)
			$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/arc_list.php?session=".self::get_login_check(true)));
			foreach ($jsd->channels as $v)
				$arcs [$v->id] = $v->epg_id;
		return $arcs;
    }
	
	public static function check_arc($id) {
		$arc = HD::get_items('arc');
		if (isset($arc[$id]))
			return true;
		else
			return false;
    }
	
	public static function getVideoList($category_id, $genre_id, &$m_feed) {
		if ($m_feed === '_end_')
			return array();
		if ($category_id == 'all')
			$genre = '&new';
		else if ($category_id == 'serials')
			$genre = '&serials';
		else if ($category_id == 'last_added')
			$genre = '&last_added';
		else if ($category_id == 'specific_monthtop')
			$genre = '&specific=monthtop';
		else if ($category_id == 'specific_hd')
			$genre = '&specific=hd';
		else if ($category_id == 'specific_1080')
			$genre = '&specific=1080';
		else if ($category_id == 'specific_4k')
			$genre = '&specific=4k';
		else if ($category_id == 'specific_3d')
			$genre = '&specific=3d';
		else
			$genre = "&genre=$category_id";
		if (($genre_id ==='film')||($genre_id ==='serial')||($genre_id ==='animation')){
			$page = $m_feed*10;
			$info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/film_alt_list.php?session=".self::get_login_check()."&genre_id=$category_id&type=$genre_id&skip=$page"));
			if ($info->success == 0)
				$info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/film_list.php?session=".self::get_login_check(true)."&genre_id=$category_id&type=$genre_id&skip=$page"));
			if (count($info->data)==0)
				return array();
			else
				++$m_feed;
		}else{
			$page = $m_feed+1;
			$info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/film_list.php?session=".self::get_login_check()."$genre&page=$page"));
			if ($info->success == 0)
				$info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/film_list.php?session=".self::get_login_check(true)."$genre&page=$page"));
			if (!isset($info->data->films))
				return array();
			else if ($info->data->total_pages==$page)
				$m_feed = '_end_';
			else
				++$m_feed;
		}
		
		return self::do_parse_page($info, $genre_id);
	}
	
	public static function getSearchList($genre_id, $category, &$m_feed) {
		$page = $m_feed+1;
			$info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/film_alt_search.php?session=".self::get_login_check()."&q=$genre_id&skip=$page"));
			if ($info->success == 0)
				$info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/film_alt_search.php?session=".self::get_login_check(true)."&q=$genre_id&skip=$page"));
			if (count($info->data)==0)
				return array();
			else
				++$m_feed;
		return self::do_parse_page($info, $genre_id);
	}
	
	public static function do_parse_page($info, $genre_id=null){
        $items = array();
		if (isset($info->data->films))
			$data = $info->data->films;
		else
			$data = $info->data;
		
		foreach ($data as $v){
			if (isset($v->name))
				$name = HD::str_remove_tag($v->name);
			if (isset($v->img))
				$img = 'http://mdb.ttvrun.one/media/' . $v->img;
			if (isset($v->poster))
				$img = $v->poster;
			$movie = new ShortMovie(
					strval($v->id),
					strval($name),
					strval($img),
					strval(false)
			);
			$info = $name . '|';
			if (isset($v->kp_rating))
				$info .= 'Кинопоиск:' . $v->kp_rating . '|';
			if (isset($v->kp_rating))
				$info .= 'IMDB:' . $v->imdb_rating;
			$movie->info = $info;
			array_push ($items, $movie);
		}
        return $items;
    }
	public static function parse_video_page($video_id, $kp_id, $m_name, $plugin_cookies){
		$show_coment = isset($plugin_cookies->show_coment) ? $plugin_cookies->show_coment : 'yes';
		
		$caption = $relap = $actors = $description = $poster_url = $caption_original = $length = $rate_mpaa = $deliverys =	$year = 
		$genres = $country = $director = $scenario = $rate_imdb = $budget = $year2 = $other_link=$rate_kinopoisk = ''; 
		$other_link = $series = $entity_link = array();
		$rate_details = $details = $images = $jsd_info = $poxog = $urls = false;
		
		if ($kp_id == 'ch_arc'){
			$kp_id =false;
			$caption = $m_name;
			$poster_url = 'plugin_file://icons/logo.png';
			$d = 0;
			while($d <= 15){
				$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/arc_records.php?session=".self::get_login_check()."&epg_id=$video_id&date=".date("j-n-Y",time()-86400*$d)));
					if ($jsd->success == 0)
						break;
				foreach ($jsd->records as $v){
					$s[$v->time]['n']=str_replace('"', "'",$v->name) . ' ('.date("d.m.Y (G:i)",$v->time).')';
					$s[$v->time]['r']= $v->record_id;
				}
				$d++;
			}
			ksort($s);
			
			foreach (array_reverse($s) as $v)
				$series[$v['n']] = $v['r'];
			
		}else{
			$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/film_info.php?session=".self::get_login_check()."&film_id=$video_id"));
			if ($jsd->success == 0)
				$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/film_info.php?session=".self::get_login_check(true)."&film_id=$video_id"));
			if (isset ($jsd->film->info->rus_name))
				$caption = HD::str_remove_tag($jsd->film->info->rus_name);
			if (isset ($jsd->film->info->orig_name))
				$caption_original = $jsd->film->info->orig_name;
			if (isset ($jsd->film->description))
				$description = $jsd->film->description;
			if (isset ($jsd->film->info->year))
				$year = $jsd->film->info->year;
			if (isset ($jsd->film->genres))
				foreach ($jsd->film->genres as $v)
					$genres .= $v->name.', ';
			if (isset ($jsd->film->attributes->{'страна'}))
				$country = $jsd->film->attributes->{'страна'};
			if (isset ($jsd->film->rating->imdb->rating))
				$rate_imdb = $jsd->film->rating->imdb->rating;
			if (isset ($jsd->film->rating->kp->rating))
				$rate_kinopoisk = $jsd->film->rating->kp->rating;
			if (isset ($jsd->film->rating->ttv->rating))
				$rate_details["TTV:"] = $jsd->film->rating->ttv->rating;
			if (isset ($jsd->film->attributes->{'время'})){
				$length = $jsd->film->attributes->{'время'};
				if (preg_match("/(\d*):(\d\d)/i", $length, $tmp))
					$length = ($tmp[1]*60+$tmp[2]);
			}
				
			if (isset ($jsd->film->persons->directors)){
				if (count($jsd->film->persons->directors) == 1){
					if (isset($jsd->film->persons->directors[0]->name))
						$director = $jsd->film->persons->directors[0]->name;
					else
						$director = $jsd->film->persons->directors;
				}else
					foreach ($jsd->film->persons->directors as $v)
						$director .= $v->name . ', ';
			}
			if (isset ($jsd->film->persons->writers)){
				if (count(($jsd->film->persons->writers) == 1)){
					if (isset($jsd->film->persons->writers[0]->name))
						$scenario = $jsd->film->persons->writers[0]->name;
					else
						$scenario = $jsd->film->persons->writers;
				}else
					foreach ($jsd->film->persons->writers as $v)
						$scenario .= $v->name . ', ';
			}					
			if (isset ($jsd->film->attributes->{'слоган'}))
				$details["Слоган:"] = wordwrap($jsd->film->attributes->{'слоган'}, 70, "\n");
			if (isset ($jsd->film->attributes->{'бюджет'}))
				$budget = str_replace(array ('$', ' '),"", $jsd->film->attributes->{'бюджет'});
			if (isset ($jsd->film->attributes->{'сборы в США'}))
				$details["Сборы USA:"] = wordwrap($jsd->film->attributes->{'сборы в США'}, 70, "\n");
			if (isset ($jsd->film->attributes->{'сборы в мире'}))
				$details["Сборы мир:"] = wordwrap($jsd->film->attributes->{'сборы в мире'}, 70, "\n");
			if (isset ($jsd->film->attributes->{'сборы в России'}))
				$details["Сборы Ru:"] = wordwrap($jsd->film->attributes->{'сборы в России'}, 70, "\n");
			if (isset ($jsd->film->attributes->{'DVD в США'}))
				$details["DVD в США:"] = wordwrap($jsd->film->attributes->{'DVD в США'}, 70, "\n");
			if (isset ($jsd->film->attributes->{'зрители'}))
				$details["Зрители:"] = wordwrap($jsd->film->attributes->{'зрители'}, 70, "\n");	
			if (isset ($jsd->film->attributes->{'премьера (мир)'}))
				$details["Премьера мир:"] = wordwrap($jsd->film->attributes->{'премьера (мир)'}, 70, "\n");
			if (isset ($jsd->film->attributes->{'премьера (РФ)'}))
				$details["Премьера RU:"] = wordwrap($jsd->film->attributes->{'премьера (РФ)'}, 70, "\n");
			if (isset ($jsd->film->attributes->{'релиз на DVD'}))
				$details["Релиз DVD:"] = wordwrap($jsd->film->attributes->{'релиз на DVD'}, 70, "\n");
			if (isset ($jsd->film->attributes->{'релиз на Blu-Ray'}))
				$details["Релиз BD:"] = wordwrap($jsd->film->attributes->{'релиз на Blu-Ray'}, 70, "\n");	
			if (isset ($jsd->film->attributes->{'возраст'}))
				$details["Возраст:"] = wordwrap($jsd->film->attributes->{'возраст'}, 70, "\n");
			if (isset ($jsd->film->attributes->{'рейтинг MPAA'}))
				$details["Рейтинг MPAA:"] = wordwrap($jsd->film->attributes->{'рейтинг MPAA'}, 70, "\n");
				
			$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/film_posters.php?session=".self::get_login_check()."&film_id=$video_id"));
			if ($jsd->success == 0)
				$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/film_posters.php?session=".self::get_login_check(true)."&film_id=$video_id"));
			if (isset ($jsd->film->data[0]))
				$poster_url =  $jsd->film->data[0];
			
			$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/film_alt_http.php?session=".self::get_login_check()."&film_id=$video_id"));
			if ($jsd->success == 0)
				$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/film_alt_http.php?session=".self::get_login_check(true)."&film_id=$video_id"));
			foreach ($jsd->data as $v)
				$series[$v->name] = $v->url;
		}
		$movie = new Movie($video_id);
		$movie->set_data(
            $caption,
            $caption_original,
            $description,
            $poster_url,
            $length,
            $year,
            $director,
            $scenario,
            $actors,
            $genres,
            $rate_imdb,
            $rate_kinopoisk,
            $rate_mpaa,
            $country,
            $budget,
			$rate_details,
			$details,
			$images,
			$relap,
			$entity_link,
			$other_link,
			$poxog,
			$kp_id,
			$urls
		);

		$i=1;
		if ($images==true)
		foreach ($images as $v){
			$series['Screenshot - '.$i] = $v;
			$i++;
		}
		foreach ($series as $k => $v){
			$movie->add_series_data(
			$video_id,
			$k,
			$poster_url,
			$v,
			false);
		}

		return $movie;
	}
	
	public static function parse_season_page($video_id, $season_id, $movie, $plugin_cookies){	
		$d = 1;
		$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/arc_records.php?session=".self::get_login_check()."&epg_id=$video_id&date=".date("j-n-Y",time()-86400*$d)));
			if ($jsd->success == 0)
				$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/arc_records.php?session=".self::get_login_check(true)."&epg_id=$video_id&date=".date("j-n-Y",time()-86400*$d)));
		foreach ($jsd->records as $v){
			// $jsds = json_decode(HD::http_get_document(HOST_API_URL . "/v3/arc_screen.php?session=".self::get_login_check()."&record_id=".$v->record_id."&count=1"));
			// if ($jsds->success == 0)
				// $jsds = json_decode(HD::http_get_document(HOST_API_URL . "/v3/arc_screen.php?session=".self::get_login_check(true)."&record_id=".$v->record_id."&count=1"));
			
			$movie->add_series_data(
				$video_id,
				$v->name,
				'',//$eImg,
				$v->record_id,
				false,
				$season_id,
				'',
				'',
				$v->name.'|');
		}
		return $movie;
	}
	
	public static function update_arc($arc_itm, $channel_id) {
		$arc = HD::get_items('arc');
		if (($arc_itm == true)&& (!isset($arc[$channel_id]))){
			$arc[$channel_id] = 1;
			HD::save_items('arc', $arc);
			echo 'update_arc';
		}
		if (($arc_itm == false)&& (isset($arc[$channel_id]))){
			unset ($arc[$channel_id]);
			HD::save_items('arc', $arc);
			echo 'update_arc';
		}
    }
	
	public static function get_playlist() {
		$use_pl = (HD::get_item('use_pl') !='') ? HD::get_item('use_pl') : 'all';
		$playlist = json_decode(HD::http_get_document(HOST_API_URL . "/v3/translation_list.php?session=".self::get_login_check()."&type=$use_pl"));
		if ($playlist->success == 0)
			$playlist = json_decode(HD::http_get_document(HOST_API_URL . "/v3/translation_list.php?session=".self::get_login_check(true)."&type=$use_pl"));
		return ($playlist);
    }
	
	public static function get_ttv_fav() {
		$fav = array();
		$use_pl = (HD::get_item('use_pl') !='') ? HD::get_item('use_pl') : 'all';
		$playlist = json_decode(HD::http_get_document(HOST_API_URL . "/v3/translation_list.php?session=".self::get_login_check()."&type=favourite"));
		if ($playlist->success == 0)
			$playlist = json_decode(HD::http_get_document(HOST_API_URL . "/v3/translation_list.php?session=".self::get_login_check(true)."&type=favourite"));
		foreach ($playlist->channels as $tv_channel)
			$fav[] = $tv_channel->id;
		return ($fav);
    }
	
	public static function get_user_info() {

		$user_info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/userinfo.php?session=".self::get_login_check()));
		if ($user_info->success == 0)
			$user_info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/userinfo.php?session=".self::get_login_check(true)));
		return ($user_info);
    }
	public static function getChArcList() {

		$items = array();
		$info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/arc_list.php?session=".self::get_login_check()));
		if ($info->success == 0)
			$info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/arc_list.php?session=".self::get_login_check(true)));
		foreach ($info->channels as $v){
			$name = HD::str_remove_tag($v->name);
			$movie = new ShortMovie(
					strval($v->epg_id),
					strval($v->name),
					strval('http://ttvrun.one/uploads/'.$v->logo),
					strval(false)
			);
			$movie->info = $v->name . '|';
			array_push ($items, $movie);
		}
        return $items;
    }
	public static function get_arc_list_info() {

		$user_info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/arc_list.php?session=".self::get_login_check()));
		if ($user_info->success == 0)
			$user_info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/arc_list.php?session=".self::get_login_check(true)));
		return ($user_info);
    }
	
	public static function ttv_fav($id,$arg) {

		$info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/$arg.php?session=".self::get_login_check(). "&channel_id=" . $id));
		if ($info->success == 0)
			$info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/$arg.php?session=".self::get_login_check(true). "&channel_id=" . $id));
		return ($info);
    }
	
	public static function ttv_fav_nbr($id,$arg) {

		$info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/favourite_set_position.php?session=".self::get_login_check(). "&channel_id=" . $id . "&position=" .$arg));
		if ($info->success == 0)
			$info = json_decode(HD::http_get_document(HOST_API_URL . "/v3/favourite_set_position.php?session=".self::get_login_check(true). "&channel_id=" . $id . "&position=" .$arg));
		return ($info);
    }
	
	public static function get_zones() {
		$z = json_decode(HD::http_get_document(HOST_API_URL . "/v3/get_zones.php?session=".self::get_login_check()."&typeresult=json"));
		if ($z->success==1){
			foreach ($z->data as $v)
				$zones[$v->id]=$v->name;
		}else{
			$z = json_decode(HD::http_get_document(HOST_API_URL . "/v3/get_zones.php?session=".self::get_login_check(true)."&typeresult=json"));
			if ($z->success==1){
				foreach ($z->data as $v)
					$zones[$v->id]=$v->name;
			}else
				$zones['Err']='Log in Err';
		}
			
		return ($zones);
    }
	
	public static function get_stream($id, $arc=null) {
		$proxy_server = (HD::get_item('proxy_server') !='') ? HD::get_item('proxy_server') : 1;
		$use_hls = (HD::get_item('use_hls') !='') ? HD::get_item('use_hls') : 1;
		if ($arc == true)
			$use_hls = 0;
		$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/translation_http.php?session=" . self::get_login_check() . "&channel_id=" . $id . "&zone_id=" . $proxy_server . "&nohls=" . $use_hls));
		if ($jsd->success == 1)
			return $jsd->source;
		else{
			$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/translation_http.php?session=" . self::get_login_check(true) . "&channel_id=" . $id . "&zone_id=" . $proxy_server . "&nohls=" . $use_hls));
			if ($jsd->success == 1)
				return $jsd->source;
			else
				return DuneSystem::$properties['install_dir_path'].'/icons/nostream.png';
		}
    }
	public static function get_noxbit_cid($id) {
		$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/get_noxbit_cid.php?session=" . self::get_login_check() . "&channel_id=" . $id));
		if ($jsd->success == 1)
			return $jsd->cid;
		else{
			$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/get_noxbit_cid.php?session=" . self::get_login_check(true) . "&channel_id=" . $id ));
			if ($jsd->success == 1)
				return $jsd->cid;
			else
				return false;
		}
    }
	public static function get_acestream_url($id, $arc = null) {
		$dune_acestream = null;
		$acestream_ip = (HD::get_item('ip_acestream'. HD::get_mac_addr(1)) !='') ? HD::get_item('ip_acestream'. HD::get_mac_addr(1)) : '';
		if (is_null($dune_acestream)){
			if ($acestream_ip != ''){
				$dune_acestream_ip = (HD::get_item('dune_acestream_ip'. HD::get_mac_addr(1)) !='') ? HD::get_item('dune_acestream_ip'. HD::get_mac_addr(1)) : 0;
				$q = false;
				hd_silence_warnings();
				$q = file_get_contents ("http://$acestream_ip/webui/api/service?method=get_version&format=jsonp&callback=");
				hd_restore_warnings();
				if ($q== false){
					if ($dune_acestream_ip == 1){
						$tmp = explode (":", $acestream_ip);
						$start = file_get_contents ("http://".$tmp[0]."/cgi-bin/plugins/AceStream/service_api?cmd=acestream_start");
						if (trim($start) == 'Ace Stream started!'){
							$dune_acestream = 1;
							echo "Ace Stream started:". $acestream_ip;
						}else{
							echo "!Not Started Dune Ace Stream err:". $acestream_ip;
							return 'http://mp4://dune-club.info/plugins/update/1.mp4';
						}
					}else{
						echo "!Not Started Ace Stream err:". $acestream_ip;
						return 'http://mp4://dune-club.info/plugins/update/1.mp4';
					}
				}
			}
		}
		if ($arc == false)
			$jUrl = HOST_API_URL . "/v3/translation_stream.php?session=" . self::get_login_check() . "&channel_id=" . $id;
		else
			$jUrl = HOST_API_URL . "/v3/arc_stream.php?session=" . self::get_login_check() . "&record_id=" . $id;
		$jsd = json_decode(HD::http_get_document($jUrl));
		if ($jsd->success == 1)
			$url = $jsd->source;
		else{
			if ((isset($jsd->error))&&($jsd->error == 'novip'))
				return 'http://mp4://dune-club.info/plugins/update/1.mp4';
			else if (isset($jsd->error))
				print_r ($jsd);
			$jsd = json_decode(HD::http_get_document($jUrl));
			if ($jsd->success == 1)
				$url = $jsd->source;
			else
				return false;
		}
		return  "http://ts://$acestream_ip/ace/getstream?url=" . $url;
    }
	public static function get_arcstream($record_id) {
		
		$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/arc_http.php?session=".self::get_login_check()."&record_id=".$record_id));
		if ($jsd->success == 1)
			return $jsd->source;
		else{
			$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/arc_http.php?session=".self::get_login_check(true)."&record_id=".$record_id));
			if ($jsd->success == 1)
				return $jsd->source;
			else
				return DuneSystem::$properties['install_dir_path'].'/icons/nostream.png';
		}
    }
	
	public static function get_info($id){
		static $get_info = null;
		if ((is_null($get_info))||(!isset($get_info[$id]))){
			$jsd = VideoInfo::gm_id_info($id);
			$get_info[$id] = $jsd;
		}else
			$jsd =  $get_info[$id];
		return ($jsd);
	}
	
	public static function get_day_epg($id, $day_start_ts) {
		$e = $day_start_ts+86400;
		$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/translation_epg.php?session=".self::get_login_check()."&btime=$day_start_ts&epg_id=$id&etime=".$e));
		if ($jsd->success == 1)
			return $jsd->data;
		else{
			$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/translation_epg.php?session=".self::get_login_check(true)."&btime=$day_start_ts&epg_id=$id&etime=".$e));
			if ($jsd->success == 1)
				return $jsd->data;
			else
				return false;
		}
    }
	public static function get_group_day_epg($groupId, $id, $day_start_ts) {
		static $group_epg = null;
		if ((is_null($group_epg))||(!isset($group_epg[$groupId]))){
			$e = $day_start_ts+86400;
			$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/translation_epg_category.php?session=".self::get_login_check()."&btime=$day_start_ts&category_id=$groupId&etime=".$e));
			if ($jsd->success == 1)
				$group_epg[$groupId] = $jsd->data;
			else{
				$jsd = json_decode(HD::http_get_document(HOST_API_URL . "/v3/translation_epg_category.php?session=".self::get_login_check(true)."&btime=$day_start_ts&category_id=$groupId&etime=".$e));
				if ($jsd->success == 1)
					$group_epg[$groupId] = $jsd->data;
				else
					return false;
			}
		}
		if (isset($group_epg[$groupId]->$id))
			return ($group_epg[$groupId]->$id);
		else
			return false;
    }
    ///////////////////////////////////////////////////////////////////////
    // Folder views.

    public static function GET_TV_GROUP_LIST_FOLDER_VIEWS()
    {
        return array(
			//0
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 4,
                    ViewParams::paint_details => true,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('category_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('tv_group_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			// 1) 170*98 1x5
			array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 1,
                    ViewParams::num_rows => 5,
                    ViewParams::paint_details => true,
                    ViewParams::zoom_detailed_icon => false,
					ViewParams::item_width => 170,
                    ViewParams::item_height => 98,
					ViewParams::background_path=> self::get_plugin_ico('tv_group_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
					
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
    		    ViewItemParams::item_paint_icon => true,
    		    ViewItemParams::item_layout => HALIGN_LEFT,
    		    ViewItemParams::icon_valign => VALIGN_CENTER,
    		    ViewItemParams::icon_dx => 10,
    		    ViewItemParams::icon_dy => -5,
				ViewItemParams::icon_width => 170,
				ViewItemParams::icon_height => 98,
    		    ViewItemParams::item_caption_font_size => FONT_SIZE_NORMAL,
    		    ViewItemParams::item_caption_width => 950,
				ViewItemParams::icon_scale_factor => 1.0,
                ViewItemParams::icon_sel_scale_factor => 1.2,

                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),

			//2
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => true,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('category_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('tv_group_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.5,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			
			array
            (
                PluginRegularFolderView::async_icon_loading => true,
 
                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 8,
                    ViewParams::paint_details => false,
					ViewParams::background_path=> self::get_plugin_ico('tv_group_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),
 
                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_LEFT,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::icon_dx => 10,
                    ViewItemParams::icon_dy => -5,
                    ViewItemParams::icon_width => 122,
                    ViewItemParams::icon_height => 70,
                    ViewItemParams::item_caption_width => 385,
                    ViewItemParams::item_caption_font_size => 3,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),
 
                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),   
			// 3) 170*98 4x2
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 2,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('category_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('tv_group_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => true,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.5,
					
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//4) 245x140 5x3
			array
					(
						PluginRegularFolderView::async_icon_loading => false,

						PluginRegularFolderView::view_params => array
						(
							ViewParams::num_cols => 4,
							ViewParams::num_rows => 3,
							ViewParams::paint_icon_selection_box=> true,
							ViewParams::paint_sandwich => true,
							ViewParams::sandwich_base => self::get_plugin_ico('category_sandwich_base'),
							ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
							ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
							ViewParams::paint_path_box => true,
							ViewParams::paint_scrollbar => true,
							ViewParams::paint_help_line => true,
							ViewParams::paint_details => true,
							ViewParams::paint_content_box_background => false,
							ViewParams::background_path=> self::get_plugin_ico('tv_group_bg'),
							ViewParams::background_order => 0,
							ViewParams::background_height => 1080,
							ViewParams::background_width => 1920,
							ViewParams::optimize_full_screen_background => true,
							ViewParams::item_width => 140,
							ViewParams::item_height => 140,
							ViewParams::sandwich_width => 140,
							ViewParams::sandwich_height => 140,
							ViewParams::sandwich_icon_upscale_enabled => true,
							ViewParams::sandwich_icon_keep_aspect_ratio => true
						),

						PluginRegularFolderView::base_view_item_params => array
						(
							ViewItemParams::item_paint_icon => true,
							ViewItemParams::item_layout => HALIGN_CENTER,
							ViewItemParams::icon_valign => VALIGN_CENTER,
							ViewItemParams::item_paint_caption => true,
							ViewItemParams::icon_scale_factor => 1.25,
							ViewItemParams::icon_sel_scale_factor => 1.4,
							ViewItemParams::icon_width => 140,
							ViewItemParams::icon_height => 140,
						),

						PluginRegularFolderView::not_loaded_view_item_params => array ()
					),
			//5) 1x12 84x48
			array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 1,
                    ViewParams::num_rows => 12,
                    ViewParams::paint_details => true,
					ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('category_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
					ViewParams::background_path=> self::get_plugin_ico('tv_group_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_LEFT,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::icon_dx => 10,
                    ViewItemParams::icon_dy => -5,
                    ViewItemParams::icon_width => 84,
                    ViewItemParams::icon_height => 48,
                    ViewItemParams::item_caption_width => 1060,
                    ViewItemParams::item_caption_font_size => 28,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
            //6) 5x4 245x140
			array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 5,
                    ViewParams::num_rows => 4,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('category_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('tv_group_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//7)4x3 245x140
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('category_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('tv_group_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.5,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//8)3x2 245x140
	    array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 2,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('category_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('tv_group_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.75,
                    ViewItemParams::icon_sel_scale_factor => 2,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//9) 3x1 246x246
			array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 5,
                    ViewParams::num_rows => 1,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('category_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
					ViewParams::item_width => 246,
                    ViewParams::item_height => 246,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::paint_icon_selection_box => true,
                    ViewParams::background_path=> self::get_plugin_ico('tv_group_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
                    ViewParams::paint_content_box_background => false,
                    ViewParams::optimize_full_screen_background => true,
					ViewParams::paint_scrollbar => false,
					ViewParams::orientation => 'horizontal',
					ViewParams::cycle_mode_enabled => true,
					ViewParams::paint_path_box => true,
					ViewParams::scroll_animation_enabled => true,
					ViewParams::cycle_mode_gap => 'yes',


                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => VALIGN_CENTER,
                    ViewItemParams::icon_valign => HALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.0,
                    #ViewItemParams::icon_dy => -5,
                    ViewItemParams::icon_width => 246,
                    ViewItemParams::icon_height => 246,
					ViewItemParams::icon_sel_width => 246,
                    ViewItemParams::icon_sel_height => 246,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//10)4x3 180x180
			array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('category_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
					ViewParams::item_width => 180,
                    ViewParams::item_height => 180,
                    ViewParams::sandwich_width => 180,
                    ViewParams::sandwich_height => 180,
					ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
                    ViewParams::paint_path_box => true,
                    ViewParams::background_path=> self::get_plugin_ico('tv_group_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::sandwich_icon_keep_aspect_ratio => true,
                    ViewParams::paint_content_box_background => true,
                    ViewParams::optimize_full_screen_background => true,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => VALIGN_CENTER,
                    ViewItemParams::icon_valign => HALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.0,
                    ViewItemParams::icon_width => 180,
                    ViewItemParams::icon_height => 180,
					ViewItemParams::item_paint_caption => true,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//11)5x3 120x120
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 5,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('category_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
					ViewParams::item_width => 120,
                    ViewParams::item_height => 120,
                    ViewParams::sandwich_width => 120,
                    ViewParams::sandwich_height => 120,
					ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
                    ViewParams::paint_path_box => true,
                    ViewParams::background_path=> self::get_plugin_ico('tv_group_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
                    ViewParams::background_order => 1,
                    ViewParams::paint_content_box_background => true,
                    ViewParams::optimize_full_screen_background => true,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::paint_icon_selection_box => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => VALIGN_CENTER,
                    ViewItemParams::icon_valign => HALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.0,
                    ViewItemParams::icon_width => 120,
                    ViewItemParams::icon_height => 120,
					ViewItemParams::item_paint_caption => true,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//12
			array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 1,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('category_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
					ViewParams::item_width => 246,
                    ViewParams::item_height => 246,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::paint_icon_selection_box => true,
                    ViewParams::background_path=> self::get_plugin_ico('tv_group_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
                    ViewParams::paint_content_box_background => true,
                    ViewParams::optimize_full_screen_background => true,
					ViewParams::paint_scrollbar => false,
					ViewParams::orientation => 'horizontal',
					ViewParams::cycle_mode_enabled => true,
					ViewParams::cycle_mode_gap => 'auto',
					ViewParams::cycle_mode_gap_width => 10,
					ViewParams::paint_path_box => true,
					ViewParams::scroll_animation_enabled => true,
					ViewParams::animation_enabled => true,
					


                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => VALIGN_CENTER,
                    ViewItemParams::icon_valign => HALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.0,
                    #ViewItemParams::icon_dy => -5,
                    ViewItemParams::icon_width => 246,
                    ViewItemParams::icon_height => 246,
					ViewItemParams::icon_sel_width => 246,
                    ViewItemParams::icon_sel_height => 246,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
        );
    }

    public static function GET_TV_CHANNEL_LIST_FOLDER_VIEWS()
    {
        return array(
			
			//0) 1x10 75x55
			array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 1,
                    ViewParams::num_rows => 10,
                    ViewParams::paint_details => true,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
    		    ViewItemParams::item_paint_icon => true,
    		    ViewItemParams::item_layout => HALIGN_LEFT,
    		    ViewItemParams::icon_valign => VALIGN_CENTER,
    		    ViewItemParams::icon_dx => 0,
    		    ViewItemParams::icon_dy => -5,
				ViewItemParams::icon_width => 55,
				ViewItemParams::icon_height => 55,
    		    ViewItemParams::item_caption_font_size => FONT_SIZE_NORMAL,
    		    ViewItemParams::item_caption_width => 1100,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),

			//1) 2x15 75x55
			array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 2,
                    ViewParams::num_rows => 15,
                    ViewParams::paint_details => true,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_LEFT,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::icon_dx => 10,
                    ViewItemParams::icon_dy => -5,
                    ViewItemParams::icon_width => 55,
                    ViewItemParams::icon_height => 55,
                    ViewItemParams::item_caption_width => 485,
                    ViewItemParams::item_caption_font_size => FONT_SIZE_SMALL,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//2) 3x12 45x45
			array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 12,
                    ViewParams::paint_details => false,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_LEFT,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::icon_dx => 10,
                    ViewItemParams::icon_dy => -5,
                    ViewItemParams::icon_width => 45,
                    ViewItemParams::icon_height => 45,
                    ViewItemParams::item_caption_width => 475,
                    ViewItemParams::item_caption_font_size => 3,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			array
            (
                PluginRegularFolderView::async_icon_loading => true,
 
                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 8,
                    ViewParams::paint_details => false,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),
 
                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_LEFT,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::icon_dx => 10,
                    ViewItemParams::icon_dy => -5,
                    ViewItemParams::icon_width => 122,
                    ViewItemParams::icon_height => 70,
                    ViewItemParams::item_caption_width => 385,
                    ViewItemParams::item_caption_font_size => 3,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),
 
                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),   
			//4) 5x4 245x140
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 5,
                    ViewParams::num_rows => 4,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => false,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png'
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//5) 4x3 245x140
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => false,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.5,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//6) 4x4 245x140
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 4,
                    ViewParams::paint_details => true,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => false,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//7) 3x3 245x140
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => true,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => false,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.5,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//8) 3x6 85x85
			 array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 6,
                    ViewParams::paint_details => false,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_LEFT,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::icon_dx => 10,
                    ViewItemParams::icon_dy => -5,
                    ViewItemParams::icon_width => 85,
                    ViewItemParams::icon_height => 85,
                    ViewItemParams::item_caption_width => 435,
                    ViewItemParams::item_caption_font_size => FONT_SIZE_SMALL,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//9) 5x5 245x98
            array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 5,
                    ViewParams::num_rows => 5,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 98,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png'
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//10) 4x3 245x98
            array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 98,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => true,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.5,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//11) 4x5 245x98
            array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 5,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 98,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//12) 3x4 245x98
            array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 4,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 98,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.5,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//13) 5x5 210x120
			array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 5,
                    ViewParams::num_rows => 5,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 210,
                    ViewParams::sandwich_height => 120,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png'
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//14) 4x3 210x120
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 210,
                    ViewParams::sandwich_height => 120,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => true,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.5,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//15) 4x5 210x120
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 5,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 210,
                    ViewParams::sandwich_height => 120,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//16) 3x4 210x120
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 4,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 210,
                    ViewParams::sandwich_height => 120,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.5,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//17) 4x3 150x150
			array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 150,
                    ViewParams::sandwich_height => 150,
                    ViewParams::paint_path_box => true,
                    ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
					ViewParams::sandwich_icon_keep_aspect_ratio => true,
                    ViewParams::paint_content_box_background => true,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => true,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.25,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//18) 3x10 60x60
            array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 10,
                    ViewParams::paint_details => true,
                    ViewParams::paint_path_box => true,
                    ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                    ViewParams::paint_content_box_background => true,
                    ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_LEFT,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::icon_dx => 10,
                    ViewItemParams::icon_dy => -5,
                    ViewItemParams::icon_width => 60,
                    ViewItemParams::icon_height => 60,
                    ViewItemParams::item_caption_width => 250,
                    ViewItemParams::item_caption_font_size => FONT_SIZE_SMALL,
                    #ViewItemParams::item_caption_dy => HALIGN_RIGHT,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array
                (
                    ViewItemParams::icon_path => 'plugin_file://icons/mov_unset.png',
                    ViewItemParams::item_detailed_icon_path => 'missing://',
                ),
            ),
			//19) 5x5 100x100
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 5,
                    ViewParams::num_rows => 5,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 100,
                    ViewParams::sandwich_height => 100,
                    ViewParams::paint_path_box => true,
                    ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                    ViewParams::paint_content_box_background => true,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => false,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.0,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png'
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//20) 4x5 120x120
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 5,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 120,
                    ViewParams::sandwich_height => 120,
                    ViewParams::paint_path_box => true,
                    ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                    ViewParams::paint_content_box_background => true,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.0,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//21) 3x4 130x130
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 4,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 130,
                    ViewParams::sandwich_height => 130,
                    ViewParams::paint_path_box => true,
                    ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                    ViewParams::paint_content_box_background => true,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.25,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//22
            array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 2,
                    ViewParams::num_rows => 15,
                    ViewParams::paint_details => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_LEFT,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::icon_dx => 10,
                    ViewItemParams::icon_dy => -5,
                    ViewItemParams::icon_width => 40,
                    ViewItemParams::icon_height => 30,
                    ViewItemParams::item_caption_width => 525,
                    ViewItemParams::item_caption_font_size => FONT_SIZE_SMALL,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			//23
            array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 5,
                    ViewParams::num_rows => 4,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::paint_path_box => true,
                    ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                    ViewParams::paint_content_box_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png'
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),

            array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::paint_path_box => true,
                    ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                    ViewParams::paint_content_box_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.5,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),

            array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 4,
                    ViewParams::paint_details => true,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::paint_path_box => true,
                    ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                    ViewParams::paint_content_box_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),

            array
            (
                PluginRegularFolderView::async_icon_loading => true,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => true,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('channel_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::paint_path_box => true,
                    ViewParams::background_path=> self::get_plugin_ico('channel_list_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                    ViewParams::paint_content_box_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => false,
                    ViewItemParams::icon_scale_factor => 1.25,
                    ViewItemParams::icon_sel_scale_factor => 1.5,
                    ViewItemParams::icon_path => 'plugin_file://icons/channel_unset.png',
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			
        );
    }

public static function GET_TEXT_ONE_COL_VIEWS() {
        
        return array(
                array (
                        PluginRegularFolderView::async_icon_loading => false,
                        PluginRegularFolderView::view_params => array
                            (
                            ViewParams::num_cols => 1,
                            ViewParams::num_rows => 12,
							ViewParams::paint_details => true,
							ViewParams::background_path=> self::get_plugin_ico('one_col_bg'),
							ViewParams::background_order => 0,
							ViewParams::background_height => 1080,
							ViewParams::background_width => 1920,
							ViewParams::optimize_full_screen_background => true,
                        ),
                        PluginRegularFolderView::base_view_item_params =>
                        array
                            (
                            ViewItemParams::icon_path => 'missing://',
                            ViewItemParams::item_layout => HALIGN_LEFT,
                            ViewItemParams::icon_valign => VALIGN_CENTER,
                            ViewItemParams::icon_dx => 20,
                            ViewItemParams::icon_dy => -5,
                            ViewItemParams::item_caption_font_size => FONT_SIZE_NORMAL,
                            ViewItemParams::item_caption_width => 1550
                        ),
                        PluginRegularFolderView::not_loaded_view_item_params => array(),
                    ), 
            );
    }
	
    public static function GET_VOD_MOVIE_LIST_FOLDER_VIEWS()
	
    {
        return array(
			array
				(
                    PluginRegularFolderView::async_icon_loading => true,
					PluginRegularFolderView::view_params => array
					(
						ViewParams::num_cols => 5,
						ViewParams::num_rows => 2,
						ViewParams::paint_details => true,
						//ViewParams::detailed_icon_scale_factor => 0,
						ViewParams::paint_item_info_in_details => true,
						ViewParams::item_detailed_info_font_size => FONT_SIZE_NORMAL,

						ViewParams::paint_sandwich => true,
						ViewParams::sandwich_base => 'gui_skin://special_icons/sandwich_base.aai',
						ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
						ViewParams::sandwich_cover => 'cut_icon://{name=sandwich_cover}',
						ViewParams::sandwich_width => 190,
						ViewParams::sandwich_height => 290,
						ViewParams::sandwich_icon_upscale_enabled => true,
						ViewParams::sandwich_icon_keep_aspect_ratio => true,
						ViewParams::paint_item_info_in_details => true,
						ViewParams::item_detailed_info_auto_line_break => true,
						ViewParams::item_detailed_info_title_color => 10,
						ViewParams::item_detailed_info_text_color => 15,
						ViewParams::background_path=> self::get_plugin_ico('vod_list_bg'),
						ViewParams::background_order => 0,
						ViewParams::background_height => 1080,
						ViewParams::background_width => 1920,
						ViewParams::optimize_full_screen_background => true,
					),
                        
                        PluginRegularFolderView::not_loaded_view_item_params => array
                        (
                            ViewItemParams::item_paint_icon => true,
                            ViewItemParams::icon_width => 190,
                            ViewItemParams::icon_height => 290,
                            ViewItemParams::icon_path => 'plugin_file://icons/mov_unset.png'
                        ),

                        PluginRegularFolderView::base_view_item_params => array
                        (
                            ViewItemParams::item_paint_icon => true,
                            ViewItemParams::icon_sel_scale_factor =>1.2,
                            ViewItemParams::icon_path => 'gui_skin://small_icons/movie.aai',
                            ViewItemParams::item_layout => HALIGN_LEFT,
                            ViewItemParams::icon_valign => VALIGN_CENTER,
                            ViewItemParams::icon_dx => 10,
                            ViewItemParams::icon_dy => -5,
                            ViewItemParams::icon_width => 190,
                            ViewItemParams::icon_height => 290,
                            ViewItemParams::icon_sel_margin_top => 0,
                            ViewItemParams::item_paint_caption => false,
                            ViewItemParams::item_caption_width => 1100
                        ),
				),
				array
				(
                        PluginRegularFolderView::async_icon_loading => true,

                        PluginRegularFolderView::view_params => array
                        (
                            ViewParams::num_cols => 1,
                            ViewParams::num_rows => 3,
                            ViewParams::paint_details => true,
                            ViewParams::paint_item_info_in_details => true,
							ViewParams::item_detailed_info_auto_line_break => true,
							ViewParams::item_detailed_info_title_color => 10,
							ViewParams::item_detailed_info_text_color => 15,
							ViewParams::background_path=> self::get_plugin_ico('vod_list_bg'),
							ViewParams::background_order => 0,
							ViewParams::background_height => 1080,
							ViewParams::background_width => 1920,
							ViewParams::optimize_full_screen_background => true,

                            ViewParams::paint_sandwich => false,
                            ViewParams::sandwich_base => 'gui_skin://special_icons/sandwich_base.aai',
                            ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                            ViewParams::sandwich_cover => 'cut_icon://{name=sandwich_cover}',
                            ViewParams::sandwich_width => 190,
                            ViewParams::sandwich_height => 290,
                            ViewParams::sandwich_icon_upscale_enabled => true,
                            ViewParams::sandwich_icon_keep_aspect_ratio => true,
                        ),

                        PluginRegularFolderView::not_loaded_view_item_params => array
                        (
                            ViewItemParams::item_paint_icon => true,
                            ViewItemParams::icon_width => 150,
                            ViewItemParams::icon_height => 200,
                            ViewItemParams::icon_path => 'plugin_file://icons/mov_unset.png'
                        ),

                        PluginRegularFolderView::base_view_item_params => array
                        (
                            ViewItemParams::item_paint_icon => true,
                            ViewItemParams::icon_sel_scale_factor =>1.2,
                            ViewItemParams::icon_path => 'gui_skin://small_icons/movie.aai',
                            ViewItemParams::item_layout => HALIGN_LEFT,
                            ViewItemParams::icon_valign => VALIGN_CENTER,
                            ViewItemParams::icon_dx => 10,
                            ViewItemParams::icon_dy => -5,
                            ViewItemParams::icon_width => 150,
                            ViewItemParams::icon_height => 200,
                            ViewItemParams::icon_sel_margin_top => 0,
                            ViewItemParams::item_paint_caption => true,
                            ViewItemParams::item_caption_width => 950
                        ),
				),
				array
				(
                        PluginRegularFolderView::async_icon_loading => true,
                        PluginRegularFolderView::view_params => array
                        (
                            ViewParams::num_cols => 1,               
                            ViewParams::num_rows => 10,
                            ViewParams::paint_details => true,
                            ViewParams::paint_details => true,
                            ViewParams::paint_item_info_in_details => true,
							ViewParams::item_detailed_info_auto_line_break => true,
							ViewParams::item_detailed_info_title_color => 10,
							ViewParams::item_detailed_info_text_color => 15,
							ViewParams::background_path=> self::get_plugin_ico('vod_list_bg'),
							ViewParams::background_order => 0,
							ViewParams::background_height => 1080,
							ViewParams::background_width => 1920,
                            ViewParams::paint_item_info_in_details => true,
                            ViewParams::item_detailed_info_font_size => FONT_SIZE_NORMAL,

                            ViewParams::paint_sandwich => false,
                            ViewParams::sandwich_base => 'gui_skin://special_icons/sandwich_base.aai',
                            ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                            ViewParams::sandwich_cover => 'cut_icon://{name=sandwich_cover}',
                            ViewParams::sandwich_width => 190,
                            ViewParams::sandwich_height => 290,
                            ViewParams::sandwich_icon_upscale_enabled => true,
                            ViewParams::sandwich_icon_keep_aspect_ratio => true,
                        ),

                        PluginRegularFolderView::not_loaded_view_item_params => array
                        (
                            ViewItemParams::item_paint_icon => true,
                            ViewItemParams::icon_width => 50,
                            ViewItemParams::icon_height => 50,
                            ViewItemParams::icon_path => 'plugin_file://icons/mov_unset.png'
                        ),

                        PluginRegularFolderView::base_view_item_params => array
                        (
                            ViewItemParams::item_paint_icon => true,
                            ViewItemParams::icon_sel_scale_factor =>1.2,
                            ViewItemParams::icon_path => 'gui_skin://small_icons/movie.aai',
                            ViewItemParams::item_layout => HALIGN_LEFT,
                            ViewItemParams::icon_valign => VALIGN_CENTER,
                            ViewItemParams::icon_dx => 10,
                            ViewItemParams::icon_dy => -5,
                            ViewItemParams::icon_width => 50,
                            ViewItemParams::icon_height => 50,
                            ViewItemParams::icon_sel_margin_top => 0,
                            ViewItemParams::item_paint_caption => true,
                            ViewItemParams::item_caption_width => 1100
                        ),
				),
				
		);
    }

    public static function GET_VOD_CATEGORY_LIST_FOLDER_VIEWS()
    {
        return array(
			
            array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => true,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('category_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('category_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => true,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 3,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => true,
                    ViewParams::paint_sandwich => false,
                    // ViewParams::sandwich_base => self::get_plugin_ico('category_sandwich_base'),
                    // ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    // ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 250,
                    ViewParams::sandwich_height => 199,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => false,
					ViewParams::background_path=> self::get_plugin_ico('category_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
					ViewParams::paint_icon_selection_box => false,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => true,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),
			array
            (
                PluginRegularFolderView::async_icon_loading => false,

                PluginRegularFolderView::view_params => array
                (
                    ViewParams::num_cols => 4,
                    ViewParams::num_rows => 3,
                    ViewParams::paint_details => false,
                    ViewParams::paint_sandwich => true,
                    ViewParams::sandwich_base => self::get_plugin_ico('category_sandwich_base'),
                    ViewParams::sandwich_mask => 'cut_icon://{name=sandwich_mask}',
                    ViewParams::sandwich_cover => self::get_plugin_ico('sandwich_cover'),
                    ViewParams::sandwich_width => 245,
                    ViewParams::sandwich_height => 140,
                    ViewParams::sandwich_icon_upscale_enabled => true,
                    ViewParams::sandwich_icon_keep_aspect_ratio => true,
					ViewParams::background_path=> self::get_plugin_ico('category_bg'),
					ViewParams::background_order => 0,
					ViewParams::background_height => 1080,
					ViewParams::background_width => 1920,
					ViewParams::optimize_full_screen_background => true,
                ),

                PluginRegularFolderView::base_view_item_params => array
                (
                    ViewItemParams::item_paint_icon => true,
                    ViewItemParams::item_layout => HALIGN_CENTER,
                    ViewItemParams::icon_valign => VALIGN_CENTER,
                    ViewItemParams::item_paint_caption => true,
                    ViewItemParams::icon_scale_factor => 1.0,
                    ViewItemParams::icon_sel_scale_factor => 1.2,
                ),

                PluginRegularFolderView::not_loaded_view_item_params => array (),
            ),

        );
    }
}

?>
