<?php
///////////////////////////////////////////////////////////////////////////

require_once 'lib/tv/default_channel.php';

///////////////////////////////////////////////////////////////////////////

class SmartChannel extends DefaultChannel
{
    private $number;
    private $past_epg_days;
    private $future_epg_days;

    ///////////////////////////////////////////////////////////////////////

    public function __construct(
        $id, 
		$title, 
		$icon_url, 
		$streaming_url, 
		$number, 
		$past_epg_days, 
		$future_epg_days,
		$is_protected, 
		$buf_time,
		$has_archive
	)
    {
        parent::__construct($id, $title, $icon_url, $streaming_url);

        $this->number = $number;
        $this->past_epg_days = $past_epg_days;
        $this->future_epg_days = $future_epg_days;
		$this->is_protected = $is_protected;
		$this->buf_time = $buf_time;
		$this->has_archive = $has_archive;
    }

    ///////////////////////////////////////////////////////////////////////

    public function get_number()
    { return $this->number; }

    public function get_past_epg_days()
    { return $this->past_epg_days; }

    public function get_future_epg_days()
    { return $this->future_epg_days; }
	
	 public function is_protected()
    { return $this->is_protected; }
	
	public function get_buffering_ms()
    { return $this->buf_time; }
    	
	public function has_archive()
    { return $this->has_archive; }
		
	public function get_timeshift_hours() 
	 { return 4; }
}

///////////////////////////////////////////////////////////////////////////
?>
