import json
import urllib.request
import urllib.error
import urllib.parse
from . import loghelper as log
from . import tinycache as cache


CACHE = None
CACHE_TTL_DEFAULT = 60
NO_CACHE_URLS = []


def get(url, data=None):
    if data is None:
        data = {}
    resp_body = None
    req_url = ''
    try:
        req_url = "{0}?{1}".format(url, urllib.parse.urlencode(data))
        if CACHE is not None:
            cached = CACHE.get(req_url)
            if cached:
                log.write_line('cache hit for url %s' % req_url, log.LOG_LEVEL_DEBUG)
                return cached

        log.write_line('No cache for %s found. Requesting from web' % req_url, log.LOG_LEVEL_DEBUG)
        req = urllib.request.Request(req_url)
        req.add_header('User-Agent', 'XBMC (video.torrent.tv)')
        with urllib.request.urlopen(req, timeout=5) as resp:
            resp_body = resp.read().decode('utf-8')
    except Exception as e:
        log.write_line("Could not execute get request: {0}".format(e), log_level=log.LOG_LEVEL_ERROR)
    if resp_body and req_url:
        if CACHE is not None:
            if url not in NO_CACHE_URLS:
                CACHE.set(req_url, resp_body, CACHE_TTL_DEFAULT)
    return resp_body


def get_json(url, data=None):
    resp = get(url, data)
    if resp is not None:
        return json.loads(resp)
    return None
